/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.phosphosite;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Site {
    private static final Logger logger = LoggerFactory.getLogger(Site.class);
    String protein;
    String uniprot;
    String geneSymb;
    String chrLoc;
    String modType;
    String residue;
    String group;
    String organism;

    public static List<Site> parseSites(File f) throws IOException {
        GZIPInputStream gzipStream;
        try (FileInputStream inStream = new FileInputStream(f);){
            gzipStream = new GZIPInputStream(inStream);
        }
        InputStreamReader decoder = new InputStreamReader(gzipStream);
        BufferedReader buf = new BufferedReader(decoder);
        String line = null;
        ArrayList<Site> data = new ArrayList<Site>();
        List<String> headerFields = null;
        int proteinIndex = -1;
        int uniprotIndex = -1;
        int residueIndex = -1;
        int orgIndex = -1;
        int groupIndex = -1;
        int geneIndex = -1;
        boolean inHeader = true;
        while ((line = buf.readLine()) != null) {
            if (line.startsWith("GENE") || line.startsWith("PROTEIN")) {
                headerFields = Site.parseHeaderFields(line);
                proteinIndex = headerFields.indexOf("PROTEIN");
                uniprotIndex = headerFields.indexOf("ACC_ID");
                residueIndex = headerFields.indexOf("MOD_RSD");
                orgIndex = headerFields.indexOf("ORGANISM");
                groupIndex = headerFields.indexOf("SITE_GRP_ID");
                geneIndex = headerFields.indexOf("GENE");
                inHeader = false;
                continue;
            }
            if (inHeader || line.trim().length() == 0) continue;
            String[] spl = line.split("\t");
            if (spl.length < 5) {
                logger.info("Found wrong line length: " + line);
                continue;
            }
            String protein = spl[proteinIndex];
            String uniprot = spl[uniprotIndex];
            String residue = spl[residueIndex];
            String[] resSpl = residue.split("-");
            String modType = null;
            if (resSpl.length == 2) {
                modType = resSpl[1];
            }
            String group = spl[groupIndex];
            String organism = spl[orgIndex];
            String geneSymb = spl[geneIndex];
            Site s = new Site();
            s.setProtein(protein);
            s.setUniprot(uniprot);
            s.setGeneSymb(geneSymb);
            s.setModType(modType);
            s.setResidue(residue);
            s.setGroup(group);
            s.setOrganism(organism);
            data.add(s);
        }
        buf.close();
        return data;
    }

    private static List<String> parseHeaderFields(String line) {
        String[] spl = line.split("\t");
        ArrayList<String> h = new ArrayList<String>();
        for (String s : spl) {
            h.add(s);
        }
        return h;
    }

    public String getProtein() {
        return this.protein;
    }

    public void setProtein(String protein) {
        this.protein = protein;
    }

    public String getUniprot() {
        return this.uniprot;
    }

    public void setUniprot(String uniprot) {
        this.uniprot = uniprot;
    }

    public String getGeneSymb() {
        return this.geneSymb;
    }

    public void setGeneSymb(String geneSymb) {
        this.geneSymb = geneSymb;
    }

    public String getChrLoc() {
        return this.chrLoc;
    }

    public void setChrLoc(String chrLoc) {
        this.chrLoc = chrLoc;
    }

    public String getModType() {
        return this.modType;
    }

    public void setModType(String modType) {
        this.modType = modType;
    }

    public String getResidue() {
        return this.residue;
    }

    public void setResidue(String residue) {
        this.residue = residue;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getOrganism() {
        return this.organism;
    }

    public void setOrganism(String organism) {
        this.organism = organism;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Site{protein='" + this.protein + "'");
        if (this.uniprot != null) {
            s.append(", uniprot='" + this.uniprot + "'");
        }
        if (this.geneSymb != null) {
            s.append(", geneSymb='" + this.geneSymb + "'");
        }
        if (this.chrLoc != null) {
            s.append(", chrLoc='" + this.chrLoc + "'");
        }
        if (this.modType != null) {
            s.append(", modType='" + this.modType + "'");
        }
        if (this.residue != null) {
            s.append(", residue='" + this.residue + "'");
        }
        if (this.group != null) {
            s.append(", group='" + this.group + "'");
        }
        if (this.organism != null) {
            s.append(", organism='" + this.organism + "'");
        }
        s.append('}');
        return s.toString();
    }
}

