/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod.structure;

import org.biojava.nbio.protmod.structure.StructureAtom;

public class StructureAtomLinkage {
    private final StructureAtom atom1;
    private final StructureAtom atom2;
    private final double distance;

    public StructureAtomLinkage(StructureAtom atom1, StructureAtom atom2, double distance) {
        if (atom1 == null || atom2 == null) {
            throw new IllegalArgumentException("Null atom(s)");
        }
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.distance = distance;
    }

    public StructureAtom getAtom1() {
        return this.atom1;
    }

    public StructureAtom getAtom2() {
        return this.atom2;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StructureAtomLinkage)) {
            return false;
        }
        StructureAtomLinkage aLink = (StructureAtomLinkage)obj;
        if (aLink.atom1.equals(this.atom1) && aLink.atom2.equals(this.atom2)) {
            return true;
        }
        return aLink.atom1.equals(this.atom2) && aLink.atom2.equals(this.atom1);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.atom1.hashCode() + this.atom2.hashCode();
        return result;
    }

    public String toString() {
        Object dat = this.atom1.toString() + "-" + this.atom2.toString() + " distance: " + String.format("%.2f", this.distance);
        dat = ((String)dat).replaceAll("\t", " ");
        return dat;
    }
}

