/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentJmolDisplay;
import org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;
import org.biojava.nbio.structure.align.xml.AFPChainXMLParser;
import org.biojava.nbio.structure.align.xml.MultipleAlignmentXMLParser;

public class MyAlignmentLoadListener
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                String str;
                InputStreamProvider ip = new InputStreamProvider();
                InputStream stream = ip.getInputStream(file);
                BufferedReader in = new BufferedReader(new InputStreamReader(stream));
                StringBuffer input = new StringBuffer();
                while ((str = in.readLine()) != null) {
                    input.append(str);
                }
                in.close();
                String xml = input.toString();
                if (xml.contains("MultipleAlignmentEnsemble")) {
                    List ensembles = MultipleAlignmentXMLParser.parseXMLfile((String)xml);
                    for (MultipleAlignmentEnsemble e : ensembles) {
                        for (MultipleAlignment msa : e.getMultipleAlignments()) {
                            MultipleAlignmentJmolDisplay.display(msa);
                        }
                    }
                } else {
                    AFPChain[] afps = AFPChainXMLParser.parseMultiXML((String)xml);
                    UserConfiguration conf = WebStartMain.getWebStartConfig();
                    AtomCache cache = new AtomCache(conf.getPdbFilePath(), conf.getCacheFilePath());
                    for (AFPChain afpChain : afps) {
                        Atom[] ca1 = cache.getAtoms(afpChain.getName1());
                        Atom[] ca2 = cache.getAtoms(afpChain.getName2());
                        AFPChainXMLParser.rebuildAFPChain((AFPChain)afpChain, (Atom[])ca1, (Atom[])ca2);
                        StructureAlignmentJmol jmol = StructureAlignmentDisplay.display(afpChain, ca1, ca2);
                        DisplayAFP.showAlignmentPanel(afpChain, ca1, ca2, jmol);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Could not load alignment file. Exception: " + e.getMessage());
            }
        }
    }
}

