/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.aligpanel;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.BitSet;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.JPrintPanel;
import org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.aligpanel.AFPChainCoordManager;
import org.biojava.nbio.structure.align.gui.aligpanel.AligPanelMouseMotionListener;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.model.AfpChainWriter;
import org.biojava.nbio.structure.align.util.AFPAlignmentDisplay;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;
import org.biojava.nbio.structure.align.xml.AFPChainXMLParser;
import org.biojava.nbio.structure.gui.events.AlignmentPositionListener;
import org.biojava.nbio.structure.gui.util.AlignedPosition;
import org.biojava.nbio.structure.gui.util.color.ColorUtils;

public class AligPanel
extends JPrintPanel
implements AlignmentPositionListener,
WindowListener {
    private static final long serialVersionUID = -6892229111166263764L;
    private AFPChain afpChain;
    private AFPChainCoordManager coordManager;
    private Font seqFont;
    private Font eqFont;
    private AbstractAlignmentJmol jmol;
    private AligPanelMouseMotionListener mouseMoLi;
    private BitSet selection;
    private boolean selectionLocked;
    private Atom[] ca1;
    private Atom[] ca2;
    private boolean colorBySimilarity;
    private boolean colorByAlignmentBlock;
    private static final Color COLOR_EQUAL = Color.decode("#6A93D4");
    private static final Color COLOR_SIMILAR = Color.decode("#D460CF");

    public static void main(String[] args) {
        String file = "/Users/ap3/tmp/4hhb.ce";
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(file));
            StringBuffer xml = new StringBuffer();
            while ((str = in.readLine()) != null) {
                xml.append(str);
            }
            in.close();
            AFPChain[] afps = AFPChainXMLParser.parseMultiXML((String)xml.toString());
            AFPChain afpChain = afps[0];
            UserConfiguration config = WebStartMain.getWebStartConfig();
            AtomCache cache = new AtomCache(config.getPdbFilePath(), config.getCacheFilePath());
            Atom[] ca1 = cache.getAtoms(afpChain.getName1());
            Atom[] ca2 = cache.getAtoms(afpChain.getName2());
            AFPChainXMLParser.rebuildAFPChain((AFPChain)afpChain, (Atom[])ca1, (Atom[])ca2);
            StructureAlignmentJmol jmol = StructureAlignmentDisplay.display(afpChain, ca1, ca2);
            DisplayAFP.showAlignmentPanel(afpChain, ca1, ca2, jmol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AligPanel() {
        this.setBackground(Color.white);
        this.coordManager = new AFPChainCoordManager();
        this.seqFont = new Font("SansSerif", 0, 12);
        this.eqFont = new Font("SansSerif", 1, 12);
        this.mouseMoLi = new AligPanelMouseMotionListener(this);
        this.addMouseMotionListener(this.mouseMoLi);
        this.addMouseListener(this.mouseMoLi);
        this.mouseMoLi.addAligPosListener(this);
        this.selection = new BitSet();
        this.colorBySimilarity = false;
        this.colorByAlignmentBlock = false;
    }

    public AFPChainCoordManager getCoordManager() {
        return this.coordManager;
    }

    public void addAlignmentPositionListener(AlignmentPositionListener li) {
        this.mouseMoLi.addAligPosListener(li);
    }

    public void destroy() {
        this.setAFPChain(null);
        this.mouseMoLi.destroy();
        this.jmol = null;
        this.ca1 = null;
        this.ca2 = null;
        this.selection = null;
    }

    public AFPChain getAFPChain() {
        return this.afpChain;
    }

    public void setAFPChain(AFPChain afpChain) {
        this.afpChain = afpChain;
        this.coordManager.setAFPChain(afpChain);
        if (afpChain != null) {
            this.selection = new BitSet(afpChain.getAlnLength());
            if (afpChain.getBlockNum() > 1) {
                this.colorByAlignmentBlock = true;
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        char[] seq1 = this.afpChain.getAlnseq1();
        char[] seq2 = this.afpChain.getAlnseq2();
        char[] symb = this.afpChain.getAlnsymb();
        int startpos = 0;
        int endpos = this.afpChain.getAlnLength();
        String summary = this.afpChain.toString();
        g2D.drawString(summary, 20, this.coordManager.getSummaryPos());
        Color significantCol = Color.red;
        if (this.afpChain.isSignificantResult()) {
            significantCol = Color.green;
        }
        g2D.setPaint(significantCol);
        Rectangle sig = new Rectangle(10, 10, 10, 10);
        g2D.fill(sig);
        boolean isFATCAT = false;
        if (this.afpChain.getAlgorithmName().startsWith("jFatCat")) {
            isFATCAT = true;
        }
        for (int i = startpos; i <= endpos && i < this.afpChain.getAlnLength(); ++i) {
            Rectangle rec;
            Color bg;
            char s;
            char c1 = seq1[i];
            char c2 = seq2[i];
            boolean isGapped = false;
            g2D.setFont(this.seqFont);
            List<Integer> alignedPos = null;
            if (this.colorByAlignmentBlock) {
                alignedPos = DisplayAFP.getEQRAlignmentPos(this.afpChain);
            }
            if (isFATCAT) {
                s = symb[i];
                if (s != ' ') {
                    isGapped = false;
                    g2D.setFont(this.eqFont);
                } else {
                    isGapped = true;
                }
            } else {
                s = symb[i];
                if (c1 != '-' && c2 != '-' && s != ' ') {
                    g2D.setFont(this.eqFont);
                } else {
                    isGapped = true;
                }
            }
            Point p1 = this.coordManager.getPanelPos(0, i);
            int xpos1 = p1.x;
            int ypos1 = p1.y;
            Point p2 = this.coordManager.getPanelPos(1, i);
            int xpos2 = p2.x;
            int ypos2 = p2.y;
            int blockNum = this.afpChain.getBlockNum();
            if (!isGapped) {
                bg = Color.white;
                Color bg2 = Color.white;
                Color end1 = ColorUtils.rotateHue(ColorUtils.orange, 0.041666668f * (float)blockNum);
                Color end2 = ColorUtils.rotateHue(ColorUtils.cyan, 0.041666668f * (float)(blockNum + 1));
                if (this.colorByAlignmentBlock) {
                    if (!alignedPos.contains(i)) {
                        bg = Color.white;
                        bg2 = Color.white;
                    } else {
                        int colorPos = 0;
                        if (isFATCAT) {
                            int block = 0;
                            char s2 = symb[i];
                            try {
                                block = Integer.parseInt(String.valueOf(s2)) - 1;
                                bg = ColorUtils.getIntermediate(ColorUtils.orange, end1, blockNum, block);
                                bg2 = ColorUtils.getIntermediate(ColorUtils.cyan, end2, blockNum, block);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (colorPos > ColorUtils.colorWheel.length) {
                                colorPos = ColorUtils.colorWheel.length % colorPos;
                            }
                        } else {
                            colorPos = AFPAlignmentDisplay.getBlockNrForAlignPos((AFPChain)this.afpChain, (int)i);
                            bg = ColorUtils.getIntermediate(ColorUtils.orange, end1, blockNum, colorPos);
                            bg2 = ColorUtils.getIntermediate(ColorUtils.cyan, end2, blockNum, colorPos);
                        }
                    }
                } else {
                    bg = Color.LIGHT_GRAY;
                    bg2 = Color.LIGHT_GRAY;
                }
                g2D.setPaint(bg);
                Rectangle rec2 = new Rectangle(p1.x - 1, p1.y - 11, p2.x - p1.x + 12, p2.y - p1.y + 1);
                g2D.fill(rec2);
                g2D.setPaint(bg2);
                Rectangle rec22 = new Rectangle(p1.x - 1, p1.y + 4, p2.x - p1.x + 12, p2.y - p1.y - 3);
                g2D.fill(rec22);
            }
            if (this.colorBySimilarity) {
                if (c1 == c2) {
                    bg = COLOR_EQUAL;
                    g2D.setPaint(bg);
                    rec = new Rectangle(p1.x - 1, p1.y - 11, p2.x - p1.x + 12, p2.y - p1.y + 12);
                    g2D.fill(rec);
                } else if (AFPAlignmentDisplay.aaScore((char)c1, (char)c2) > 0) {
                    bg = COLOR_SIMILAR;
                    g2D.setPaint(bg);
                    rec = new Rectangle(p1.x - 1, p1.y - 11, p2.x - p1.x + 12, p2.y - p1.y + 12);
                    g2D.fill(rec);
                }
            }
            if (this.isSelected(i)) {
                bg = Color.YELLOW;
                g2D.setPaint(bg);
                rec = new Rectangle(p1.x - 1, p1.y - 11, p2.x - p1.x + 12, p2.y - p1.y + 12);
                g2D.fill(rec);
            }
            g2D.setColor(Color.black);
            g2D.drawString(String.valueOf(c1), xpos1, ypos1);
            g2D.drawString(String.valueOf(c2), xpos2, ypos2);
        }
        int nrLines = (this.afpChain.getAlnLength() - 1) / 70;
        for (int i = 0; i <= nrLines; ++i) {
            try {
                Point p1 = this.coordManager.getLegendPosition(i, 0);
                Point p2 = this.coordManager.getLegendPosition(i, 1);
                int aligPos = i * 70;
                Atom a1 = DisplayAFP.getAtomForAligPos(this.afpChain, 0, aligPos, this.ca1, false);
                Atom a2 = DisplayAFP.getAtomForAligPos(this.afpChain, 1, aligPos, this.ca2, false);
                String label1 = JmolTools.getPdbInfo(a1, false);
                String label2 = JmolTools.getPdbInfo(a2, false);
                g2D.drawString(label1, p1.x, p1.y);
                g2D.drawString(label2, p2.x, p2.y);
                Point p3 = this.coordManager.getEndLegendPosition(i, 0);
                Point p4 = this.coordManager.getEndLegendPosition(i, 1);
                aligPos = i * 70 + 70 - 1;
                if (aligPos > this.afpChain.getAlnLength()) {
                    aligPos = this.afpChain.getAlnLength() - 1;
                }
                Atom a3 = DisplayAFP.getAtomForAligPos(this.afpChain, 0, aligPos, this.ca1, true);
                Atom a4 = DisplayAFP.getAtomForAligPos(this.afpChain, 1, aligPos, this.ca2, true);
                String label3 = JmolTools.getPdbInfo(a3, false);
                String label4 = JmolTools.getPdbInfo(a4, false);
                g2D.drawString(label3, p3.x, p3.y);
                g2D.drawString(label4, p4.x, p4.y);
                continue;
            }
            catch (StructureException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isSelected(int alignmentPosition) {
        return this.selection.get(alignmentPosition);
    }

    @Override
    public void mouseOverPosition(AlignedPosition p) {
        if (!this.selectionLocked) {
            this.selection.clear();
        }
        this.selection.set(p.getPos1());
        this.updateJmolDisplay();
        this.repaint();
    }

    private void updateJmolDisplay() {
        if (this.jmol == null) {
            return;
        }
        int size = this.afpChain.getAlnLength();
        StringBuffer cmd = new StringBuffer("select ");
        int nrSelected = 0;
        try {
            for (int i = 0; i < size; ++i) {
                if (!this.selection.get(i)) continue;
                Atom a1 = DisplayAFP.getAtomForAligPos(this.afpChain, 0, i, this.ca1, false);
                Atom a2 = DisplayAFP.getAtomForAligPos(this.afpChain, 1, i, this.ca2, false);
                String select1 = "";
                if (a1 != null) {
                    select1 = JmolTools.getPdbInfo(a1);
                }
                String select2 = "";
                if (a2 != null) {
                    select2 = JmolTools.getPdbInfo(a2);
                }
                if (select1.equals("") && select2.equals("")) continue;
                if (nrSelected > 0) {
                    cmd.append(", ");
                }
                cmd.append(select1);
                cmd.append("/1, ");
                cmd.append(select2);
                cmd.append("/2");
                ++nrSelected;
            }
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
        if (nrSelected == 0) {
            cmd.append(" none;");
        } else {
            cmd.append("; set display selected;");
        }
        this.jmol.evalString(cmd.toString());
    }

    @Override
    public void positionSelected(AlignedPosition p) {
        this.mouseOverPosition(p);
    }

    @Override
    public void rangeSelected(AlignedPosition start, AlignedPosition end) {
        if (!this.selectionLocked) {
            this.selection.clear();
        }
        this.selection.set(start.getPos1(), end.getPos1() + 1);
        this.updateJmolDisplay();
        this.repaint();
    }

    @Override
    public void selectionLocked() {
        this.selectionLocked = true;
    }

    @Override
    public void selectionUnlocked() {
        this.selectionLocked = false;
        this.selection.clear();
        this.repaint();
    }

    @Override
    public void toggleSelection(AlignedPosition p) {
        this.selection.flip(p.getPos1());
        this.updateJmolDisplay();
        this.repaint();
    }

    public void setAlignmentJmol(AbstractAlignmentJmol jmol) {
        this.jmol = jmol;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.destroy();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Print")) {
            super.actionPerformed(e);
        } else if (cmd.equals("View Text Only")) {
            String result = AfpChainWriter.toWebSiteDisplay((AFPChain)this.afpChain, (Atom[])this.ca1, (Atom[])this.ca2);
            DisplayAFP.showAlignmentImage(this.afpChain, result);
        } else if (cmd.equals("View Aligned Pairs")) {
            String result = AfpChainWriter.toAlignedPairs((AFPChain)this.afpChain, (Atom[])this.ca1, (Atom[])this.ca2);
            DisplayAFP.showAlignmentImage(this.afpChain, result);
        } else if (cmd.equals("View as FATCAT result")) {
            String result = this.afpChain.toFatcat(this.ca1, this.ca2);
            result = result + AFPChain.newline;
            result = result + this.afpChain.toRotMat();
            DisplayAFP.showAlignmentImage(this.afpChain, result);
        } else if (cmd.equals("Select Equivalent Positions")) {
            this.selectEQR();
        } else if (cmd.equals("Color By Similarity")) {
            this.colorBySimilarity(true);
        } else if (cmd.equals("Color By EQR")) {
            this.colorBySimilarity(false);
        } else if (cmd.equals("Color By Alignment Block")) {
            this.colorByAlignmentBlock();
        } else {
            System.err.println("Unknown command:" + cmd);
        }
    }

    private void colorByAlignmentBlock() {
        this.colorByAlignmentBlock = true;
        this.colorBySimilarity = false;
        this.repaint();
    }

    private void colorBySimilarity(boolean flag) {
        this.colorBySimilarity = flag;
        this.colorByAlignmentBlock = false;
        this.repaint();
    }

    private void selectEQR() {
        this.selection.clear();
        List<Integer> pos1 = DisplayAFP.getEQRAlignmentPos(this.afpChain);
        for (int pos : pos1) {
            this.selection.flip(pos);
        }
        this.mouseMoLi.triggerSelectionLocked(true);
        this.updateJmolDisplay();
        this.repaint();
    }

    public Atom[] getCa1() {
        return this.ca1;
    }

    public void setCa1(Atom[] ca1) {
        this.ca1 = ca1;
    }

    public Atom[] getCa2() {
        return this.ca2;
    }

    public void setCa2(Atom[] ca2) {
        this.ca2 = ca2;
    }
}

