/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.StructurePairAligner;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.nbio.structure.gui.events.AlignmentPositionListener;
import org.biojava.nbio.structure.gui.util.AlignedPosition;
import org.biojava.nbio.structure.gui.util.SequenceMouseListener;
import org.biojava.nbio.structure.gui.util.SequenceScalePanel;
import org.biojava.nbio.structure.io.PDBFileReader;

public class SequenceDisplay
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -1829252532712454236L;
    Structure structure1 = null;
    Structure structure2 = null;
    AlternativeAlignment alig = null;
    StructurePairAligner structurePairAligner;
    SequenceScalePanel panel1;
    SequenceScalePanel panel2;
    JSlider residueSizeSlider;
    JLabel percentageDisplay;
    int[] idx1;
    int[] idx2;
    public static final int MAX_SCALE = 10;
    List<AlignedPosition> apos;
    float scale;
    SequenceMouseListener mouseListener1;
    SequenceMouseListener mouseListener2;
    JLabel label1;
    JLabel label2;

    public static void main(String[] args) {
        try {
            PDBFileReader pdbr = new PDBFileReader();
            String pdb1 = "1buz";
            String pdb2 = "5pti";
            StructurePairAligner sc = new StructurePairAligner();
            System.out.println("aligning " + pdb1 + " vs. " + pdb2);
            Structure s1 = pdbr.getStructureById(pdb1);
            Structure s2 = pdbr.getStructureById(pdb2);
            sc.align(s1, s2);
            AlternativeAlignment[] aligs = sc.getAlignments();
            SequenceDisplay displ = new SequenceDisplay(sc);
            displ.setStructure1(s1);
            displ.setStructure2(s2);
            displ.setAlternativeAlignment(aligs[0]);
            displ.updateDisplay();
            JFrame frame = new JFrame("Sequences for AlternativeAlignment [0]");
            frame.getContentPane().add(displ);
            frame.pack();
            frame.setVisible(true);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JFrame f = (JFrame)e.getSource();
                    f.setVisible(false);
                    f.dispose();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SequenceDisplay(StructurePairAligner structurePairAligner) {
        this.structurePairAligner = structurePairAligner;
        this.panel1 = new SequenceScalePanel(1);
        this.panel2 = new SequenceScalePanel(2);
        this.mouseListener1 = new SequenceMouseListener(this);
        this.panel1.addMouseListener(this.mouseListener1);
        this.panel1.addMouseMotionListener(this.mouseListener1);
        this.mouseListener2 = new SequenceMouseListener(this);
        this.panel2.addMouseListener(this.mouseListener2);
        this.panel2.addMouseMotionListener(this.mouseListener2);
        Box vBox = Box.createVerticalBox();
        Box hBox1 = Box.createHorizontalBox();
        Box hBox2 = Box.createHorizontalBox();
        this.label1 = new JLabel();
        hBox1.add(this.label1);
        this.label2 = new JLabel();
        hBox2.add(this.label2);
        hBox1.add(this.panel1);
        hBox2.add(this.panel2);
        vBox.add(hBox1);
        vBox.add(hBox2);
        int RES_MIN = 1;
        int RES_MAX = 100;
        int RES_INIT = 100;
        this.residueSizeSlider = new JSlider(0, RES_MIN, RES_MAX, RES_INIT);
        this.residueSizeSlider.setInverted(true);
        this.residueSizeSlider.setPaintTicks(false);
        this.residueSizeSlider.setPaintLabels(false);
        this.residueSizeSlider.addChangeListener(this);
        this.percentageDisplay = new JLabel("100 %");
        Box hBox = Box.createHorizontalBox();
        hBox.setBackground(Color.white);
        hBox.add(Box.createHorizontalGlue());
        hBox.add(this.residueSizeSlider);
        hBox.add(this.percentageDisplay);
        hBox.add(Box.createHorizontalGlue());
        JScrollPane scroll = new JScrollPane(vBox);
        Box vBox2 = Box.createVerticalBox();
        vBox2.add(scroll);
        vBox2.add(hBox);
        this.setPreferredSize(new Dimension(500, 100));
        this.add(vBox2);
        this.setLayout(new BoxLayout(this, 1));
        this.apos = new ArrayList<AlignedPosition>();
    }

    public void clearListeners() {
        this.mouseListener1.clearListeners();
        this.mouseListener2.clearListeners();
    }

    public void addAlignmentPositionListener(AlignmentPositionListener li) {
        this.mouseListener1.addAlignmentPositionListener(li);
        this.mouseListener2.addAlignmentPositionListener(li);
    }

    public StructurePairAligner getStructurePairAligner() {
        return this.structurePairAligner;
    }

    public void setStructurePairAligner(StructurePairAligner structurePairAligner) {
        this.structurePairAligner = structurePairAligner;
    }

    public int[] getIdx1() {
        return this.idx1;
    }

    private void setIdx1(int[] idx) {
        this.idx1 = idx;
    }

    public int[] getIdx2() {
        return this.idx2;
    }

    private void setIdx2(int[] idx) {
        this.idx2 = idx;
    }

    private void buildAligMap() {
        this.apos.clear();
        int gap = 0;
        int gpos1 = 0;
        int gpos2 = 0;
        for (int pos = 0; pos < this.idx1.length; ++pos) {
            AlignedPosition m;
            int p1 = this.idx1[pos];
            int p2 = this.idx2[pos];
            int end = Math.max(p1, p2);
            while (gap < end) {
                m = new AlignedPosition();
                if (gpos1 < p1) {
                    m.setPos1(gpos1);
                    ++gpos1;
                }
                if (gpos2 < p2) {
                    m.setPos2(gpos2);
                    ++gpos2;
                }
                m.setEquivalent(0);
                this.apos.add(m);
                ++gap;
            }
            m = new AlignedPosition();
            m.setPos1(p1);
            m.setPos2(p2);
            m.setEquivalent(1);
            this.apos.add(m);
            ++gpos1;
            ++gpos2;
            ++gap;
        }
    }

    private void setAtoms(Structure s, SequenceScalePanel panel) {
        if (this.structurePairAligner == null) {
            System.err.println("StructurePairAligner has not been set");
            return;
        }
        Atom[] ca1 = this.structurePairAligner.getAlignmentAtoms(s);
        ChainImpl c = new ChainImpl();
        c.setChainID("1");
        for (Atom atom : ca1) {
            Group g = atom.getGroup();
            Chain parentChain = g.getChain();
            c.addGroup(g);
            g.setChain(parentChain);
        }
        panel.setChain((Chain)c);
    }

    public void setStructure1(Structure structure) {
        this.structure1 = structure;
        if (structure != null) {
            this.setAtoms(this.structure1, this.panel1);
            this.label1.setText(structure.getPDBCode());
            this.label1.repaint();
        }
    }

    public void setStructure2(Structure structure) {
        this.structure2 = structure;
        if (structure != null) {
            this.setAtoms(this.structure2, this.panel2);
            this.label2.setText(structure.getPDBCode());
            this.label2.repaint();
        }
    }

    public void setAlternativeAlignment(AlternativeAlignment alig) {
        this.alig = alig;
        this.setIdx1(alig.getIdx1());
        this.setIdx2(alig.getIdx2());
        this.buildAligMap();
        this.panel1.setAligMap(this.apos);
        this.panel2.setAligMap(this.apos);
        this.updateDisplay();
    }

    public List<AlignedPosition> getAligMap() {
        return this.apos;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int residueSize = source.getValue();
        this.calcScale(residueSize);
        this.updatePercentageDisplay();
        this.repaint();
        this.revalidate();
    }

    public void updateDisplay() {
        int residueSize = this.residueSizeSlider.getValue();
        this.calcScale(residueSize);
        this.updatePercentageDisplay();
        this.repaint();
        this.revalidate();
    }

    private void updatePercentageDisplay() {
        int perc = this.residueSizeSlider.getValue();
        this.percentageDisplay.setText(perc + " %");
    }

    private int getMaxSequenceLength() {
        int l2;
        int l1 = this.panel1.getChain().getAtomGroups(GroupType.AMINOACID).size();
        if (l1 > (l2 = this.panel2.getChain().getAtomGroups(GroupType.AMINOACID).size())) {
            return l1;
        }
        return l2;
    }

    private float getScaleForZoom(int zoomFactor) {
        if (zoomFactor > 100) {
            zoomFactor = 100;
        }
        if (zoomFactor < 1) {
            zoomFactor = 1;
        }
        int DEFAULT_X_START = 10;
        int DEFAULT_X_RIGHT_BORDER = 40;
        int seqLength = this.getMaxSequenceLength();
        int width = this.getWidth();
        float s = (float)width / (float)(seqLength + DEFAULT_X_START + DEFAULT_X_RIGHT_BORDER);
        if ((s = 100.0f * s / ((float)zoomFactor * 1.0f)) > 10.0f) {
            s = 10.0f;
        }
        return s;
    }

    public void calcScale(int zoomFactor) {
        float s;
        this.scale = s = this.getScaleForZoom(zoomFactor);
        this.panel1.setScale(s);
        this.panel2.setScale(s);
        this.panel1.repaint();
        this.panel2.repaint();
    }

    public float getScale() {
        return this.scale;
    }
}

