/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.gui.util.ChooseAction;
import org.biojava.nbio.structure.gui.util.StructurePairSelector;
import org.biojava.nbio.structure.io.MMCIFFileReader;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDBUploadPanel
extends JPanel
implements StructurePairSelector {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PDBUploadPanel.class);
    private JComboBox fileType;
    JTextField filePath1;
    JTextField filePath2;
    JTextField chain1;
    JTextField chain2;

    public static JComboBox getFileFormatSelect() {
        JComboBox<Object> fileType = new JComboBox();
        fileType = new JComboBox<String>(new String[]{"PDB", "mmCif"});
        fileType.setSelectedIndex(0);
        fileType.setMaximumSize(new Dimension(10, 50));
        return fileType;
    }

    public PDBUploadPanel() {
        this(true);
    }

    public PDBUploadPanel(boolean show2boxes) {
        Box vBox = Box.createVerticalBox();
        this.filePath1 = new JTextField(20);
        this.filePath2 = new JTextField(20);
        this.chain1 = new JTextField(1);
        this.chain2 = new JTextField(1);
        JPanel p1 = this.getLocalFilePanel(1, this.filePath1, this.chain1);
        JPanel p2 = this.getLocalFilePanel(2, this.filePath2, this.chain2);
        vBox.add(p1);
        if (show2boxes) {
            vBox.add(p2);
        }
        JLabel ftype = new JLabel("File format:");
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createGlue());
        hBox.add(ftype);
        this.fileType = PDBUploadPanel.getFileFormatSelect();
        hBox.add(this.fileType);
        hBox.add(Box.createGlue());
        vBox.add(hBox);
        this.add(vBox);
    }

    public String getFilePath1() {
        return this.filePath1.getText();
    }

    public String getChain1() {
        return this.chain1.getText();
    }

    @Override
    public Structure getStructure1() throws StructureException {
        return this.getStructure(this.filePath1, this.chain1);
    }

    @Override
    public Structure getStructure2() throws StructureException {
        return this.getStructure(this.filePath2, this.chain2);
    }

    private Structure getStructure(JTextField filePath, JTextField chainId) throws StructureException {
        PDBFileReader reader = null;
        String fileFormat = (String)this.fileType.getSelectedItem();
        if (fileFormat.equals("PDB")) {
            reader = new PDBFileReader();
        } else if (fileFormat.equals("mmCif")) {
            reader = new MMCIFFileReader();
        } else {
            throw new StructureException("Unkown file format " + fileFormat);
        }
        String path = filePath.getText();
        File f = new File(path);
        Structure s = null;
        try {
            s = reader.getStructure(f);
        }
        catch (IOException e) {
            logger.warn(e.getMessage());
            throw new StructureException((Throwable)e);
        }
        Structure reduced = StructureTools.getReducedStructure((Structure)s, (String)chainId.getText());
        String fileURL = "";
        try {
            URL u = chainId.getText() == null || chainId.getText().equals("") ? f.toURI().toURL() : new URL(f.toURI().toURL().toString() + "?chainId=" + chainId.getText());
            fileURL = u.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reduced.setPDBCode(fileURL);
        reduced.setName(fileURL);
        return reduced;
    }

    private JPanel getLocalFilePanel(int pos, JTextField filePath, JTextField chainId) {
        JPanel panel = new JPanel();
        JLabel l01 = new JLabel("File " + pos + ":");
        panel.add(l01);
        panel.add(filePath);
        ChooseAction action3 = new ChooseAction(filePath);
        JButton chooser = new JButton(action3);
        panel.add(chooser);
        JLabel chainLabel = new JLabel("Chain " + pos + ": (optional)");
        panel.add(chainLabel);
        panel.add(chainId);
        return panel;
    }
}

