/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;
import org.biojava.nbio.structure.gui.util.StructurePairSelector;

public class SelectPDBPanel
extends JPanel
implements StructurePairSelector {
    boolean debug = true;
    JTextField f1;
    JTextField f2;
    JTextField c1;
    JTextField c2;
    JTextField r1;
    JTextField r2;
    UserConfiguration config;
    JTabbedPane configPane;
    private static final long serialVersionUID = 4002475313717172193L;

    public SelectPDBPanel() {
        this(true);
    }

    public SelectPDBPanel(boolean show2PDBs) {
        Box vBox = Box.createVerticalBox();
        JLabel help = new JLabel("Optional: specify chain ID or range.");
        Box hBox1 = Box.createHorizontalBox();
        hBox1.add(Box.createGlue());
        hBox1.add(help);
        vBox.add(hBox1);
        int pdbfSize = 4;
        this.f1 = new JTextField(pdbfSize);
        this.c1 = new JTextField(1);
        this.r1 = new JTextField(5);
        Box p1 = this.getPDBFilePanel(1, this.f1, this.c1, this.r1);
        vBox.add(p1);
        this.f2 = new JTextField(pdbfSize);
        this.c2 = new JTextField(1);
        this.r2 = new JTextField(5);
        Box p2 = this.getPDBFilePanel(2, this.f2, this.c2, this.r2);
        if (show2PDBs) {
            vBox.add(p2);
        }
        this.add(vBox);
    }

    public StructureIdentifier getName1() {
        String id = this.f1.getText().trim();
        String chainId = this.c1.getText().trim();
        String range = this.r1.getText().trim();
        PdbId pdbId = new PdbId(id);
        if (!range.isEmpty()) {
            return new SubstructureIdentifier(pdbId, ResidueRange.parseMultiple((String)range));
        }
        if (!chainId.isEmpty()) {
            return new SubstructureIdentifier(pdbId, ResidueRange.parseMultiple((String)chainId));
        }
        return new SubstructureIdentifier(pdbId, new ArrayList());
    }

    public StructureIdentifier getName2() {
        String id = this.f2.getText().trim();
        String chainId = this.c2.getText().trim();
        String range = this.r2.getText().trim();
        PdbId pdbId = new PdbId(id);
        if (!range.isEmpty()) {
            return new SubstructureIdentifier(pdbId, ResidueRange.parseMultiple((String)range));
        }
        if (!chainId.isEmpty()) {
            return new SubstructureIdentifier(pdbId, ResidueRange.parseMultiple((String)chainId));
        }
        return new SubstructureIdentifier(pdbId, new ArrayList());
    }

    @Override
    public Structure getStructure1() throws StructureException, IOException {
        return this.getStructure(this.getName1());
    }

    @Override
    public Structure getStructure2() throws StructureException, IOException {
        return this.getStructure(this.getName2());
    }

    private Structure getStructure(StructureIdentifier name) throws IOException, StructureException {
        UserConfiguration config = WebStartMain.getWebStartConfig();
        AtomCache cache = new AtomCache(config);
        return cache.getStructure(name);
    }

    private Box getPDBFilePanel(int pos, JTextField f, JTextField c, JTextField r) {
        JLabel l01 = new JLabel("PDB code ");
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createGlue());
        hBox.add(l01);
        JLabel l11 = new JLabel(pos + ":");
        f.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        f.setToolTipText("Provide 4-character PDB code here. Example: 4hhb");
        hBox.add(l11);
        hBox.add(Box.createVerticalGlue());
        hBox.add((Component)f, "Center");
        hBox.add(Box.createGlue());
        JLabel l21 = new JLabel("Chain" + pos + ":");
        hBox.add(l21);
        c.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        hBox.add((Component)c, "Center");
        String msg1 = "Both chainID and range specification are optional. If both are provided, range has preference.";
        l21.setToolTipText(msg1);
        c.setToolTipText(msg1);
        JLabel rangeL = new JLabel(" Range " + pos + ":");
        hBox.add(Box.createGlue());
        hBox.add(rangeL);
        r.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        String msg = "Syntax example: A:407-495,A:582-686";
        rangeL.setToolTipText(msg);
        r.setToolTipText(msg);
        hBox.add((Component)r, "Center");
        return hBox;
    }
}

