/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.biojava.nbio.structure.align.webstart.BrowserOpener;

public class SystemInfo {
    Box vBox;
    String msg = "";
    public static final String defaultProperties = "browser file.separator java.class.version java.vendor java.vendor.url java.version line.separator os.arch os.name os.version path.separator ";
    public static final String hexPropertyNames = " file.separator line.separator path.separator ";
    public static final String urlPropertyNames = " browser.vendor.url  java.class.path java.home user.dir user.home user.name ";
    EtchedBorder border = new EtchedBorder();

    public SystemInfo() {
        try {
            Properties props = System.getProperties();
            int size = 0;
            Enumeration<?> enumo = props.propertyNames();
            while (enumo.hasMoreElements()) {
                ++size;
                enumo.nextElement();
            }
            String[] names = new String[size];
            enumo = props.propertyNames();
            int i = 0;
            while (enumo.hasMoreElements()) {
                names[i] = (String)enumo.nextElement();
                ++i;
            }
            if (size < 1) {
                this.msg = "No System Properties";
            } else {
                SystemInfo.quickSort(names, 0, names.length - 1);
                for (i = 0; i < size; ++i) {
                    this.addOneSystemProperty(names[i]);
                }
            }
        }
        catch (SecurityException e) {
            StringTokenizer t = new StringTokenizer(defaultProperties, " ");
            while (t.hasMoreElements()) {
                this.addOneSystemProperty(t.nextToken());
            }
        }
        catch (Exception e) {
            this.append("Strange Exception getting system properties: " + e);
        }
    }

    private void append(String txt) {
        this.msg = this.msg + txt;
    }

    public static void quickSort(String[] vector, int startIndex, int endIndex) {
        int i = startIndex;
        int j = endIndex;
        String pivot = vector[(i + j) / 2];
        while (true) {
            if (i < endIndex && pivot.compareTo(vector[i]) > 0) {
                ++i;
                continue;
            }
            while (j > startIndex && pivot.compareTo(vector[j]) < 0) {
                --j;
            }
            if (i < j) {
                String temp = vector[i];
                vector[i] = vector[j];
                vector[j] = temp;
            }
            if (i <= j) {
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (startIndex < j) {
            SystemInfo.quickSort(vector, startIndex, j);
        }
        if (i < endIndex) {
            SystemInfo.quickSort(vector, i, endIndex);
        }
    }

    public void addOneSystemProperty(String name) {
        try {
            String propValue = System.getProperty(name);
            if (propValue != null && !name.equals(propValue)) {
                char c;
                int i;
                this.append("<b>" + name + "</b>:");
                boolean isReadable = true;
                for (i = 0; i < propValue.length(); ++i) {
                    c = propValue.charAt(i);
                    if (!this.isControlCharacter(c)) continue;
                    isReadable = false;
                    break;
                }
                if (!isReadable) {
                    for (i = 0; i < propValue.length(); ++i) {
                        c = propValue.charAt(i);
                        if (Character.isLetterOrDigit(c)) {
                            this.append(" '" + c + "'");
                            continue;
                        }
                        this.append(" 0x");
                        if (c < '\u0010') {
                            this.append("0");
                        }
                        this.append(Integer.toHexString(c));
                    }
                } else if (this.isURLProperty(name)) {
                    StringBuffer fixed = new StringBuffer();
                    int start = 0;
                    int hit = 0;
                    while ((hit = propValue.indexOf(37, start)) >= 0) {
                        fixed.append(propValue.substring(start, hit));
                        int value = Integer.parseInt(propValue.substring(hit + 1, hit + 3), 16);
                        fixed.append((char)value);
                        start = hit + 3;
                    }
                    this.append(" \"" + fixed + "\"");
                } else {
                    this.append(" " + propValue);
                }
                this.append("<br/>");
            }
        }
        catch (SecurityException e) {
            this.append(name + ": Security Exception\n");
        }
        catch (Exception e) {
            this.append(name + ": " + e + "\n");
        }
    }

    protected boolean isHexProperty(String thisName) {
        int index = hexPropertyNames.indexOf(" " + thisName + " ");
        return index >= 0;
    }

    protected boolean isURLProperty(String thisName) {
        int index = urlPropertyNames.indexOf(" " + thisName + " ");
        return index >= 0;
    }

    private boolean isControlCharacter(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f';
    }

    public String getMessage() {
        return this.msg;
    }

    public void showDialog() {
        JDialog dialog = new JDialog();
        dialog.setSize(new Dimension(500, 650));
        String msg = this.getMessage();
        JEditorPane txt = new JEditorPane("text/html", msg);
        txt.setEditable(false);
        JScrollPane scroll = new JScrollPane(txt);
        scroll.setSize(new Dimension(300, 500));
        this.vBox = Box.createVerticalBox();
        this.vBox.add(scroll);
        txt.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String href = e.getDescription();
                    BrowserOpener.showDocument(href);
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    SystemInfo.this.vBox.setCursor(Cursor.getPredefinedCursor(12));
                }
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    SystemInfo.this.vBox.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                JButton but = (JButton)source;
                Container parent = but.getParent().getParent().getParent().getParent().getParent().getParent();
                JDialog dia = (JDialog)parent;
                dia.dispose();
            }
        });
        Box hBoxb = Box.createHorizontalBox();
        hBoxb.add(Box.createGlue());
        hBoxb.add((Component)close, "East");
        this.vBox.add(hBoxb);
        dialog.getContentPane().add(this.vBox);
        dialog.setVisible(true);
    }
}

