/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.gui.jmol.JmolPanel;
import org.biojava.nbio.structure.align.gui.jmol.RasmolCommandListener;
import org.biojava.nbio.structure.gui.util.MenuCreator;
import org.biojava.nbio.structure.io.PDBFileReader;

public class BiojavaJmol {
    public static final String viewer = "org.jmol.api.JmolSimpleViewer";
    public static final String adapter = "org.jmol.api.JmolAdapter";
    public static final String smartAdapter = "org.jmol.adapter.smarter.SmarterJmolAdapter";
    Structure structure;
    JmolPanel jmolPanel;
    JFrame frame = new JFrame();

    public static void main(String[] args) {
        try {
            PDBFileReader pdbr = new PDBFileReader();
            pdbr.setPath("/tmp/");
            String pdbCode = "5pti";
            Structure struc = pdbr.getStructureById(pdbCode);
            BiojavaJmol jmolPanel = new BiojavaJmol();
            jmolPanel.setStructure(struc);
            jmolPanel.evalString("select * ; color chain;");
            jmolPanel.evalString("select *; spacefill off; wireframe off; backbone 0.4;  ");
            jmolPanel.evalString("save STATE state_1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BiojavaJmol() {
        JMenuBar menu = MenuCreator.initMenu();
        this.frame.setJMenuBar(menu);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BiojavaJmol.this.frame.dispose();
            }
        });
        Container contentPane = this.frame.getContentPane();
        Box vBox = Box.createVerticalBox();
        this.jmolPanel = new JmolPanel();
        this.jmolPanel.setPreferredSize(new Dimension(500, 500));
        vBox.add(this.jmolPanel);
        JTextField field = new JTextField();
        field.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        field.setText("enter RASMOL like command...");
        RasmolCommandListener listener = new RasmolCommandListener(this.jmolPanel, field);
        field.addActionListener(listener);
        field.addMouseListener(listener);
        field.addKeyListener(listener);
        vBox.add(field);
        Box hBox1 = Box.createHorizontalBox();
        hBox1.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        String[] styles = new String[]{"Cartoon", "Backbone", "CPK", "Ball and Stick", "Ligands", "Ligands and Pocket"};
        JComboBox<String> style = new JComboBox<String>(styles);
        hBox1.add(new JLabel("Style"));
        hBox1.add(style);
        vBox.add(hBox1);
        style.addActionListener(this.jmolPanel);
        String[] colorModes = new String[]{"Secondary Structure", "By Chain", "Rainbow", "By Element", "By Amino Acid", "Hydrophobicity"};
        JComboBox<String> colors = new JComboBox<String>(colorModes);
        colors.addActionListener(this.jmolPanel);
        hBox1.add(Box.createGlue());
        hBox1.add(new JLabel("Color"));
        hBox1.add(colors);
        Box hBox2 = Box.createHorizontalBox();
        hBox2.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        JButton resetDisplay = new JButton("Reset Display");
        resetDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("reset!!");
                BiojavaJmol.this.jmolPanel.executeCmd("restore STATE state_1");
            }
        });
        hBox2.add(resetDisplay);
        hBox2.add(Box.createGlue());
        JCheckBox toggleSelection = new JCheckBox("Show Selection");
        toggleSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean showSelection;
                boolean bl = showSelection = e.getStateChange() == 1;
                if (showSelection) {
                    BiojavaJmol.this.jmolPanel.executeCmd("set display selected");
                } else {
                    BiojavaJmol.this.jmolPanel.executeCmd("set display off");
                }
            }
        });
        hBox2.add(toggleSelection);
        hBox2.add(Box.createGlue());
        vBox.add(hBox2);
        contentPane.add(vBox);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public static boolean jmolInClassPath() {
        try {
            Class.forName(viewer);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void evalString(String rasmolScript) {
        if (this.jmolPanel == null) {
            System.err.println("please install Jmol first");
            return;
        }
        this.jmolPanel.evalString(rasmolScript);
    }

    public void setStructure(Structure s) {
        if (this.jmolPanel == null) {
            System.err.println("please install Jmol first");
            return;
        }
        this.setTitle(s.getPDBCode());
        String pdb = s.toPDB();
        this.jmolPanel.openStringInline(pdb);
    }

    public void setTitle(String label) {
        this.frame.setTitle(label);
        this.frame.repaint();
    }

    public JFrame getFrame() {
        return this.frame;
    }
}

