/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentScorer;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentTools;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.biojava.nbio.structure.symmetry.internal.RefinerFailedException;
import org.biojava.nbio.structure.symmetry.internal.SymmetryAxes;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(SymmOptimizer.class);
    private Random rnd;
    private int Rmin = 2;
    private int Lmin;
    private int maxIter;
    private double C = 20.0;
    private static final double Gopen = 20.0;
    private static final double Gextend = 10.0;
    private double dCutoff;
    private MultipleAlignment msa;
    private SymmetryAxes axes;
    private Atom[] atoms;
    private int order;
    private int length;
    private int repeatCore;
    private List<List<Integer>> block;
    private List<Integer> freePool;
    private double mcScore;
    private static final boolean history = false;
    private static final int saveStep = 100;
    private static final String pathToHistory = "./results/";
    private List<Integer> lengthHistory;
    private List<Double> rmsdHistory;
    private List<Double> scoreHistory;

    public SymmOptimizer(CeSymmResult symmResult) {
        this.axes = symmResult.getAxes();
        this.rnd = new Random(symmResult.getParams().getRndSeed());
        this.Lmin = symmResult.getParams().getMinCoreLength();
        this.dCutoff = symmResult.getParams().getDistanceCutoff();
        MultipleAlignmentEnsemble e = symmResult.getMultipleAlignment().getEnsemble().clone();
        this.msa = e.getMultipleAlignment(0);
        this.atoms = this.msa.getAtomArrays().get(0);
        this.order = this.msa.size();
        this.repeatCore = this.msa.getCoreLength();
        this.Rmin = symmResult.getParams().isGaps() ? Math.max(this.order / 2, 2) : this.order;
        this.maxIter = symmResult.getParams().getOptimizationSteps();
        if (this.maxIter < 1) {
            this.maxIter = 100 * this.atoms.length;
        }
    }

    private void initialize() throws StructureException, RefinerFailedException {
        if (this.order == 1) {
            throw new RefinerFailedException("Non-symmetric seed slignment: order = 1");
        }
        if (this.repeatCore < 1) {
            throw new RefinerFailedException("Seed alignment too short: repeat core length == 0");
        }
        this.C = 20 * this.order;
        this.block = this.msa.getBlock(0).getAlignRes();
        this.freePool = new ArrayList<Integer>();
        this.length = this.block.get(0).size();
        ArrayList aligned = new ArrayList();
        for (int su = 0; su < this.order; ++su) {
            aligned.addAll(this.block.get(su));
        }
        for (int i = 0; i < this.atoms.length; ++i) {
            if (aligned.contains(i)) continue;
            this.freePool.add(i);
        }
        this.checkGaps();
        this.updateMultipleAlignment();
        this.mcScore = MultipleAlignmentScorer.getMCScore(this.msa, 20.0, 10.0, this.dCutoff);
    }

    public MultipleAlignment optimize() throws StructureException, RefinerFailedException {
        this.initialize();
        this.lengthHistory = new ArrayList<Integer>();
        this.rmsdHistory = new ArrayList<Double>();
        this.scoreHistory = new ArrayList<Double>();
        int conv = 0;
        int stepsToConverge = Math.max(this.maxIter / 50, 1000);
        for (int i = 1; i < this.maxIter && conv < stepsToConverge; ++i) {
            ArrayList<List<Integer>> lastBlock = new ArrayList<List<Integer>>();
            ArrayList<Integer> lastFreePool = new ArrayList<Integer>();
            lastFreePool.addAll(this.freePool);
            for (int k = 0; k < this.order; ++k) {
                ArrayList b = new ArrayList();
                b.addAll(this.block.get(k));
                lastBlock.add(b);
            }
            double lastScore = this.mcScore;
            int lastRepeatCore = this.repeatCore;
            boolean moved = false;
            while (!moved) {
                double move = this.rnd.nextDouble();
                if (move < 0.4) {
                    moved = this.shiftRow();
                    logger.debug("did shift");
                    continue;
                }
                if (move < 0.7) {
                    moved = this.expandBlock();
                    logger.debug("did expand");
                    continue;
                }
                if (move < 0.85) {
                    moved = this.shrinkBlock();
                    logger.debug("did shrink");
                    continue;
                }
                moved = this.insertGap();
                logger.debug("did insert gap");
            }
            this.updateMultipleAlignment();
            this.mcScore = MultipleAlignmentScorer.getMCScore(this.msa, 20.0, 10.0, this.dCutoff);
            double AS = this.mcScore - lastScore;
            double prob = 1.0;
            if (AS < 0.0) {
                prob = this.probabilityFunction(AS, i, this.maxIter);
                double p = this.rnd.nextDouble();
                if (p > prob) {
                    this.block = lastBlock;
                    this.freePool = lastFreePool;
                    this.length = this.block.get(0).size();
                    this.repeatCore = lastRepeatCore;
                    this.mcScore = lastScore;
                    ++conv;
                } else {
                    conv = 0;
                }
            } else {
                conv = 0;
            }
            logger.debug(i + ": --prob: " + prob + ", --score: " + AS + ", --conv: " + conv);
        }
        this.updateMultipleAlignment();
        this.mcScore = MultipleAlignmentScorer.getMCScore(this.msa, 20.0, 10.0, this.dCutoff);
        this.msa.putScore("MC-score", this.mcScore);
        return this.msa;
    }

    private void updateMultipleAlignment() throws StructureException, RefinerFailedException {
        this.msa.clear();
        Block b = this.msa.getBlock(0);
        b.setAlignRes(this.block);
        this.repeatCore = b.getCoreLength();
        if (this.repeatCore < 1) {
            throw new RefinerFailedException("Optimization converged to length 0");
        }
        SymmetryTools.updateSymmetryTransformation(this.axes, this.msa, this.atoms);
    }

    private boolean checkGaps() {
        ArrayList<Integer> shrinkColumns = new ArrayList<Integer>();
        for (int res = 0; res < this.length; ++res) {
            int gapCount = 0;
            for (int su = 0; su < this.order; ++su) {
                if (this.block.get(su).get(res) != null) continue;
                ++gapCount;
            }
            if (this.order - gapCount >= this.Rmin) continue;
            shrinkColumns.add(res);
        }
        for (int col = shrinkColumns.size() - 1; col >= 0; --col) {
            for (int su = 0; su < this.order; ++su) {
                Integer residue = this.block.get(su).get((Integer)shrinkColumns.get(col));
                this.block.get(su).remove((Integer)shrinkColumns.get(col));
                if (residue != null) {
                    this.freePool.add(residue);
                }
                Collections.sort(this.freePool);
            }
            --this.length;
        }
        return shrinkColumns.size() != 0;
    }

    private boolean insertGap() throws StructureException, RefinerFailedException {
        if (this.repeatCore <= this.Lmin) {
            return false;
        }
        this.updateMultipleAlignment();
        Matrix residueDistances = MultipleAlignmentTools.getAverageResidueDistances(this.msa);
        double maxDist = Double.MIN_VALUE;
        int su = 0;
        int res = 0;
        for (int col = 0; col < this.length; ++col) {
            for (int s = 0; s < this.order; ++s) {
                if (residueDistances.get(s, col) == -1.0 || !(residueDistances.get(s, col) > maxDist) || !(this.rnd.nextDouble() > 0.5)) continue;
                su = s;
                res = col;
                maxDist = residueDistances.get(s, col);
            }
        }
        Integer residueL = this.block.get(su).get(res);
        if (residueL == null) {
            return false;
        }
        this.freePool.add(residueL);
        Collections.sort(this.freePool);
        this.block.get(su).set(res, null);
        this.checkGaps();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shiftRow() {
        int su = this.rnd.nextInt(this.order);
        int rl = this.rnd.nextInt(2);
        int res = this.rnd.nextInt(this.length);
        if (this.block.get(su).get(res) == null) {
            int right;
            int left = res;
            for (right = res; this.block.get(su).get(right) == null && right < this.length - 1; ++right) {
            }
            while (this.block.get(su).get(left) == null && left > 0) {
                --left;
            }
            if (this.block.get(su).get(left) == null && this.block.get(su).get(right) == null) {
                return false;
            }
            if (this.block.get(su).get(left) == null) {
                Integer residue = this.block.get(su).get(right) - 1;
                if (!this.freePool.contains(residue)) return false;
                this.block.get(su).set(res, residue);
                this.freePool.remove(residue);
                return true;
            } else if (this.block.get(su).get(right) == null) {
                Integer residue = this.block.get(su).get(left) + 1;
                if (!this.freePool.contains(residue)) return false;
                this.block.get(su).set(res, residue);
                this.freePool.remove(residue);
                return true;
            } else if (this.block.get(su).get(right) == this.block.get(su).get(left) + 1) {
                switch (rl) {
                    case 0: {
                        this.block.get(su).set(right - 1, this.block.get(su).get(right));
                        this.block.get(su).set(right, null);
                        return true;
                    }
                    case 1: {
                        this.block.get(su).set(left + 1, this.block.get(su).get(left));
                        this.block.get(su).set(left, null);
                    }
                }
                return true;
            } else {
                Integer residue = this.rnd.nextInt(this.block.get(su).get(right) - this.block.get(su).get(left) - 1) + this.block.get(su).get(left) + 1;
                if (!this.freePool.contains(residue)) return true;
                this.block.get(su).set(res, residue);
                this.freePool.remove(residue);
            }
            return true;
        }
        switch (rl) {
            case 0: {
                int leftBoundary = res - 1;
                int leftPrevRes = res;
                while (leftBoundary >= 0 && this.block.get(su).get(leftBoundary) != null && this.block.get(su).get(leftPrevRes) <= this.block.get(su).get(leftBoundary) + 1) {
                    leftPrevRes = leftBoundary--;
                }
                ++leftBoundary;
                int rightBoundary = res + 1;
                int rightPrevRes = res;
                while (rightBoundary != this.length && this.block.get(su).get(rightBoundary) != null && this.block.get(su).get(rightPrevRes) + 1 >= this.block.get(su).get(rightBoundary)) {
                    rightPrevRes = rightBoundary++;
                }
                Integer residueR0 = this.block.get(su).get(--rightBoundary);
                Integer residueL0 = this.block.get(su).get(leftBoundary);
                this.block.get(su).remove(rightBoundary);
                if (residueR0 != null) {
                    this.freePool.add(residueR0);
                    Collections.sort(this.freePool);
                }
                if (this.freePool.contains(residueL0 = Integer.valueOf(residueL0 - 1))) {
                    this.block.get(su).add(leftBoundary, residueL0);
                    this.freePool.remove(residueL0);
                    break;
                }
                this.block.get(su).add(leftBoundary, null);
                break;
            }
            case 1: {
                int leftBoundary1 = res - 1;
                int leftPrevRes1 = res;
                while (leftBoundary1 >= 0 && this.block.get(su).get(leftBoundary1) != null && this.block.get(su).get(leftPrevRes1) <= this.block.get(su).get(leftBoundary1) + 1) {
                    leftPrevRes1 = leftBoundary1--;
                }
                ++leftBoundary1;
                int rightBoundary1 = res + 1;
                int rightPrevRes1 = res;
                while (rightBoundary1 != this.length && this.block.get(su).get(rightBoundary1) != null && this.block.get(su).get(rightPrevRes1) + 1 >= this.block.get(su).get(rightBoundary1)) {
                    rightPrevRes1 = rightBoundary1++;
                }
                Integer residueR1 = this.block.get(su).get(--rightBoundary1);
                Integer residueL1 = this.block.get(su).get(leftBoundary1);
                if (this.freePool.contains(residueR1 = Integer.valueOf(residueR1 + 1))) {
                    if (rightBoundary1 == this.length - 1) {
                        this.block.get(su).add(residueR1);
                    } else {
                        this.block.get(su).add(rightBoundary1 + 1, residueR1);
                    }
                    this.freePool.remove(residueR1);
                } else {
                    this.block.get(su).add(rightBoundary1 + 1, null);
                }
                this.block.get(su).remove(leftBoundary1);
                this.freePool.add(residueL1);
                Collections.sort(this.freePool);
            }
        }
        this.checkGaps();
        return true;
    }

    private boolean expandBlock() {
        boolean moved = false;
        int rl = this.rnd.nextInt(2);
        int res = this.rnd.nextInt(this.length);
        switch (rl) {
            case 0: {
                int su;
                int rightBoundary = res;
                int[] previousPos = new int[this.order];
                for (su = 0; su < this.order; ++su) {
                    previousPos[su] = -1;
                }
                while (this.length - 1 > rightBoundary) {
                    int noncontinuous = 0;
                    for (int su2 = 0; su2 < this.order; ++su2) {
                        if (this.block.get(su2).get(rightBoundary) == null) continue;
                        if (previousPos[su2] == -1) {
                            previousPos[su2] = this.block.get(su2).get(rightBoundary);
                            continue;
                        }
                        if (this.block.get(su2).get(rightBoundary) <= previousPos[su2] + 1) continue;
                        ++noncontinuous;
                    }
                    if (noncontinuous >= this.Rmin) break;
                    ++rightBoundary;
                }
                if (rightBoundary > 0) {
                    --rightBoundary;
                }
                for (su = 0; su < this.order; ++su) {
                    Integer residueR = this.block.get(su).get(rightBoundary);
                    if (residueR == null) {
                        if (rightBoundary == this.length - 1) {
                            this.block.get(su).add(null);
                            continue;
                        }
                        this.block.get(su).add(rightBoundary + 1, null);
                        continue;
                    }
                    if (this.freePool.contains(residueR + 1)) {
                        Integer residueAdd = residueR + 1;
                        if (rightBoundary == this.length - 1) {
                            this.block.get(su).add(residueAdd);
                        } else {
                            this.block.get(su).add(rightBoundary + 1, residueAdd);
                        }
                        this.freePool.remove(residueAdd);
                        continue;
                    }
                    if (rightBoundary == this.length - 1) {
                        this.block.get(su).add(null);
                        continue;
                    }
                    this.block.get(su).add(rightBoundary + 1, null);
                }
                ++this.length;
                moved = true;
                break;
            }
            case 1: {
                int su;
                int leftBoundary = res;
                int[] nextPos = new int[this.order];
                for (su = 0; su < this.order; ++su) {
                    nextPos[su] = -1;
                }
                while (leftBoundary > 0) {
                    int noncontinuous = 0;
                    for (int su3 = 0; su3 < this.order; ++su3) {
                        if (this.block.get(su3).get(leftBoundary) == null) continue;
                        if (nextPos[su3] == -1) {
                            nextPos[su3] = this.block.get(su3).get(leftBoundary);
                            continue;
                        }
                        if (this.block.get(su3).get(leftBoundary) >= nextPos[su3] - 1) continue;
                        ++noncontinuous;
                    }
                    if (noncontinuous >= this.Rmin) break;
                    --leftBoundary;
                }
                for (su = 0; su < this.order; ++su) {
                    Integer residueL = this.block.get(su).get(leftBoundary);
                    if (residueL == null) {
                        this.block.get(su).add(leftBoundary, null);
                        continue;
                    }
                    if (this.freePool.contains(residueL - 1)) {
                        Integer residueAdd = residueL - 1;
                        this.block.get(su).add(leftBoundary, residueAdd);
                        this.freePool.remove(residueAdd);
                        continue;
                    }
                    this.block.get(su).add(leftBoundary, null);
                }
                ++this.length;
                moved = true;
            }
        }
        if (moved) {
            return !this.checkGaps();
        }
        return moved;
    }

    private boolean shrinkBlock() throws StructureException, RefinerFailedException {
        if (this.repeatCore <= this.Lmin) {
            return false;
        }
        this.updateMultipleAlignment();
        Matrix residueDistances = MultipleAlignmentTools.getAverageResidueDistances(this.msa);
        double maxDist = Double.MIN_VALUE;
        double[] colDistances = new double[this.length];
        int res = 0;
        for (int col = 0; col < this.length; ++col) {
            int normalize = 0;
            for (int s = 0; s < this.order; ++s) {
                if (residueDistances.get(s, col) == -1.0) continue;
                int n = col;
                colDistances[n] = colDistances[n] + residueDistances.get(s, col);
                ++normalize;
            }
            int n = col;
            colDistances[n] = colDistances[n] / (double)normalize;
            if (!(colDistances[col] > maxDist) || !(this.rnd.nextDouble() > 0.5)) continue;
            maxDist = colDistances[col];
            res = col;
        }
        for (int su = 0; su < this.order; ++su) {
            Integer residue = this.block.get(su).get(res);
            this.block.get(su).remove(res);
            if (residue != null) {
                this.freePool.add(residue);
            }
            Collections.sort(this.freePool);
        }
        --this.length;
        this.checkGaps();
        return true;
    }

    private double probabilityFunction(double AS, int m, int maxIter) {
        double prob = (this.C + AS) / (this.C * Math.sqrt(m));
        double norm = 1.0 - (double)m * 1.0 / (double)maxIter;
        return Math.min(Math.max(prob * norm, 0.0), 1.0);
    }

    private void saveHistory(String folder) throws IOException {
        String name = this.msa.getStructureIdentifier(0).getIdentifier();
        FileWriter writer = new FileWriter(folder + name + "-symm_optimization.csv");
        writer.append("Structure,Step,Repeat Length,RMSD,TM-Score\n");
        for (int i = 0; i < this.lengthHistory.size(); ++i) {
            writer.append(name + ",");
            writer.append(i * 100 + ",");
            writer.append(this.lengthHistory.get(i) + ",");
            writer.append(this.rmsdHistory.get(i) + ",");
            writer.append(this.scoreHistory.get(i) + "\n");
        }
        writer.flush();
        writer.close();
    }
}

