/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Compound;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.JournalArticle;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Site;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;

public interface Structure
extends Cloneable {
    public Structure clone();

    public String toString();

    public void setPDBCode(String var1);

    public String getPDBCode();

    public void setName(String var1);

    public String getName();

    public StructureIdentifier getStructureIdentifier();

    public void setStructureIdentifier(StructureIdentifier var1);

    @Deprecated
    public void setConnections(List<Map<String, Integer>> var1);

    @Deprecated
    public List<Map<String, Integer>> getConnections();

    public int size();

    public int size(int var1);

    public int nrModels();

    public boolean isNmr();

    public boolean isCrystallographic();

    @Deprecated
    public void setNmr(boolean var1);

    public void addModel(List<Chain> var1);

    public void setModel(int var1, List<Chain> var2);

    public List<Chain> getModel(int var1);

    public List<Chain> getChains();

    public void setChains(List<Chain> var1);

    public List<Chain> getChains(int var1);

    public void setChains(int var1, List<Chain> var2);

    public void addChain(Chain var1);

    public void addChain(Chain var1, int var2);

    public Chain getChain(int var1);

    public Chain getChain(int var1, int var2);

    public Chain findChain(String var1) throws StructureException;

    public boolean hasChain(String var1);

    public Chain findChain(String var1, int var2) throws StructureException;

    public Group findGroup(String var1, String var2) throws StructureException;

    public Group findGroup(String var1, String var2, int var3) throws StructureException;

    public Chain getChainByPDB(String var1) throws StructureException;

    public Chain getChainByPDB(String var1, int var2) throws StructureException;

    public String toPDB();

    public String toMMCIF();

    public void setCompounds(List<Compound> var1);

    public List<Compound> getCompounds();

    public void addCompound(Compound var1);

    public void setDBRefs(List<DBRef> var1);

    public List<DBRef> getDBRefs();

    public Compound getCompoundById(int var1);

    public PDBHeader getPDBHeader();

    public boolean hasJournalArticle();

    public JournalArticle getJournalArticle();

    public void setJournalArticle(JournalArticle var1);

    public List<Bond> getSSBonds();

    public void setSSBonds(List<Bond> var1);

    public void addSSBond(Bond var1);

    public void setPDBHeader(PDBHeader var1);

    public Long getId();

    public void setId(Long var1);

    public void setSites(List<Site> var1);

    public List<Site> getSites();

    public List<Group> getHetGroups();

    public void setBiologicalAssembly(boolean var1);

    public boolean isBiologicalAssembly();

    public void setCrystallographicInfo(PDBCrystallographicInfo var1);

    public PDBCrystallographicInfo getCrystallographicInfo();

    public void resetModels();

    @Deprecated
    public String getPdbId();

    @Deprecated
    public List<? extends ResidueRange> getResidueRanges();

    @Deprecated
    public List<String> getRanges();

    public String getIdentifier();
}

