/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.PairwiseSequenceAligner;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Compound;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.io.SeqRes2AtomAligner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundFinder {
    private Structure s;
    private static final Logger logger = LoggerFactory.getLogger(CompoundFinder.class);
    public static final double RATIO_GAPS_FOR_MISMATCH = 0.5;
    public static final double IDENTITY_THRESHOLD = 0.99999;
    public static final double GAP_COVERAGE_THRESHOLD = 0.3;

    public CompoundFinder(Structure s) {
        this.s = s;
    }

    public List<Compound> findCompounds() {
        TreeMap<String, Compound> chainIds2entities = this.findCompoundsFromAlignment();
        List<Compound> compounds = CompoundFinder.findUniqueCompounds(chainIds2entities);
        this.createPurelyNonPolyCompounds(compounds);
        return compounds;
    }

    private static List<Compound> findUniqueCompounds(TreeMap<String, Compound> chainIds2entities) {
        ArrayList<Compound> list = new ArrayList<Compound>();
        for (Compound cluster : chainIds2entities.values()) {
            boolean present = false;
            for (Compound cl : list) {
                if (cl != cluster) continue;
                present = true;
                break;
            }
            if (present) continue;
            list.add(cluster);
        }
        return list;
    }

    private void createPurelyNonPolyCompounds(List<Compound> compounds) {
        ArrayList<Chain> pureNonPolymerChains = new ArrayList<Chain>();
        for (int i = 0; i < this.s.getChains().size(); ++i) {
            if (!StructureTools.isChainPureNonPolymer(this.s.getChain(i))) continue;
            pureNonPolymerChains.add(this.s.getChain(i));
        }
        if (!pureNonPolymerChains.isEmpty()) {
            int maxMolId = 0;
            if (!compounds.isEmpty()) {
                Collections.max(compounds, new Comparator<Compound>(){

                    @Override
                    public int compare(Compound o1, Compound o2) {
                        return new Integer(o1.getMolId()).compareTo(o2.getMolId());
                    }
                }).getMolId();
            }
            int molId = maxMolId + 1;
            for (Chain c : pureNonPolymerChains) {
                Compound comp = new Compound();
                comp.addChain(c);
                comp.setMolId(molId);
                logger.warn("Chain {} is purely non-polymeric, will assign a new Compound (entity) to it (entity id {})", (Object)c.getChainID(), (Object)molId);
                ++molId;
                compounds.add(comp);
            }
        }
    }

    private static boolean areResNumbersAligned(Chain c1, Chain c2) {
        boolean isC2prot;
        boolean isC1prot = StructureTools.isProtein(c1);
        if (isC1prot != (isC2prot = StructureTools.isProtein(c2))) {
            return false;
        }
        List<Group> c1AtomGroups = null;
        c1AtomGroups = isC1prot ? c1.getAtomGroups(GroupType.AMINOACID) : c1.getAtomGroups(GroupType.NUCLEOTIDE);
        int countNonExisting = 0;
        for (Group g1 : c1AtomGroups) {
            try {
                Group g2 = c2.getGroupByPDB(g1.getResidueNumber());
                if (g2.getPDBName().equals(g1.getPDBName())) continue;
                logger.debug("Mismatch of residues between chains {},{} for residue number {}: {} {}", new Object[]{c1.getChainID(), c2.getChainID(), g1.getResidueNumber(), g1.getPDBName(), g2.getPDBName()});
                return false;
            }
            catch (StructureException e) {
                ++countNonExisting;
            }
        }
        if ((double)countNonExisting / (double)c1AtomGroups.size() > 0.5) {
            logger.debug("More than {} of the residues ({} out of {}) are not present in chain {} when comparing by residue numbers to chain {}.", new Object[]{0.5, countNonExisting, c1AtomGroups.size(), c2.getChainID(), c1.getChainID()});
            return false;
        }
        return true;
    }

    private TreeMap<String, Compound> findCompoundsFromAlignment() {
        int i;
        TreeSet<Integer> polyChainIndices = new TreeSet<Integer>();
        ArrayList<Chain> pureNonPolymerChains = new ArrayList<Chain>();
        for (int i2 = 0; i2 < this.s.getChains().size(); ++i2) {
            if (StructureTools.isChainPureNonPolymer(this.s.getChain(i2))) {
                pureNonPolymerChains.add(this.s.getChain(i2));
                continue;
            }
            polyChainIndices.add(i2);
        }
        TreeMap<String, Compound> chainIds2compounds = new TreeMap<String, Compound>();
        int molId = 1;
        Iterator i$ = polyChainIndices.iterator();
        block1: while (i$.hasNext()) {
            i = (Integer)i$.next();
            Iterator i$2 = polyChainIndices.iterator();
            while (i$2.hasNext()) {
                ProteinSequence s2;
                ProteinSequence s1;
                int j = (Integer)i$2.next();
                if (j <= i) continue;
                Chain c1 = this.s.getChain(i);
                Chain c2 = this.s.getChain(j);
                HashMap<Integer, Integer> positionIndex1 = new HashMap<Integer, Integer>();
                HashMap<Integer, Integer> positionIndex2 = new HashMap<Integer, Integer>();
                String str1 = SeqRes2AtomAligner.getFullAtomSequence(c1.getAtomGroups(), positionIndex1, false);
                String str2 = SeqRes2AtomAligner.getFullAtomSequence(c2.getAtomGroups(), positionIndex2, false);
                int seq1Length = 0;
                int seq2Length = 0;
                SequencePair<ProteinSequence, AminoAcidCompound> pair = null;
                if (this.isProteinSequence(str1) && this.isProteinSequence(str2)) {
                    s1 = this.getProteinSequence(str1);
                    s2 = this.getProteinSequence(str2);
                    seq1Length = s1.getLength();
                    seq2Length = s2.getLength();
                    pair = this.alignProtein(s1, s2);
                } else if (this.isDNASequence(str1) && this.isDNASequence(str2)) {
                    s1 = this.getDNASequence(str1);
                    s2 = this.getDNASequence(str2);
                    seq1Length = s1.getLength();
                    seq2Length = s2.getLength();
                    pair = this.alignDNA((DNASequence)s1, (DNASequence)s2);
                } else if (this.isRNASequence(str1) && this.isRNASequence(str2)) {
                    s1 = this.getRNASequence(str1);
                    s2 = this.getRNASequence(str2);
                    seq1Length = s1.getLength();
                    seq2Length = s2.getLength();
                    pair = this.alignRNA((RNASequence)s1, (RNASequence)s2);
                } else {
                    logger.debug("Chains {},{} are either different kind of polymers or could not be recognized as protein or nucleotide polymers");
                    continue;
                }
                int numGaps = CompoundFinder.getNumGaps(pair);
                int numGaps1 = CompoundFinder.getNumGapsQuery(pair);
                int numGaps2 = CompoundFinder.getNumGapsTarget(pair);
                int nonGaps = pair.getLength() - numGaps;
                double identity = (double)pair.getNumIdenticals() / (double)nonGaps;
                double gapCov1 = (double)numGaps1 / (double)seq1Length;
                double gapCov2 = (double)numGaps2 / (double)seq2Length;
                logger.debug("Alignment for chain pair {},{}: identity: {}, gap coverage 1: {}, gap coverage 2: {}", new Object[]{c1.getChainID(), c2.getChainID(), String.format("%4.2f", identity), String.format("%4.2f", gapCov1), String.format("%4.2f", gapCov2)});
                logger.debug("\n" + pair.toString(100));
                if (identity > 0.99999 && gapCov1 < 0.3 && gapCov2 < 0.3) {
                    Compound ent;
                    if (!chainIds2compounds.containsKey(c1.getChainID()) && !chainIds2compounds.containsKey(c2.getChainID())) {
                        logger.debug("Creating Compound with chains {},{}", (Object)c1.getChainID(), (Object)c2.getChainID());
                        ent = new Compound();
                        ent.addChain(c1);
                        ent.addChain(c2);
                        ent.setMolId(molId++);
                        chainIds2compounds.put(c1.getChainID(), ent);
                        chainIds2compounds.put(c2.getChainID(), ent);
                    } else {
                        ent = chainIds2compounds.get(c1.getChainID());
                        if (ent == null) {
                            logger.debug("Adding chain {} to entity {}", (Object)c1.getChainID(), (Object)c2.getChainID());
                            ent = chainIds2compounds.get(c2.getChainID());
                            ent.addChain(c1);
                            chainIds2compounds.put(c1.getChainID(), ent);
                        } else {
                            logger.debug("Adding chain {} to entity {}", (Object)c2.getChainID(), (Object)c1.getChainID());
                            ent.addChain(c2);
                            chainIds2compounds.put(c2.getChainID(), ent);
                        }
                    }
                    if (!CompoundFinder.areResNumbersAligned(c1, c2)) {
                        logger.warn("Including 100% identical chains {},{} in same Compound, although they have misaligned residue numbers", (Object)c1.getChainID(), (Object)c2.getChainID());
                    }
                }
                if (identity > 1.0) {
                    logger.warn("Identity for chains {},{} above 1. {} identicals out of {} non-gap-aligned residues (identity {})", new Object[]{c1.getChainID(), c2.getChainID(), pair.getNumIdenticals(), nonGaps, identity});
                    logger.warn("\n" + pair.toString(100));
                }
                if (chainIds2compounds.size() != polyChainIndices.size()) continue;
                break block1;
            }
        }
        i$ = polyChainIndices.iterator();
        while (i$.hasNext()) {
            i = (Integer)i$.next();
            Chain c = this.s.getChain(i);
            if (chainIds2compounds.containsKey(c.getChainID())) continue;
            logger.debug("Creating a 1-member Compound for chain {}", (Object)c.getChainID());
            Compound ent = new Compound();
            ent.addChain(c);
            ent.setMolId(molId++);
            chainIds2compounds.put(c.getChainID(), ent);
        }
        return chainIds2compounds;
    }

    private SequencePair<ProteinSequence, AminoAcidCompound> alignProtein(ProteinSequence s1, ProteinSequence s2) {
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getIdentity();
        SimpleGapPenalty penalty = new SimpleGapPenalty(8, 1);
        PairwiseSequenceAligner nw = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.GLOBAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
        return nw.getPair();
    }

    private SequencePair<DNASequence, NucleotideCompound> alignDNA(DNASequence s1, DNASequence s2) {
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getNuc4_4();
        SimpleGapPenalty penalty = new SimpleGapPenalty(8, 1);
        PairwiseSequenceAligner nw = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.GLOBAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
        return nw.getPair();
    }

    private SequencePair<RNASequence, NucleotideCompound> alignRNA(RNASequence s1, RNASequence s2) {
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getNuc4_4();
        SimpleGapPenalty penalty = new SimpleGapPenalty(8, 1);
        PairwiseSequenceAligner nw = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.GLOBAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
        return nw.getPair();
    }

    private static int getNumGaps(SequencePair<?, ?> pair) {
        int numGaps = 0;
        for (int alignmentIndex = 1; alignmentIndex <= pair.getLength(); ++alignmentIndex) {
            if (!pair.hasGap(alignmentIndex)) continue;
            ++numGaps;
        }
        return numGaps;
    }

    private static int getNumGapsQuery(SequencePair<?, ?> pair) {
        int numGaps = 0;
        for (int alignmentIndex = 1; alignmentIndex <= pair.getLength(); ++alignmentIndex) {
            if (!pair.getCompoundInQueryAt(alignmentIndex).getShortName().equals("-")) continue;
            ++numGaps;
        }
        return numGaps;
    }

    private static int getNumGapsTarget(SequencePair<?, ?> pair) {
        int numGaps = 0;
        for (int alignmentIndex = 1; alignmentIndex <= pair.getLength(); ++alignmentIndex) {
            if (!pair.getCompoundInTargetAt(alignmentIndex).getShortName().equals("-")) continue;
            ++numGaps;
        }
        return numGaps;
    }

    private boolean isProteinSequence(String str) {
        try {
            new ProteinSequence(str);
        }
        catch (CompoundNotFoundException e) {
            return false;
        }
        return true;
    }

    private boolean isDNASequence(String str) {
        try {
            new DNASequence(str);
        }
        catch (CompoundNotFoundException e) {
            return false;
        }
        return true;
    }

    private boolean isRNASequence(String str) {
        try {
            new RNASequence(str);
        }
        catch (CompoundNotFoundException e) {
            return false;
        }
        return true;
    }

    private ProteinSequence getProteinSequence(String str) {
        try {
            ProteinSequence s = new ProteinSequence(str);
            return s;
        }
        catch (CompoundNotFoundException e) {
            logger.error("Unexpected error when creating ProteinSequence", (Throwable)e);
            return null;
        }
    }

    private DNASequence getDNASequence(String str) {
        try {
            DNASequence s = new DNASequence(str);
            return s;
        }
        catch (CompoundNotFoundException e) {
            logger.error("Unexpected error when creating DNASequence ", (Throwable)e);
            return null;
        }
    }

    private RNASequence getRNASequence(String str) {
        try {
            RNASequence s = new RNASequence(str);
            return s;
        }
        catch (CompoundNotFoundException e) {
            logger.error("Unexpected error when creating RNASequence ", (Throwable)e);
            return null;
        }
    }
}

