/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;

public class Helix {
    private QuatSymmetryScores scores = new QuatSymmetryScores();
    private List<Integer> permutation;
    private List<List<Integer>> repeatUnits;
    private Matrix4d transformation;
    private double rise;
    private int nStart;
    private int fold;
    private int contacts;

    public QuatSymmetryScores getScores() {
        return this.scores;
    }

    public void setScores(QuatSymmetryScores scores) {
        this.scores = scores;
    }

    public List<Integer> getPermutation() {
        return this.permutation;
    }

    public void setPermutation(List<Integer> permutation) {
        this.permutation = permutation;
    }

    public List<List<Integer>> getRepeatUnits() {
        return this.repeatUnits;
    }

    public void setRepeatUnits(List<List<Integer>> repeatUnits) {
        this.repeatUnits = repeatUnits;
    }

    public Matrix4d getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Matrix4d transformation) {
        this.transformation = transformation;
    }

    public double getRise() {
        return this.rise;
    }

    public void setRise(double rise) {
        this.rise = rise;
    }

    public double getAngle() {
        return this.getAxisAngle().angle;
    }

    public AxisAngle4d getAxisAngle() {
        AxisAngle4d axis = new AxisAngle4d();
        axis.set(this.transformation);
        return axis;
    }

    public int getnStart() {
        return this.nStart;
    }

    public void setnStart(int nStart) {
        this.nStart = nStart;
    }

    public int getFold() {
        return this.fold;
    }

    public void setFold(int fold) {
        this.fold = fold;
    }

    public int getContacts() {
        return this.contacts;
    }

    public void setContacts(int contacts) {
        this.contacts = contacts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Permutation   : " + this.getPermutation() + "\n");
        sb.append("Repeat units  : " + this.getRepeatUnits() + "\n");
        sb.append("Rise          : " + this.getRise() + "\n");
        sb.append("Angle         : " + Math.toDegrees(this.getAngle()) + "\n");
        sb.append("Fold          : " + this.getFold() + "\n");
        return sb.toString();
    }

    public List<List<Integer>> getLayerLines() {
        ArrayList<List<Integer>> layerLines = new ArrayList<List<Integer>>();
        Helix.createLineSegments(this.permutation, layerLines);
        int count = layerLines.size();
        do {
            count = layerLines.size();
            Helix.joinLineSegments(layerLines);
            Helix.trimEmptyLineSegments(layerLines);
        } while (layerLines.size() < count);
        return layerLines;
    }

    private static void createLineSegments(List<Integer> permutation, List<List<Integer>> layerLines) {
        for (int i = 0; i < permutation.size(); ++i) {
            if (permutation.get(i) == -1) continue;
            ArrayList<Integer> lineSegment = new ArrayList<Integer>();
            lineSegment.add(i);
            lineSegment.add(permutation.get(i));
            layerLines.add(lineSegment);
        }
    }

    private static void joinLineSegments(List<List<Integer>> layerLines) {
        for (int i = 0; i < layerLines.size() - 1; ++i) {
            List<Integer> lineSegmentI = layerLines.get(i);
            if (lineSegmentI.isEmpty()) continue;
            for (int j = i + 1; j < layerLines.size(); ++j) {
                List<Integer> lineSegmentJ = layerLines.get(j);
                if (lineSegmentJ.isEmpty()) continue;
                if (lineSegmentI.get(lineSegmentI.size() - 1).equals(lineSegmentJ.get(0))) {
                    lineSegmentI.addAll(lineSegmentJ.subList(1, lineSegmentJ.size()));
                    lineSegmentJ.clear();
                    continue;
                }
                if (!lineSegmentI.get(0).equals(lineSegmentJ.get(lineSegmentJ.size() - 1))) continue;
                lineSegmentI.addAll(0, lineSegmentJ.subList(0, lineSegmentJ.size() - 1));
                lineSegmentJ.clear();
            }
        }
    }

    private static void trimEmptyLineSegments(List<List<Integer>> layerLines) {
        Iterator<List<Integer>> iter = layerLines.iterator();
        while (iter.hasNext()) {
            if (!iter.next().isEmpty()) continue;
            iter.remove();
        }
    }
}

