/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.geometry;

import java.util.Arrays;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.symmetry.geometry.Polyhedron;

public class Octahedron
implements Polyhedron {
    private static double TETRAHEDRAL_ANGLE = Math.acos(-0.3333333333333333);
    private static int[] lineLoop1 = new int[]{2, 4, 3, 5, 2, 1, 3, 0, 5, 1, 4, 0, 2};
    private double cirumscribedRadius = 1.0;

    @Override
    public double getCirumscribedRadius() {
        return this.cirumscribedRadius;
    }

    public void setCirumscribedRadius(double cirumscribedRadius) {
        this.cirumscribedRadius = cirumscribedRadius;
    }

    public double getInscribedRadius() {
        double side = Octahedron.getSideLengthFromCircumscribedRadius(this.cirumscribedRadius);
        return Octahedron.getInscribedRadiusFromSideLength(side);
    }

    public void setInscribedRadius(double radius) {
        double side = Octahedron.getSideLengthFromInscribedRadius(radius);
        this.cirumscribedRadius = Octahedron.getCircumscribedRadiusFromSideLength(side);
    }

    public double getMidRadius() {
        double side = Octahedron.getSideLengthFromCircumscribedRadius(this.cirumscribedRadius);
        return Octahedron.getMiddleRadiusFromSideLength(side);
    }

    public void setMidRadius(double radius) {
        double side = Octahedron.getSideLengthFromMiddleRadius(radius);
        this.cirumscribedRadius = Octahedron.getCircumscribedRadiusFromSideLength(side);
    }

    @Override
    public Point3d[] getVertices() {
        Point3d[] octahedron = new Point3d[]{new Point3d(-this.cirumscribedRadius, 0.0, 0.0), new Point3d(this.cirumscribedRadius, 0.0, 0.0), new Point3d(0.0, -this.cirumscribedRadius, 0.0), new Point3d(0.0, this.cirumscribedRadius, 0.0), new Point3d(0.0, 0.0, -this.cirumscribedRadius), new Point3d(0.0, 0.0, this.cirumscribedRadius)};
        return octahedron;
    }

    @Override
    public List<int[]> getLineLoops() {
        return Arrays.asList(new int[][]{lineLoop1});
    }

    public Point3d getC4Axis(double scale) {
        return new Point3d(0.0, 0.0, this.cirumscribedRadius * scale);
    }

    public Point3d getC3Axis(double scale) {
        double s = 1.0 / Math.sqrt(1.0 + Math.sqrt(2.0));
        return new Point3d(this.cirumscribedRadius * scale * s, this.cirumscribedRadius * scale * s, this.cirumscribedRadius * scale * s);
    }

    public Point3d getC2Axis(double scale) {
        double s = 1.0 / Math.sqrt(2.0);
        return new Point3d(this.cirumscribedRadius * scale * s, this.cirumscribedRadius * scale * s, 0.0);
    }

    @Override
    public int getViewCount() {
        return 3;
    }

    @Override
    public String getViewName(int index) {
        String name;
        switch (index) {
            case 0: {
                name = "4-fold axis vertex-centered";
                break;
            }
            case 1: {
                name = "3-fold axis face-centered";
                break;
            }
            case 2: {
                name = "2-fold axis edge-centered";
                break;
            }
            default: {
                throw new IllegalArgumentException("getViewMatrix: index out of range:" + index);
            }
        }
        return name;
    }

    @Override
    public Matrix3d getViewMatrix(int index) {
        Matrix3d m = new Matrix3d();
        switch (index) {
            case 0: {
                m.setIdentity();
                break;
            }
            case 1: {
                m.rotX(-0.5 * TETRAHEDRAL_ANGLE);
                Matrix3d m1 = new Matrix3d();
                m1.rotZ(0.7853981633974483);
                m.mul(m1);
                break;
            }
            case 2: {
                m.rotY(0.7853981633974483);
                break;
            }
            default: {
                throw new IllegalArgumentException("getViewMatrix: index out of range:" + index);
            }
        }
        return m;
    }

    private static double getSideLengthFromInscribedRadius(double radius) {
        return radius * 6.0 / Math.sqrt(6.0);
    }

    private static double getInscribedRadiusFromSideLength(double sideLength) {
        return sideLength / 6.0 * Math.sqrt(6.0);
    }

    private static double getSideLengthFromMiddleRadius(double radius) {
        return radius * 2.0;
    }

    private static double getMiddleRadiusFromSideLength(double sideLength) {
        return sideLength / 2.0;
    }

    private static double getSideLengthFromCircumscribedRadius(double radius) {
        return radius * 2.0 / Math.sqrt(2.0);
    }

    private static double getCircumscribedRadiusFromSideLength(double sideLength) {
        return sideLength / 2.0 * Math.sqrt(2.0);
    }
}

