/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.scop;

import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.structure.scop.BerkeleyScopInstallation;
import org.biojava.nbio.structure.scop.LocalScopDatabase;
import org.biojava.nbio.structure.scop.RemoteScopInstallation;
import org.biojava.nbio.structure.scop.ScopDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopFactory {
    private static final Logger logger = LoggerFactory.getLogger(ScopFactory.class);
    public static final String VERSION_2_0_5 = "2.05";
    public static final String VERSION_2_0_4 = "2.04";
    public static final String VERSION_2_0_3 = "2.03";
    public static final String VERSION_2_0_2 = "2.02";
    public static final String VERSION_2_0_1 = "2.01";
    public static final String VERSION_1_75C = "2.03";
    public static final String VERSION_1_75B = "2.02";
    public static final String VERSION_1_75A = "2.01";
    public static final String VERSION_1_75 = "1.75";
    public static final String VERSION_1_73 = "1.73";
    public static final String VERSION_1_71 = "1.71";
    public static final String VERSION_1_69 = "1.69";
    public static final String VERSION_1_67 = "1.67";
    public static final String VERSION_1_65 = "1.65";
    public static final String VERSION_1_63 = "1.63";
    public static final String VERSION_1_61 = "1.61";
    public static final String VERSION_1_59 = "1.59";
    public static final String VERSION_1_57 = "1.57";
    public static final String VERSION_1_55 = "1.55";
    public static final String LATEST_VERSION = "2.05";
    private static Map<String, ScopDatabase> versionedScopDBs = new HashMap<String, ScopDatabase>();
    private static String defaultVersion = "2.05";

    public static ScopDatabase getSCOP() {
        return ScopFactory.getSCOP(defaultVersion);
    }

    public static ScopDatabase getSCOP(boolean forceLocalData) {
        return ScopFactory.getSCOP(defaultVersion, forceLocalData);
    }

    public static ScopDatabase getSCOP(String version) {
        return ScopFactory.getSCOP(version, false);
    }

    public static ScopDatabase getSCOP(String version, boolean forceLocalData) {
        if (version == null) {
            version = defaultVersion;
        }
        ScopDatabase scop = versionedScopDBs.get(version);
        if (forceLocalData) {
            if (scop == null || !(scop instanceof LocalScopDatabase)) {
                logger.info("Creating new {}, version {}", (Object)BerkeleyScopInstallation.class.getSimpleName(), (Object)version);
                BerkeleyScopInstallation berkeley = new BerkeleyScopInstallation();
                berkeley.setScopVersion(version);
                versionedScopDBs.put(version, berkeley);
                return berkeley;
            }
            return scop;
        }
        if (scop == null) {
            logger.info("Creating new {}, version {}", (Object)RemoteScopInstallation.class.getSimpleName(), (Object)version);
            scop = new RemoteScopInstallation();
            scop.setScopVersion(version);
            versionedScopDBs.put(version, scop);
        }
        return scop;
    }

    public static void setScopDatabase(String version) {
        ScopFactory.getSCOP(version);
        defaultVersion = version;
    }

    public static void setScopDatabase(String version, boolean forceLocalData) {
        logger.debug("ScopFactory: Setting ScopDatabase to version: {}, forced local: {}", (Object)version, (Object)forceLocalData);
        ScopFactory.getSCOP(version, forceLocalData);
        defaultVersion = version;
    }

    public static void setScopDatabase(ScopDatabase scop) {
        logger.debug("ScopFactory: Setting ScopDatabase to type: {}", (Object)scop.getClass().getName());
        defaultVersion = scop.getScopVersion();
        versionedScopDBs.put(defaultVersion, scop);
    }
}

