/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.List;
import java.util.Random;
import org.biojava.nbio.structure.align.ce.CeParameters;

public class CESymmParameters
extends CeParameters {
    private int maxSymmOrder;
    private int userOrder;
    private SymmetryType symmType;
    private OrderDetectorMethod orderDetectorMethod;
    private RefineMethod refineMethod;
    private boolean optimization;
    private int rndSeed;
    private int symmLevels;
    private double unrefinedScoreThreshold;
    private double refinedScoreThreshold;
    private int sseThreshold;
    private int minCoreLength;
    private double distanceCutoff;
    private boolean gaps;
    private int optimizationSteps;
    public static final double DEFAULT_SYMMETRY_THRESHOLD = 0.4;

    public CESymmParameters() {
        this.reset();
    }

    public CESymmParameters clone() {
        CESymmParameters p = new CESymmParameters();
        p.maxSymmOrder = this.maxSymmOrder;
        p.symmType = this.symmType;
        p.orderDetectorMethod = this.orderDetectorMethod;
        p.userOrder = this.userOrder;
        p.refineMethod = this.refineMethod;
        p.optimization = this.optimization;
        p.rndSeed = this.rndSeed;
        p.symmLevels = this.symmLevels;
        p.unrefinedScoreThreshold = this.unrefinedScoreThreshold;
        p.refinedScoreThreshold = this.refinedScoreThreshold;
        p.sseThreshold = this.sseThreshold;
        p.minCoreLength = this.minCoreLength;
        p.distanceCutoff = this.distanceCutoff;
        p.gaps = this.gaps;
        p.optimizationSteps = this.optimizationSteps;
        p.winSize = this.winSize;
        p.rmsdThr = this.rmsdThr;
        p.rmsdThrJoin = this.rmsdThrJoin;
        p.scoringStrategy = this.scoringStrategy;
        p.maxGapSize = this.maxGapSize;
        p.showAFPRanges = this.showAFPRanges;
        p.maxOptRMSD = this.maxOptRMSD;
        p.gapOpen = this.gapOpen;
        p.gapExtension = this.gapExtension;
        p.distanceIncrement = this.distanceIncrement;
        p.oRmsdThr = this.oRmsdThr;
        p.maxNrIterationsForOptimization = this.maxNrIterationsForOptimization;
        p.seqWeight = this.seqWeight;
        return p;
    }

    @Override
    public void reset() {
        super.reset();
        this.maxSymmOrder = 8;
        this.symmType = SymmetryType.DEFAULT;
        this.orderDetectorMethod = OrderDetectorMethod.DEFAULT;
        this.userOrder = 0;
        this.refineMethod = RefineMethod.DEFAULT;
        this.optimization = true;
        this.rndSeed = new Random().nextInt(10000);
        this.symmLevels = 0;
        this.unrefinedScoreThreshold = 0.4;
        this.refinedScoreThreshold = 0.36000000000000004;
        this.sseThreshold = 0;
        this.minCoreLength = 15;
        this.distanceCutoff = 7.0;
        this.gaps = true;
        this.optimizationSteps = 0;
    }

    @Override
    public List<String> getUserConfigHelp() {
        List<String> params = super.getUserConfigHelp();
        params.add("Sets the maximum order of symmetry of the protein.");
        params.add("Order of symmetry determined by the user. Use it with the USER_INPUT order option. Imposes an order of symmetry to the alignment. If 0 the order is set automatically.");
        StringBuilder symmTypes = new StringBuilder("Type of Symmetry: ");
        SymmetryType[] vals = SymmetryType.values();
        if (vals.length == 1) {
            symmTypes.append(vals[0].name());
        } else if (vals.length > 1) {
            for (int i = 0; i < vals.length - 1; ++i) {
                symmTypes.append(vals[i].name());
                symmTypes.append(", ");
            }
            symmTypes.append("or ");
            symmTypes.append(vals[vals.length - 1].name());
        }
        params.add(symmTypes.toString());
        StringBuilder orderTypes = new StringBuilder("Order Detection Method: ");
        OrderDetectorMethod[] vals2 = OrderDetectorMethod.values();
        if (vals2.length == 1) {
            orderTypes.append(vals2[0].name());
        } else if (vals2.length > 1) {
            for (int i = 0; i < vals2.length - 1; ++i) {
                orderTypes.append(vals2[i].name());
                orderTypes.append(", ");
            }
            orderTypes.append("or ");
            orderTypes.append(vals[vals.length - 1].name());
        }
        params.add(orderTypes.toString());
        StringBuilder refineTypes = new StringBuilder("Refinement Method: ");
        RefineMethod[] values = RefineMethod.values();
        if (values.length == 1) {
            refineTypes.append(values[0].name());
        } else if (values.length > 1) {
            for (int i = 0; i < values.length - 1; ++i) {
                refineTypes.append(values[i].name());
                refineTypes.append(", ");
            }
            refineTypes.append("or ");
            refineTypes.append(values[values.length - 1].name());
        }
        params.add(refineTypes.toString());
        params.add("Optimize the refined alignment if true.");
        params.add("Random seed for the Monte Carlo optimization, for reproducibility of results.");
        params.add("Specify the maximum number of symmetry levels to explore recursively. If equal to 1, only C and H symmetries can be found. If equal to 2, D and two-level hierarchical C and H can be found, etc. If equal to 0, the number of recursive iterations is unbounded (until thresholds reached).");
        params.add("Unrefined score threshold: TM-score values for the optimal self-alignment, before refinement, below the threshold will be considered asymmetric.");
        params.add("Refined score threshold: TM-score values for the refined multiple alignment of repeats below the threshold will be considered asymmetric.");
        params.add("SSE threshold: The minimum number of secondary structure elements (strands or helices) in each symmetrical repeat. If the repeats do not have enough SSE, the structure will be considered asymmetric. 0 means no restriction.");
        params.add("Minimum core length: the minimum number of non-gapped residues in every symmetric repeat.");
        params.add("Distance Cutoff: the maximum allowed distance (in A) between two aligned residues.");
        params.add("Internal Gaps: allow up to 50% of repeats to have gaps in the multiple alignment if true, otherwise all repeats must be aligned at each position.");
        params.add("Optimization Steps: maximum number of optimization steps: 0 means calculated automatically with the alignment length.");
        return params;
    }

    @Override
    public List<String> getUserConfigParameters() {
        List<String> params = super.getUserConfigParameters();
        params.add("MaxSymmOrder");
        params.add("UserOrder");
        params.add("SymmType");
        params.add("OrderDetectorMethod");
        params.add("RefineMethod");
        params.add("Optimization");
        params.add("RndSeed");
        params.add("SymmLevels");
        params.add("UnrefinedScoreThreshold");
        params.add("RefinedScoreThreshold");
        params.add("SSEThreshold");
        params.add("MinCoreLength");
        params.add("DistanceCutoff");
        params.add("Gaps");
        params.add("OptimizationSteps");
        return params;
    }

    @Override
    public List<String> getUserConfigParameterNames() {
        List<String> params = super.getUserConfigParameterNames();
        params.add("Maximum Order of Symmetry");
        params.add("User Input Order");
        params.add("Type of Symmetry");
        params.add("Order Detection Method");
        params.add("Refinement Method");
        params.add("Optimization");
        params.add("Random Seed");
        params.add("Symmetry Levels");
        params.add("Unrefined Score Threshold");
        params.add("Refined Score Threshold");
        params.add("SSE Threshold");
        params.add("Minimum Core Length");
        params.add("Distance Cutoff");
        params.add("Internal Gaps");
        params.add("Optimization Steps");
        return params;
    }

    @Override
    public List<Class> getUserConfigTypes() {
        List<Class> params = super.getUserConfigTypes();
        params.add(Integer.class);
        params.add(Integer.class);
        params.add(SymmetryType.class);
        params.add(OrderDetectorMethod.class);
        params.add(RefineMethod.class);
        params.add(Boolean.class);
        params.add(Integer.class);
        params.add(Integer.class);
        params.add(Double.class);
        params.add(Double.class);
        params.add(Integer.class);
        params.add(Integer.class);
        params.add(Double.class);
        params.add(Boolean.class);
        params.add(Integer.class);
        return params;
    }

    public RefineMethod getRefineMethod() {
        return this.refineMethod;
    }

    public void setRefineMethod(RefineMethod refineMethod) {
        this.refineMethod = refineMethod;
    }

    @Deprecated
    public void setRefineResult(boolean doRefine) {
        this.refineMethod = !doRefine ? RefineMethod.NOT_REFINED : RefineMethod.DEFAULT;
    }

    public OrderDetectorMethod getOrderDetectorMethod() {
        return this.orderDetectorMethod;
    }

    public void setOrderDetectorMethod(OrderDetectorMethod orderDetectorMethod) {
        this.orderDetectorMethod = orderDetectorMethod;
    }

    public void setUserOrder(Integer userOrder) {
        this.userOrder = userOrder;
    }

    public int getUserOrder() {
        return this.userOrder;
    }

    public void setMaxSymmOrder(Integer maxSymmOrder) {
        this.maxSymmOrder = maxSymmOrder;
    }

    public int getMaxSymmOrder() {
        return this.maxSymmOrder;
    }

    public SymmetryType getSymmType() {
        return this.symmType;
    }

    public void setSymmType(SymmetryType type) {
        this.symmType = type;
    }

    public boolean getOptimization() {
        return this.optimization;
    }

    public void setOptimization(Boolean optimization) {
        this.optimization = optimization;
    }

    public int getRndSeed() {
        return this.rndSeed;
    }

    public void setRndSeed(Integer seed) {
        this.rndSeed = seed;
    }

    public int getSymmLevels() {
        return this.symmLevels;
    }

    public void setSymmLevels(Integer symmLevels) {
        this.symmLevels = symmLevels;
    }

    public double getUnrefinedScoreThreshold() {
        return this.unrefinedScoreThreshold;
    }

    public void setUnrefinedScoreThreshold(Double unrefinedScoreThreshold) {
        this.unrefinedScoreThreshold = unrefinedScoreThreshold;
    }

    public double getRefinedScoreThreshold() {
        return this.refinedScoreThreshold;
    }

    public void setRefinedScoreThreshold(Double refinedScoreThreshold) {
        this.refinedScoreThreshold = refinedScoreThreshold;
    }

    public int getSSEThreshold() {
        return this.sseThreshold;
    }

    public void setSSEThreshold(Integer sseThreshold) {
        this.sseThreshold = sseThreshold;
    }

    public int getMinCoreLength() {
        return this.minCoreLength;
    }

    public void setMinCoreLength(Integer minCoreLength) {
        this.minCoreLength = minCoreLength;
    }

    public double getDistanceCutoff() {
        return this.distanceCutoff;
    }

    public void setDistanceCutoff(Double distanceCutoff) {
        this.distanceCutoff = distanceCutoff;
    }

    public boolean isGaps() {
        return this.gaps;
    }

    public void setGaps(Boolean gaps) {
        this.gaps = gaps;
    }

    public int getOptimizationSteps() {
        return this.optimizationSteps;
    }

    public void setOptimizationSteps(Integer optimizationSteps) {
        this.optimizationSteps = optimizationSteps;
    }

    @Override
    public String toString() {
        return "CESymmParameters [maxSymmOrder=" + this.maxSymmOrder + ", userOrder=" + this.userOrder + ", symmType=" + (Object)((Object)this.symmType) + ", orderDetectorMethod=" + (Object)((Object)this.orderDetectorMethod) + ", refineMethod=" + (Object)((Object)this.refineMethod) + ", optimization=" + this.optimization + ", rndSeed=" + this.rndSeed + ", symmLevels=" + this.symmLevels + ", unrefinedScoreThreshold=" + this.unrefinedScoreThreshold + ", refinedScoreThreshold=" + this.refinedScoreThreshold + ", sseThreshold=" + this.sseThreshold + ", minCoreLength=" + this.minCoreLength + ", distanceCutoff=" + this.distanceCutoff + ", gaps=" + this.gaps + ", optimizationSteps=" + this.optimizationSteps + "]";
    }

    public static enum SymmetryType {
        CLOSED,
        OPEN,
        AUTO;

        public static final SymmetryType DEFAULT;

        static {
            DEFAULT = AUTO;
        }
    }

    public static enum RefineMethod {
        NOT_REFINED,
        SEQUENCE_FUNCTION,
        GRAPH_COMPONENT;

        public static final RefineMethod DEFAULT;

        static {
            DEFAULT = SEQUENCE_FUNCTION;
        }
    }

    public static enum OrderDetectorMethod {
        SEQUENCE_FUNCTION,
        GRAPH_COMPONENT,
        ANGLE,
        USER_INPUT;

        public static final OrderDetectorMethod DEFAULT;

        static {
            DEFAULT = SEQUENCE_FUNCTION;
        }
    }
}

