/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.MMCIFFileReader;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyBuilder;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.quaternary.io.BioUnitDataProvider;
import org.biojava.nbio.structure.quaternary.io.BioUnitDataProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureIO {
    private static final Logger logger = LoggerFactory.getLogger(StructureIO.class);
    private static AtomCache cache;
    private static final String FILE_SEPARATOR;

    public static Structure getStructure(String name) throws IOException, StructureException {
        StructureIO.checkInitAtomCache();
        return cache.getStructure(name);
    }

    private static void checkInitAtomCache() {
        if (cache == null) {
            cache = new AtomCache();
        }
    }

    public static void setAtomCache(AtomCache c) {
        cache = c;
    }

    public static Structure getBiologicalAssembly(String pdbId) throws IOException, StructureException {
        return StructureIO.getBiologicalAssembly(pdbId, 1);
    }

    public static Structure getBiologicalAssembly(String pdbId, int biolAssemblyNr) throws IOException, StructureException {
        StructureIO.checkInitAtomCache();
        return StructureIO.getBiologicalAssembly(pdbId, biolAssemblyNr, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Structure getBiologicalAssembly(String pdbId, int biolAssemblyNr, AtomCache cache) throws IOException, StructureException {
        BioUnitDataProvider provider = null;
        try {
            Structure bio;
            provider = BioUnitDataProviderFactory.getBioUnitDataProvider();
            provider.setAtomCache(cache);
            Structure structure = bio = StructureIO.getBiologicalAssembly(pdbId, biolAssemblyNr, cache, BioUnitDataProviderFactory.getBioUnitDataProvider());
            return structure;
        }
        finally {
            if (provider != null) {
                provider.setAsymUnit(null);
                provider.setAtomCache(null);
            }
        }
    }

    public static Structure getBiologicalAssembly(String pdbId, int biolAssemblyNr, AtomCache cache, BioUnitDataProvider provider) throws IOException, StructureException {
        pdbId = pdbId.toLowerCase();
        Structure asymUnit = provider.getAsymUnit(pdbId);
        if (biolAssemblyNr == 0) {
            logger.info("Requested biological assembly 0 for PDB id " + pdbId + ", returning asymmetric unit");
            return asymUnit;
        }
        if (!asymUnit.getPDBHeader().getBioAssemblies().containsKey(biolAssemblyNr)) {
            throw new StructureException("No biological assembly available for biological assembly nr " + biolAssemblyNr + " of " + pdbId);
        }
        List<BiologicalAssemblyTransformation> transformations = asymUnit.getPDBHeader().getBioAssemblies().get(biolAssemblyNr).getTransforms();
        if (transformations == null || transformations.size() == 0) {
            throw new StructureException("Could not load transformations to recreate biological assembly nr " + biolAssemblyNr + " of " + pdbId);
        }
        BiologicalAssemblyBuilder builder = new BiologicalAssemblyBuilder();
        return builder.rebuildQuaternaryStructure(asymUnit, transformations);
    }

    public static boolean hasBiologicalAssembly(String pdbId) {
        pdbId = pdbId.toLowerCase();
        BioUnitDataProvider provider = BioUnitDataProviderFactory.getBioUnitDataProvider();
        StructureIO.checkInitAtomCache();
        provider.setAtomCache(cache);
        return provider.hasBiolAssembly(pdbId);
    }

    public static int getNrBiologicalAssemblies(String pdbId) {
        pdbId = pdbId.toLowerCase();
        BioUnitDataProvider provider = BioUnitDataProviderFactory.getBioUnitDataProvider();
        StructureIO.checkInitAtomCache();
        provider.setAtomCache(cache);
        return provider.getNrBiolAssemblies(pdbId);
    }

    public static void setPdbPath(String pathToPDBFiles) {
        if (!pathToPDBFiles.endsWith(FILE_SEPARATOR)) {
            pathToPDBFiles = pathToPDBFiles + FILE_SEPARATOR;
        }
    }

    public static StructureFiletype guessFiletype(String filename) {
        String lower = filename.toLowerCase();
        for (StructureFiletype type : StructureFiletype.values()) {
            for (String ext : type.getExtensions()) {
                if (!lower.endsWith(ext.toLowerCase())) continue;
                return type;
            }
        }
        return StructureFiletype.UNKNOWN;
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
    }

    public static enum StructureFiletype {
        PDB(new PDBFileReader().getExtensions()),
        CIF(new MMCIFFileReader().getExtensions()),
        UNKNOWN(Collections.emptyList());

        private List<String> extensions;

        private StructureFiletype(List<String> extensions) {
            this.extensions = extensions;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }
    }
}

