/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import org.biojava.nbio.core.util.FileDownloadUtils;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomIterator;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupIterator;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.contact.AtomContactSet;
import org.biojava.nbio.structure.contact.Grid;
import org.biojava.nbio.structure.io.PDBFileParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureTools {
    private static final Logger logger;
    public static final String CA_ATOM_NAME = "CA";
    public static final String N_ATOM_NAME = "N";
    public static final String C_ATOM_NAME = "C";
    public static final String O_ATOM_NAME = "O";
    public static final String CB_ATOM_NAME = "CB";
    public static final String C1_ATOM_NAME = "C1'";
    public static final String C2_ATOM_NAME = "C2'";
    public static final String C3_ATOM_NAME = "C3'";
    public static final String C4_ATOM_NAME = "C4'";
    public static final String O2_ATOM_NAME = "O2'";
    public static final String O3_ATOM_NAME = "O3'";
    public static final String O4_ATOM_NAME = "O4'";
    public static final String O5_ATOM_NAME = "O5'";
    public static final String OP1_ATOM_NAME = "OP1";
    public static final String OP2_ATOM_NAME = "OP2";
    public static final String P_ATOM_NAME = "P";
    public static final String NUCLEOTIDE_REPRESENTATIVE = "P";
    public static final char UNKNOWN_GROUP_LABEL = 'X';
    public static final double RATIO_RESIDUES_TO_TOTAL = 0.95;
    public static final double DEFAULT_LIGAND_PROXIMITY_CUTOFF = 5.0;
    private static final Map<String, Character> nucleotides30;
    private static final Map<String, Character> nucleotides23;
    private static final Map<String, Character> aminoAcids;
    private static final Set<Element> hBondDonorAcceptors;

    public static final int getNrAtoms(Structure s) {
        int nrAtoms = 0;
        GroupIterator iter = new GroupIterator(s);
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            nrAtoms += g.size();
        }
        return nrAtoms;
    }

    public static final int getNrGroups(Structure s) {
        int nrGroups = 0;
        List<Chain> chains = s.getChains(0);
        for (Chain c : chains) {
            nrGroups += c.getAtomLength();
        }
        return nrGroups;
    }

    public static final Atom[] getAtomArray(Structure s, String[] atomNames) {
        List<Chain> chains = s.getModel(0);
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        StructureTools.extractAtoms(atomNames, chains, atoms);
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getAtomArrayAllModels(Structure s, String[] atomNames) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (int i = 0; i < s.nrModels(); ++i) {
            List<Chain> chains = s.getModel(i);
            StructureTools.extractAtoms(atomNames, chains, atoms);
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getAllAtomArray(Structure s) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        AtomIterator iter = new AtomIterator(s);
        while (iter.hasNext()) {
            Atom a = iter.next();
            atoms.add(a);
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getAllAtomArray(Structure s, int model) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        AtomIterator iter = new AtomIterator(s, model);
        while (iter.hasNext()) {
            Atom a = iter.next();
            atoms.add(a);
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getAllAtomArray(Chain c) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Group g : c.getAtomGroups()) {
            if (g.isWater()) continue;
            for (Atom a : g.getAtoms()) {
                atoms.add(a);
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static List<Group> getUnalignedGroups(Atom[] ca) {
        Chain c2;
        Object g;
        HashSet<Chain> chains = new HashSet<Chain>();
        HashSet<Group> caGroups = new HashSet<Group>();
        Structure s = null;
        if (ca.length > 0 && (g = ca[0].getGroup()) != null && (c2 = g.getChain()) != null) {
            s = c2.getStructure();
        }
        if (s != null) {
            for (Chain c2 : s.getChains(0)) {
                chains.add(c2);
            }
        }
        for (Atom a : ca) {
            Group g2 = a.getGroup();
            if (g2 == null) continue;
            caGroups.add(g2);
            Chain c3 = g2.getChain();
            if (c3 == null) continue;
            chains.add(c3);
        }
        ArrayList<Group> unadded = new ArrayList<Group>();
        for (Chain c4 : chains) {
            for (Group g2 : c4.getAtomGroups()) {
                if (caGroups.contains(g2)) continue;
                unadded.add(g2);
            }
        }
        return unadded;
    }

    public static List<Group> getLigandsByProximity(Collection<Group> target, Atom[] query, double cutoff) {
        Grid grid = new Grid(cutoff);
        grid.addAtoms(query);
        ArrayList<Group> ligands = new ArrayList<Group>();
        for (Group g : target) {
            List<Atom> groupAtoms;
            if (g.isWater() || g.isPolymeric() || !grid.hasAnyContact(Calc.atomsToPoints(groupAtoms = g.getAtoms()))) continue;
            ligands.add(g);
        }
        return ligands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Chain addGroupToStructure(Structure s, Group g, int model, Chain chainGuess, boolean clone) {
        Structure structure = s;
        synchronized (structure) {
            Chain chain;
            String chainId = g.getChainId();
            assert (!chainId.isEmpty());
            if (chainGuess != null && chainGuess.getId() == chainId) {
                chain = chainGuess;
            } else {
                chain = s.getChain(chainId, model);
                if (chain == null) {
                    chain = new ChainImpl();
                    chain.setId(chainId);
                    Chain oldChain = g.getChain();
                    chain.setName(oldChain.getName());
                    EntityInfo oldEntityInfo = oldChain.getEntityInfo();
                    EntityInfo newEntityInfo = s.getEntityById(oldEntityInfo.getMolId());
                    if (newEntityInfo == null) {
                        newEntityInfo = new EntityInfo(oldEntityInfo);
                        s.addEntityInfo(newEntityInfo);
                    }
                    newEntityInfo.addChain(chain);
                    chain.setEntityInfo(newEntityInfo);
                    chain.setSeqResGroups(oldChain.getSeqResGroups());
                    chain.setSeqMisMatches(oldChain.getSeqMisMatches());
                    s.addChain(chain, model);
                }
            }
            if (clone) {
                g = (Group)g.clone();
            }
            chain.addGroup(g);
            return chain;
        }
    }

    public static void addGroupsToStructure(Structure s, Collection<Group> groups, int model, boolean clone) {
        Chain chainGuess = null;
        for (Group g : groups) {
            chainGuess = StructureTools.addGroupToStructure(s, g, model, chainGuess, clone);
        }
    }

    public static Set<Group> getAllGroupsFromSubset(Atom[] atoms) {
        return StructureTools.getAllGroupsFromSubset(atoms, null);
    }

    public static Set<Group> getAllGroupsFromSubset(Atom[] atoms, GroupType types) {
        Object c;
        Group g;
        Structure s = null;
        if (atoms.length > 0 && (g = atoms[0].getGroup()) != null && (c = g.getChain()) != null) {
            s = c.getStructure();
        }
        HashSet<Chain> allChains = new HashSet<Chain>();
        if (s != null) {
            allChains.addAll(s.getChains());
        }
        for (Atom a : atoms) {
            Chain c2;
            Group g2 = a.getGroup();
            if (g2 == null || (c2 = g2.getChain()) == null) continue;
            allChains.add(c2);
        }
        if (allChains.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Group> full = new HashSet<Group>();
        for (Chain c3 : allChains) {
            if (types == null) {
                full.addAll(c3.getAtomGroups());
                continue;
            }
            full.addAll(c3.getAtomGroups(types));
        }
        return full;
    }

    public static final Atom[] getAllNonHAtomArray(Structure s, boolean hetAtoms) {
        AtomIterator iter = new AtomIterator(s);
        return StructureTools.getAllNonHAtomArray(s, hetAtoms, iter);
    }

    public static final Atom[] getAllNonHAtomArray(Structure s, boolean hetAtoms, int modelNr) {
        AtomIterator iter = new AtomIterator(s, modelNr);
        return StructureTools.getAllNonHAtomArray(s, hetAtoms, iter);
    }

    private static final Atom[] getAllNonHAtomArray(Structure s, boolean hetAtoms, AtomIterator iter) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        while (iter.hasNext()) {
            Group g;
            Atom a = iter.next();
            if (a.getElement() == Element.H || (g = a.getGroup()).isWater() || !hetAtoms && g.getType().equals((Object)GroupType.HETATM)) continue;
            atoms.add(a);
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getAllNonHAtomArray(Chain c, boolean hetAtoms) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Group g : c.getAtomGroups()) {
            if (g.isWater()) continue;
            for (Atom a : g.getAtoms()) {
                if (a.getElement() == Element.H || !hetAtoms && g.getType().equals((Object)GroupType.HETATM)) continue;
                atoms.add(a);
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Point3d[] getAllNonHCoordsArray(Chain c, boolean hetAtoms) {
        ArrayList<Point3d> atoms = new ArrayList<Point3d>();
        for (Group g : c.getAtomGroups()) {
            if (g.isWater()) continue;
            for (Atom a : g.getAtoms()) {
                if (a.getElement() == Element.H || !hetAtoms && g.getType().equals((Object)GroupType.HETATM)) continue;
                atoms.add(a.getCoordsAsPoint3d());
            }
        }
        return atoms.toArray(new Point3d[atoms.size()]);
    }

    private static void extractAtoms(String[] atomNames, List<Chain> chains, List<Atom> atoms) {
        for (Chain c : chains) {
            for (Group g : c.getAtomGroups()) {
                ArrayList<Atom> thisGroupAtoms = new ArrayList<Atom>();
                boolean thisGroupAllAtoms = true;
                for (String atomName : atomNames) {
                    Atom a = g.getAtom(atomName);
                    if (a == null) {
                        thisGroupAllAtoms = false;
                        break;
                    }
                    thisGroupAtoms.add(a);
                }
                if (!thisGroupAllAtoms) continue;
                for (Atom a : thisGroupAtoms) {
                    atoms.add(a);
                }
            }
        }
    }

    public static final Atom[] getAtomArray(Chain c, String[] atomNames) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Group g : c.getAtomGroups()) {
            ArrayList<Atom> thisGroupAtoms = new ArrayList<Atom>();
            boolean thisGroupAllAtoms = true;
            for (String atomName : atomNames) {
                Atom a = g.getAtom(atomName);
                if (a == null) {
                    logger.debug("Group " + g.getResidueNumber() + " (" + g.getPDBName() + ") does not have the required atom '" + atomName + "'");
                    thisGroupAllAtoms = false;
                    break;
                }
                thisGroupAtoms.add(a);
            }
            if (!thisGroupAllAtoms) continue;
            for (Atom a : thisGroupAtoms) {
                atoms.add(a);
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getAtomCAArray(Chain c) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Group g : c.getAtomGroups()) {
            if (!g.hasAtom(CA_ATOM_NAME) || g.getAtom(CA_ATOM_NAME).getElement() != Element.C) continue;
            atoms.add(g.getAtom(CA_ATOM_NAME));
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getRepresentativeAtomArray(Chain c) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Group g : c.getAtomGroups()) {
            switch (g.getType()) {
                case AMINOACID: {
                    if (!g.hasAtom(CA_ATOM_NAME) || g.getAtom(CA_ATOM_NAME).getElement() != Element.C) break;
                    atoms.add(g.getAtom(CA_ATOM_NAME));
                    break;
                }
                case NUCLEOTIDE: {
                    if (!g.hasAtom("P")) break;
                    atoms.add(g.getAtom("P"));
                    break;
                }
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] cloneAtomArray(Atom[] ca) {
        Atom[] newCA = new Atom[ca.length];
        ArrayList<Chain> model = new ArrayList<Chain>();
        int apos = -1;
        for (Atom a : ca) {
            ++apos;
            Group parentG = a.getGroup();
            Chain parentC = parentG.getChain();
            Chain newChain = null;
            for (Chain c : model) {
                if (!c.getName().equals(parentC.getName())) continue;
                newChain = c;
                break;
            }
            if (newChain == null) {
                newChain = new ChainImpl();
                newChain.setId(parentC.getId());
                newChain.setName(parentC.getName());
                model.add(newChain);
            }
            Group parentN = (Group)parentG.clone();
            newCA[apos] = parentN.getAtom(a.getName());
            try {
                newChain.getGroupByPDB(parentN.getResidueNumber());
            }
            catch (StructureException e) {
                newChain.addGroup(parentN);
            }
        }
        return newCA;
    }

    public static Group[] cloneGroups(Atom[] ca) {
        Group[] newGroup = new Group[ca.length];
        ArrayList<ChainImpl> model = new ArrayList<ChainImpl>();
        int apos = -1;
        for (Atom a : ca) {
            Group ng;
            ++apos;
            Group parentG = a.getGroup();
            Chain parentC = parentG.getChain();
            Chain newChain = null;
            for (Chain chain : model) {
                if (!chain.getName().equals(parentC.getName())) continue;
                newChain = chain;
                break;
            }
            if (newChain == null) {
                newChain = new ChainImpl();
                newChain.setName(parentC.getName());
                model.add((ChainImpl)newChain);
            }
            newGroup[apos] = ng = (Group)parentG.clone();
            newChain.addGroup(ng);
        }
        return newGroup;
    }

    public static Atom[] duplicateCA2(Atom[] ca2) {
        Chain orig;
        Group g;
        Atom[] ca2clone = new Atom[ca2.length * 2];
        int pos = 0;
        ChainImpl c = null;
        String prevChainId = "";
        for (Atom a : ca2) {
            g = (Group)a.getGroup().clone();
            if (c == null) {
                c = new ChainImpl();
                orig = a.getGroup().getChain();
                c.setId(orig.getId());
                c.setName(orig.getName());
            } else {
                orig = a.getGroup().getChain();
                if (!orig.getId().equals(prevChainId)) {
                    c = new ChainImpl();
                    c.setId(orig.getId());
                    c.setName(orig.getName());
                }
            }
            c.addGroup(g);
            ca2clone[pos] = g.getAtom(a.getName());
            ++pos;
        }
        c = null;
        prevChainId = "";
        for (Atom a : ca2) {
            g = (Group)a.getGroup().clone();
            if (c == null) {
                c = new ChainImpl();
                orig = a.getGroup().getChain();
                c.setId(orig.getId());
                c.setName(orig.getName());
            } else {
                orig = a.getGroup().getChain();
                if (!orig.getId().equals(prevChainId)) {
                    c = new ChainImpl();
                    c.setId(orig.getId());
                    c.setName(orig.getName());
                }
            }
            c.addGroup(g);
            ca2clone[pos] = g.getAtom(a.getName());
            ++pos;
        }
        return ca2clone;
    }

    public static Atom[] getAtomCAArray(Structure s) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Chain c : s.getChains()) {
            for (Group g : c.getAtomGroups()) {
                if (!g.hasAtom(CA_ATOM_NAME) || g.getAtom(CA_ATOM_NAME).getElement() != Element.C) continue;
                atoms.add(g.getAtom(CA_ATOM_NAME));
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static Atom[] getRepresentativeAtomArray(Structure s) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Chain c : s.getChains()) {
            Atom[] chainAtoms;
            for (Atom a : chainAtoms = StructureTools.getRepresentativeAtomArray(c)) {
                atoms.add(a);
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static Atom[] getBackboneAtomArray(Structure s) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Chain c : s.getChains()) {
            for (Group g : c.getAtomGroups()) {
                if (!g.hasAminoAtoms()) continue;
                block5: for (Atom a : g.getAtoms()) {
                    switch (g.getType()) {
                        case NUCLEOTIDE: {
                            if (a.getName().equals(C1_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (a.getName().equals(C2_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (a.getName().equals(C3_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (a.getName().equals(C4_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (a.getName().equals(O2_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (a.getName().equals(O3_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (a.getName().equals(O4_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (a.getName().equals(O5_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (a.getName().equals(OP1_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (a.getName().equals(OP2_ATOM_NAME)) {
                                atoms.add(a);
                            }
                            if (!a.getName().equals("P")) continue block5;
                            atoms.add(a);
                            continue block5;
                        }
                    }
                    if (a.getName().equals(CA_ATOM_NAME)) {
                        atoms.add(a);
                    }
                    if (a.getName().equals(C_ATOM_NAME)) {
                        atoms.add(a);
                    }
                    if (a.getName().equals(N_ATOM_NAME)) {
                        atoms.add(a);
                    }
                    if (!a.getName().equals(O_ATOM_NAME)) continue;
                    atoms.add(a);
                }
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Character get1LetterCodeAmino(String groupCode3) {
        return aminoAcids.get(groupCode3);
    }

    public static final Character get1LetterCode(String groupCode3) {
        Character code1 = StructureTools.get1LetterCodeAmino(groupCode3);
        if (code1 == null) {
            if (StructureTools.isNucleotide(groupCode3 = groupCode3.trim())) {
                code1 = nucleotides30.get(groupCode3);
                if (code1 == null) {
                    code1 = nucleotides23.get(groupCode3);
                }
                if (code1 == null) {
                    code1 = Character.valueOf('X');
                }
            } else {
                code1 = Character.valueOf('X');
            }
        }
        return code1;
    }

    public static final boolean isNucleotide(String groupCode3) {
        String code = groupCode3.trim();
        return nucleotides30.containsKey(code) || nucleotides23.containsKey(code);
    }

    @Deprecated
    public static final Structure getReducedStructure(Structure s, String chainId) throws StructureException {
        StructureImpl newS = new StructureImpl();
        newS.setPDBCode(s.getPDBCode());
        newS.setPDBHeader(s.getPDBHeader());
        newS.setName(s.getName());
        newS.setSSBonds(s.getSSBonds());
        newS.setDBRefs(s.getDBRefs());
        newS.setSites(s.getSites());
        newS.setBiologicalAssembly(s.isBiologicalAssembly());
        newS.setEntityInfos(s.getEntityInfos());
        newS.setSSBonds(s.getSSBonds());
        newS.setSites(s.getSites());
        if (chainId != null) {
            chainId = chainId.trim();
        }
        if (chainId == null || chainId.equals("")) {
            List<Chain> model0 = s.getModel(0);
            for (Chain c : model0) {
                newS.addChain(c);
            }
            return newS;
        }
        Chain c = null;
        try {
            c = s.getChainByPDB(chainId);
        }
        catch (StructureException e) {
            logger.warn(e.getMessage() + ". Chain id " + chainId + " did not match, trying upper case Chain id.");
            c = s.getChainByPDB(chainId.toUpperCase());
        }
        if (c != null) {
            newS.addChain(c);
            for (EntityInfo comp : s.getEntityInfos()) {
                if (comp.getChainIds() == null || !comp.getChainIds().contains(c.getChainID())) continue;
                newS.getPDBHeader().setDescription("Chain " + c.getChainID() + " of " + s.getPDBCode() + " " + comp.getDescription());
            }
        }
        return newS;
    }

    public static final String convertAtomsToSeq(Atom[] atoms) {
        StringBuilder buf = new StringBuilder();
        Object prevGroup = null;
        for (Atom a : atoms) {
            Group g = a.getGroup();
            if (prevGroup != null && prevGroup.equals(g)) continue;
            String code3 = g.getPDBName();
            Character code1 = StructureTools.get1LetterCodeAmino(code3);
            if (code1 == null) {
                code1 = Character.valueOf('X');
            }
            buf.append(code1);
            prevGroup = g;
        }
        return buf.toString();
    }

    public static final Group getGroupByPDBResidueNumber(Structure struc, ResidueNumber pdbResNum) throws StructureException {
        if (struc == null || pdbResNum == null) {
            throw new IllegalArgumentException("Null argument(s).");
        }
        Chain chain = struc.getPolyChainByPDB(pdbResNum.getChainName());
        return chain.getGroupByPDB(pdbResNum);
    }

    public static AtomContactSet getAtomsInContact(Chain chain, String[] atomNames, double cutoff) {
        Grid grid = new Grid(cutoff);
        Atom[] atoms = null;
        atoms = atomNames == null ? StructureTools.getAllNonHAtomArray(chain, false) : StructureTools.getAtomArray(chain, atomNames);
        if (atoms.length == 0) {
            logger.warn("No atoms found for buidling grid!");
            return new AtomContactSet(cutoff);
        }
        grid.addAtoms(atoms);
        return grid.getAtomContacts();
    }

    public static AtomContactSet getAtomsInContact(Chain chain, double cutoff) {
        return StructureTools.getAtomsInContact(chain, null, cutoff);
    }

    public static AtomContactSet getAtomsCAInContact(Chain chain, double cutoff) {
        Grid grid = new Grid(cutoff);
        Atom[] atoms = StructureTools.getAtomCAArray(chain);
        grid.addAtoms(atoms);
        return grid.getAtomContacts();
    }

    public static AtomContactSet getRepresentativeAtomsInContact(Chain chain, double cutoff) {
        Grid grid = new Grid(cutoff);
        Atom[] atoms = StructureTools.getRepresentativeAtomArray(chain);
        grid.addAtoms(atoms);
        return grid.getAtomContacts();
    }

    public static AtomContactSet getAtomsInContact(Chain chain1, Chain chain2, String[] atomNames, double cutoff, boolean hetAtoms) {
        Grid grid = new Grid(cutoff);
        Atom[] atoms1 = null;
        Atom[] atoms2 = null;
        if (atomNames == null) {
            atoms1 = StructureTools.getAllNonHAtomArray(chain1, hetAtoms);
            atoms2 = StructureTools.getAllNonHAtomArray(chain2, hetAtoms);
        } else {
            atoms1 = StructureTools.getAtomArray(chain1, atomNames);
            atoms2 = StructureTools.getAtomArray(chain2, atomNames);
        }
        grid.addAtoms(atoms1, atoms2);
        return grid.getAtomContacts();
    }

    public static AtomContactSet getAtomsInContact(Chain chain1, Chain chain2, double cutoff, boolean hetAtoms) {
        return StructureTools.getAtomsInContact(chain1, chain2, null, cutoff, hetAtoms);
    }

    public static Map<Group, Double> getGroupDistancesWithinShell(Structure structure, Atom centroid, Set<ResidueNumber> excludeResidues, double radius, boolean includeWater, boolean useAverageDistance) {
        radius *= radius;
        HashMap<Group, Double> distances = new HashMap<Group, Double>();
        HashMap<Group, Integer> atomCounts = new HashMap<Group, Integer>();
        for (Chain chain : structure.getChains()) {
            block1: for (Group chainGroup : chain.getAtomGroups()) {
                if (!includeWater && chainGroup.isWater()) continue;
                for (ResidueNumber rn : excludeResidues) {
                    if (!rn.equals(chainGroup.getResidueNumber())) continue;
                    continue block1;
                }
                for (Atom testAtom : chainGroup.getAtoms()) {
                    double dist = Calc.getDistanceFast(centroid, testAtom);
                    if (!(dist <= radius)) continue;
                    if (!distances.containsKey(chainGroup)) {
                        distances.put(chainGroup, Double.POSITIVE_INFINITY);
                    }
                    if (useAverageDistance) {
                        distances.put(chainGroup, (Double)distances.get(chainGroup) + Math.sqrt(dist));
                        if (!atomCounts.containsKey(chainGroup)) {
                            atomCounts.put(chainGroup, 0);
                        }
                        atomCounts.put(chainGroup, (Integer)atomCounts.get(chainGroup) + 1);
                        continue;
                    }
                    if (!(dist < (Double)distances.get(chainGroup))) continue;
                    distances.put(chainGroup, dist);
                }
            }
        }
        if (useAverageDistance) {
            for (Map.Entry entry : distances.entrySet()) {
                int count = (Integer)atomCounts.get(entry.getKey());
                distances.put((Group)entry.getKey(), (Double)entry.getValue() / (double)count);
            }
        } else {
            for (Map.Entry entry : distances.entrySet()) {
                distances.put((Group)entry.getKey(), Math.sqrt((Double)entry.getValue()));
            }
        }
        return distances;
    }

    public static Set<Group> getGroupsWithinShell(Structure structure, Atom atom, Set<ResidueNumber> excludeResidues, double distance, boolean includeWater) {
        distance *= distance;
        LinkedHashSet<Group> returnSet = new LinkedHashSet<Group>();
        for (Chain chain : structure.getChains()) {
            block1: for (Group chainGroup : chain.getAtomGroups()) {
                if (!includeWater && chainGroup.isWater()) continue;
                for (ResidueNumber rn : excludeResidues) {
                    if (!rn.equals(chainGroup.getResidueNumber())) continue;
                    continue block1;
                }
                for (Atom atomB : chainGroup.getAtoms()) {
                    double dist = Calc.getDistanceFast(atom, atomB);
                    if (!(dist <= distance)) continue;
                    returnSet.add(chainGroup);
                    continue block1;
                }
            }
        }
        return returnSet;
    }

    public static Set<Group> getGroupsWithinShell(Structure structure, Group group, double distance, boolean includeWater) {
        LinkedHashSet<Group> returnList = new LinkedHashSet<Group>();
        HashSet<ResidueNumber> excludeGroups = new HashSet<ResidueNumber>();
        excludeGroups.add(group.getResidueNumber());
        for (Atom atom : group.getAtoms()) {
            Set<Group> set = StructureTools.getGroupsWithinShell(structure, atom, excludeGroups, distance, includeWater);
            returnList.addAll(set);
        }
        return returnList;
    }

    public static Structure removeModels(Structure s) {
        if (s.nrModels() == 1) {
            return s;
        }
        StructureImpl n = new StructureImpl();
        n.setPDBCode(s.getPDBCode());
        n.setName(s.getName());
        n.setPDBHeader(s.getPDBHeader());
        n.setDBRefs(s.getDBRefs());
        n.setSites(s.getSites());
        n.setChains(s.getModel(0));
        return n;
    }

    public static List<Group> filterLigands(List<Group> allGroups) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group g : allGroups) {
            if (g.isPolymeric() || g.isWater()) continue;
            groups.add(g);
        }
        return groups;
    }

    public static Structure getStructure(String name) throws IOException, StructureException {
        return StructureTools.getStructure(name, null, null);
    }

    public static Structure getStructure(String name, PDBFileParser parser, AtomCache cache) throws IOException, StructureException {
        File f = new File(FileDownloadUtils.expandUserHome((String)name));
        if (f.exists()) {
            if (parser == null) {
                parser = new PDBFileParser();
            }
            FileInputStream inStream = new FileInputStream(f);
            return parser.parsePDBFile(inStream);
        }
        if (cache == null) {
            cache = new AtomCache();
        }
        return cache.getStructure(name);
    }

    @Deprecated
    public static boolean isProtein(Chain c) {
        return c.isProtein();
    }

    @Deprecated
    public static boolean isNucleicAcid(Chain c) {
        return c.isNucleicAcid();
    }

    @Deprecated
    public static GroupType getPredominantGroupType(Chain c) {
        return c.getPredominantGroupType();
    }

    @Deprecated
    public static boolean isChainWaterOnly(Chain c) {
        return c.isWaterOnly();
    }

    @Deprecated
    public static boolean isChainPureNonPolymer(Chain c) {
        return c.isPureNonPolymer();
    }

    public static void cleanUpAltLocs(Structure structure) {
        for (int i = 0; i < structure.nrModels(); ++i) {
            for (Chain chain : structure.getModel(i)) {
                for (Group group : chain.getAtomGroups()) {
                    for (Group altLocGroup : group.getAltLocs()) {
                        for (Atom groupAtom : group.getAtoms()) {
                            if (altLocGroup.hasAtom(groupAtom.getName()) || !altLocGroup.getPDBName().equals(group.getPDBName()) || StructureTools.hasDeuteratedEquiv(groupAtom, altLocGroup)) continue;
                            altLocGroup.addAtom(groupAtom);
                        }
                    }
                }
            }
        }
    }

    public static boolean hasNonDeuteratedEquiv(Atom atom, Group currentGroup) {
        return atom.getElement() == Element.D && currentGroup.hasAtom(StructureTools.replaceFirstChar(atom.getName(), 'D', 'H'));
    }

    public static boolean hasDeuteratedEquiv(Atom atom, Group currentGroup) {
        return atom.getElement() == Element.H && currentGroup.hasAtom(StructureTools.replaceFirstChar(atom.getName(), 'H', 'D'));
    }

    private static String replaceFirstChar(String name, char c, char d) {
        if (name.charAt(0) == c) {
            return name.replaceFirst(String.valueOf(c), String.valueOf(d));
        }
        return name;
    }

    static {
        String[] names;
        logger = LoggerFactory.getLogger(StructureTools.class);
        nucleotides30 = new HashMap<String, Character>();
        nucleotides30.put("DA", Character.valueOf('A'));
        nucleotides30.put("DC", Character.valueOf('C'));
        nucleotides30.put("DG", Character.valueOf('G'));
        nucleotides30.put("DT", Character.valueOf('T'));
        nucleotides30.put("DI", Character.valueOf('I'));
        nucleotides30.put("A", Character.valueOf('A'));
        nucleotides30.put("G", Character.valueOf('G'));
        nucleotides30.put(C_ATOM_NAME, Character.valueOf('C'));
        nucleotides30.put("U", Character.valueOf('U'));
        nucleotides30.put("I", Character.valueOf('I'));
        nucleotides30.put("TAF", Character.valueOf('X'));
        nucleotides30.put("TC1", Character.valueOf('X'));
        nucleotides30.put("TFE", Character.valueOf('X'));
        nucleotides30.put("TFO", Character.valueOf('X'));
        nucleotides30.put("TGP", Character.valueOf('X'));
        nucleotides30.put("THX", Character.valueOf('X'));
        nucleotides30.put("TLC", Character.valueOf('X'));
        nucleotides30.put("TLN", Character.valueOf('X'));
        nucleotides30.put("LCG", Character.valueOf('X'));
        nucleotides30.put("TP1", Character.valueOf('X'));
        nucleotides30.put("CP1", Character.valueOf('X'));
        nucleotides30.put("TPN", Character.valueOf('X'));
        nucleotides30.put("CPN", Character.valueOf('X'));
        nucleotides30.put("GPN", Character.valueOf('X'));
        nucleotides30.put("APN", Character.valueOf('X'));
        nucleotides30.put("TPC", Character.valueOf('X'));
        nucleotides23 = new HashMap<String, Character>();
        for (String n : names = new String[]{C_ATOM_NAME, "G", "A", "T", "U", "I", "+C", "+G", "+A", "+T", "+U", "+I"}) {
            nucleotides23.put(n, Character.valueOf(n.charAt(n.length() - 1)));
        }
        aminoAcids = new HashMap<String, Character>();
        aminoAcids.put("GLY", Character.valueOf('G'));
        aminoAcids.put("ALA", Character.valueOf('A'));
        aminoAcids.put("VAL", Character.valueOf('V'));
        aminoAcids.put("LEU", Character.valueOf('L'));
        aminoAcids.put("ILE", Character.valueOf('I'));
        aminoAcids.put("PHE", Character.valueOf('F'));
        aminoAcids.put("TYR", Character.valueOf('Y'));
        aminoAcids.put("TRP", Character.valueOf('W'));
        aminoAcids.put("PRO", Character.valueOf('P'));
        aminoAcids.put("HIS", Character.valueOf('H'));
        aminoAcids.put("LYS", Character.valueOf('K'));
        aminoAcids.put("ARG", Character.valueOf('R'));
        aminoAcids.put("SER", Character.valueOf('S'));
        aminoAcids.put("THR", Character.valueOf('T'));
        aminoAcids.put("GLU", Character.valueOf('E'));
        aminoAcids.put("GLN", Character.valueOf('Q'));
        aminoAcids.put("ASP", Character.valueOf('D'));
        aminoAcids.put("ASN", Character.valueOf('N'));
        aminoAcids.put("CYS", Character.valueOf('C'));
        aminoAcids.put("MET", Character.valueOf('M'));
        aminoAcids.put("MSE", Character.valueOf('M'));
        aminoAcids.put("CSE", Character.valueOf('U'));
        aminoAcids.put("SEC", Character.valueOf('U'));
        aminoAcids.put("PYH", Character.valueOf('O'));
        aminoAcids.put("PYL", Character.valueOf('O'));
        hBondDonorAcceptors = new HashSet<Element>();
        hBondDonorAcceptors.add(Element.N);
        hBondDonorAcceptors.add(Element.O);
        hBondDonorAcceptors.add(Element.S);
    }
}

