/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.geometry;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.MomentsOfInertia;
import org.biojava.nbio.structure.jama.EigenvalueDecomposition;
import org.biojava.nbio.structure.jama.Matrix;

public class UnitQuaternions {
    private UnitQuaternions() {
    }

    public static double orientationMetric(Point3d[] a, Point3d[] b) {
        Quat4d qa = UnitQuaternions.orientation(a);
        Quat4d qb = UnitQuaternions.orientation(b);
        return UnitQuaternions.orientationMetric(qa, qb);
    }

    public static double orientationMetric(Quat4d q1, Quat4d q2) {
        return Math.acos(Math.abs(UnitQuaternions.dotProduct(q1, q2)));
    }

    public static Quat4d orientation(Point3d[] points) {
        MomentsOfInertia moi = new MomentsOfInertia();
        for (Point3d p : points) {
            moi.addPoint(p, 1.0);
        }
        Quat4d quat = new Quat4d();
        quat.set(moi.getOrientationMatrix());
        return quat;
    }

    public static double angle(Quat4d q) {
        AxisAngle4d axis = new AxisAngle4d();
        axis.set(q);
        return axis.angle;
    }

    public static double orientationAngle(Point3d[] fixed, Point3d[] moved) {
        Quat4d q = UnitQuaternions.relativeOrientation(fixed, moved);
        return UnitQuaternions.angle(q);
    }

    public static double orientationAngle(Point3d[] fixed, Point3d[] moved, boolean centered) {
        if (!centered) {
            fixed = CalcPoint.clonePoint3dArray(fixed);
            moved = CalcPoint.clonePoint3dArray(moved);
            CalcPoint.center(fixed);
            CalcPoint.center(moved);
        }
        return UnitQuaternions.orientationAngle(fixed, moved);
    }

    public static Quat4d relativeOrientation(Point3d[] fixed, Point3d[] moved) {
        Matrix m = CalcPoint.formMatrix(moved, fixed);
        EigenvalueDecomposition eig = m.eig();
        double[][] v = eig.getV().getArray();
        Quat4d q = new Quat4d(v[1][3], v[2][3], v[3][3], v[0][3]);
        q.normalize();
        q.conjugate();
        return q;
    }

    public static double dotProduct(Quat4d q1, Quat4d q2) {
        return q1.x * q2.x + q1.y * q2.y + q1.z * q2.z + q1.w * q2.w;
    }
}

