/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.StructureException;

public class PdbId
implements Comparable<PdbId>,
Serializable {
    private static final long serialVersionUID = -7740865530486255113L;
    private static final String PREFIX_PDB_ = "PDB_";
    private static final String STRING_0000 = "0000";
    private static final String PDB_0000 = "PDB_0000";
    private static final boolean defaultShorteningBehaviour = true;
    public static final Pattern PATTERN_SHORT_PDBID = Pattern.compile("[1-9]\\p{Alnum}{3}");
    public static final Pattern PATTERN_EXTENDED_PDBID = Pattern.compile("(pdb|PDB)_\\p{Alnum}{8}");
    public static final Pattern PATTERN_SHORTABLE_EXTENDED_PDBID = Pattern.compile("(pdb|PDB)_0000[1-9]\\p{Alnum}{3}");
    private String idCode;

    public PdbId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID can not be null");
        }
        this.idCode = PdbId.toInternalFormat(id);
    }

    public static boolean isValidShortPdbId(String id) {
        return PATTERN_SHORT_PDBID.matcher(id).matches();
    }

    public static boolean isValidExtendedPdbId(String id) {
        return PATTERN_EXTENDED_PDBID.matcher(id).matches();
    }

    public static boolean isShortCompatible(String extendedId) {
        return PATTERN_SHORTABLE_EXTENDED_PDBID.matcher(extendedId).matches();
    }

    public int hashCode() {
        return this.idCode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.idCode.equals(((PdbId)obj).idCode);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new PdbId(this.getId());
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.getId(true);
    }

    public String getId(boolean prefereShort) {
        if (prefereShort && PdbId.isInternalShortCompatible(this.idCode)) {
            return PdbId.internalToShortNoCheck(this.idCode);
        }
        return PREFIX_PDB_ + this.idCode;
    }

    public String getShortId() throws StructureException {
        if (PdbId.isInternalShortCompatible(this.idCode)) {
            return PdbId.internalToShortNoCheck(this.idCode);
        }
        throw new StructureException("ID (" + this.getId() + ") is not short format compatible");
    }

    public static String toExtendedId(String shortId) throws StructureException {
        if (PdbId.isValidShortPdbId(shortId)) {
            return PDB_0000 + shortId.toUpperCase();
        }
        if (PdbId.isValidExtendedPdbId(shortId)) {
            return shortId.toUpperCase();
        }
        throw new StructureException("Unknown format [" + shortId + "]");
    }

    public static String toShortId(String extendedId) throws StructureException {
        if (PdbId.isShortCompatible(extendedId)) {
            return extendedId.substring(8).toUpperCase();
        }
        if (PdbId.isValidShortPdbId(extendedId)) {
            return extendedId.toUpperCase();
        }
        throw new StructureException("Conversion not possible of ID [" + extendedId + "]");
    }

    private static boolean isInternalShortCompatible(String intId) {
        return intId.substring(0, 4).equals(STRING_0000);
    }

    private static String toInternalFormat(String id) {
        if (PdbId.isValidShortPdbId(id)) {
            return STRING_0000 + id.toUpperCase();
        }
        if (PdbId.isValidExtendedPdbId(id)) {
            return id.substring(4).toUpperCase();
        }
        throw new IllegalArgumentException("Unknown format [" + id + "]");
    }

    private static String internalToShortNoCheck(String extendedId) {
        return extendedId.substring(4).toUpperCase();
    }

    @Override
    public int compareTo(PdbId o) {
        return this.idCode.compareTo(o.idCode);
    }
}

