/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.contact.Grid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstructureIdentifier
implements StructureIdentifier {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SubstructureIdentifier.class);
    private final PdbId pdbId;
    private final List<ResidueRange> ranges;

    public SubstructureIdentifier(String id) {
        String[] idRange = id.split("\\.");
        if (1 > idRange.length || idRange.length > 2) {
            throw new IllegalArgumentException(String.format("Malformed %s: %s", this.getClass().getSimpleName(), id));
        }
        PdbId tempId = null;
        try {
            tempId = new PdbId(idRange[0]);
        }
        catch (IllegalArgumentException e) {
            logger.warn(String.format("Unrecognized PDB code %s", idRange[0]));
        }
        this.pdbId = tempId;
        if (idRange.length == 2) {
            String rangeStr = idRange[1].trim();
            this.ranges = ResidueRange.parseMultiple(rangeStr);
        } else {
            this.ranges = new LinkedList<ResidueRange>();
        }
    }

    public SubstructureIdentifier(String pdbId, List<ResidueRange> ranges) {
        this(new PdbId(pdbId), ranges);
    }

    public SubstructureIdentifier(PdbId pdbId, List<ResidueRange> ranges) {
        if (ranges == null) {
            throw new NullPointerException("Null ranges list");
        }
        this.pdbId = pdbId;
        this.ranges = ranges;
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public String getIdentifier() {
        String pdbId;
        String string = pdbId = this.pdbId == null ? "" : this.pdbId.getId();
        if (this.ranges.isEmpty()) {
            return pdbId;
        }
        return pdbId + "." + ResidueRange.toString(this.ranges);
    }

    public PdbId getPdbId() {
        return this.pdbId;
    }

    public List<ResidueRange> getResidueRanges() {
        return this.ranges;
    }

    @Override
    public SubstructureIdentifier toCanonical() {
        return this;
    }

    @Override
    public Structure reduce(Structure s) throws StructureException {
        if (s == null) {
            throw new StructureException("NullPointerException Possibly due to malformed PIBId format.");
        }
        StructureImpl newS = new StructureImpl();
        newS.setPdbId(s.getPdbId());
        newS.setPDBHeader(s.getPDBHeader());
        newS.setName(this.toString());
        newS.setDBRefs(s.getDBRefs());
        newS.setBiologicalAssembly(s.isBiologicalAssembly());
        newS.getPDBHeader().setDescription("sub-range " + String.valueOf(this.ranges) + " of " + String.valueOf(newS.getPdbId()) + " " + s.getPDBHeader().getDescription());
        newS.setEntityInfos(new ArrayList<EntityInfo>());
        newS.setSSBonds(s.getSSBonds());
        newS.setSites(s.getSites());
        newS.setStructureIdentifier(this);
        for (int modelNr = 0; modelNr < s.nrModels(); ++modelNr) {
            newS.addModel(new ArrayList<Chain>());
            if (this.getResidueRanges().isEmpty()) {
                newS.setEntityInfos(s.getEntityInfos());
                newS.setSSBonds(s.getSSBonds());
                newS.setSites(s.getSites());
                newS.setModel(modelNr, s.getModel(modelNr));
                continue;
            }
            for (ResidueRange range : this.getResidueRanges()) {
                Chain polyChain;
                String chainName = range.getChainName();
                ResidueNumber pdbresnum1 = range.getStart();
                ResidueNumber pdbresnum2 = range.getEnd();
                if ("_".equals(chainName)) {
                    polyChain = s.getPolyChains(modelNr).get(0);
                    chainName = polyChain.getName();
                    if (pdbresnum1 != null) {
                        pdbresnum1.setChainName(chainName);
                    }
                    if (pdbresnum2 != null) {
                        pdbresnum2.setChainName(chainName);
                    }
                    if (s.getPolyChains().size() != 1) {
                        logger.warn("Multiple possible chains match '_'. Using chain {}", (Object)chainName);
                    }
                } else {
                    polyChain = s.getPolyChainByPDB(chainName, modelNr);
                    if (polyChain == null) {
                        try {
                            int chainNum = Integer.parseInt(chainName);
                            polyChain = s.getChainByIndex(modelNr, chainNum);
                            chainName = polyChain.getName();
                            if (pdbresnum1 != null) {
                                pdbresnum1.setChainName(chainName);
                            }
                            if (pdbresnum2 != null) {
                                pdbresnum2.setChainName(chainName);
                            }
                            logger.warn("No chain found for {}. Interpretting it as an index, using chain {} instead", (Object)chainName, (Object)polyChain.getId());
                        }
                        catch (NumberFormatException e3) {
                            throw new StructureException(String.format("Unrecognized chain %s in %s", chainName, this.getIdentifier()));
                        }
                    }
                }
                if (pdbresnum1 == null && pdbresnum2 == null) {
                    StructureTools.addGroupsToStructure(newS, polyChain.getAtomGroups(), modelNr, false);
                    for (Chain chain : s.getNonPolyChainsByPDB(chainName, modelNr)) {
                        StructureTools.addGroupsToStructure(newS, chain.getAtomGroups(), modelNr, false);
                    }
                    Chain waters = s.getWaterChainByPDB(chainName, modelNr);
                    if (waters == null) continue;
                    StructureTools.addGroupsToStructure(newS, waters.getAtomGroups(), modelNr, false);
                    continue;
                }
                List<Group> polygroups = Arrays.asList(polyChain.getGroupsByPDB(pdbresnum1, pdbresnum2));
                StructureTools.addGroupsToStructure(newS, polygroups, modelNr, false);
                SubstructureIdentifier.copyLigandsByProximity(s, newS, 5.0, modelNr, modelNr);
            }
        }
        return newS;
    }

    @Override
    public Structure loadStructure(AtomCache cache) throws IOException, StructureException {
        PdbId pdb = this.getPdbId();
        if (pdb == null) {
            return null;
        }
        return cache.getStructureForPdbId(pdb);
    }

    protected static void copyLigandsByProximity(Structure full, Structure reduced) {
        assert (full.nrModels() >= reduced.nrModels());
        for (int model = 0; model < reduced.nrModels(); ++model) {
            SubstructureIdentifier.copyLigandsByProximity(full, reduced, 5.0, model, model);
        }
    }

    protected static void copyLigandsByProximity(Structure full, Structure reduced, double cutoff, int fromModel, int toModel) {
        Grid grid = new Grid(cutoff);
        Atom[] nonwaters = StructureTools.getAllNonHAtomArray(reduced, true, toModel);
        if (nonwaters.length < 1) {
            return;
        }
        grid.addAtoms(nonwaters);
        ((Stream)full.getNonPolyChains(fromModel).stream().flatMap(chain -> chain.getAtomGroups().stream()).filter(g -> !g.isWater()).filter(g -> !g.isPolymeric()).filter(g -> grid.hasAnyContact(Calc.atomsToPoints(g.getAtoms()))).sequential()).reduce(null, (guess, g) -> {
            boolean wasAdded;
            try {
                wasAdded = reduced.findGroup(g.getChainId(), g.getResidueNumber().toString(), toModel) != null;
            }
            catch (StructureException e) {
                wasAdded = false;
            }
            if (!wasAdded) {
                logger.info("Adding ligand group {} {} by proximity", (Object)g.getPDBName(), (Object)g.getResidueNumber().toPDB());
                return StructureTools.addGroupToStructure(reduced, g, toModel, guess, false);
            }
            return guess;
        }, (oldGuess, newGuess) -> newGuess);
    }
}

