/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.multiple.AbstractScoresCache;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;

public class MultipleAlignmentImpl
extends AbstractScoresCache
implements Serializable,
MultipleAlignment,
Cloneable {
    private static final long serialVersionUID = 3432043794125805139L;
    private MultipleAlignmentEnsemble parent;
    private List<BlockSet> blockSets;
    private int length;
    private int coreLength;
    private List<Integer> alignResCounts;
    private List<Double> coverages;

    public MultipleAlignmentImpl() {
        this(new MultipleAlignmentEnsembleImpl());
    }

    public MultipleAlignmentImpl(MultipleAlignmentEnsemble ensemble) {
        this.parent = ensemble;
        if (this.parent != null) {
            this.parent.getMultipleAlignments().add(this);
        }
        this.blockSets = null;
        this.length = -1;
        this.coreLength = -1;
        this.alignResCounts = null;
        this.coverages = null;
    }

    public MultipleAlignmentImpl(MultipleAlignmentImpl ma) {
        super(ma);
        this.parent = ma.parent;
        this.length = ma.length;
        this.coreLength = ma.coreLength;
        this.blockSets = null;
        if (ma.blockSets != null) {
            this.blockSets = new ArrayList<BlockSet>();
            for (BlockSet bs : ma.blockSets) {
                BlockSet newBS = bs.clone();
                newBS.setMultipleAlignment(this);
                this.blockSets.add(newBS);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.length = -1;
        this.coreLength = -1;
        this.alignResCounts = null;
        for (BlockSet a : this.getBlockSets()) {
            a.clear();
        }
    }

    @Override
    public MultipleAlignmentImpl clone() {
        return new MultipleAlignmentImpl(this);
    }

    @Override
    public String toString() {
        ArrayList<String> ids = new ArrayList<String>(this.parent.getStructureIdentifiers().size());
        for (StructureIdentifier i : this.parent.getStructureIdentifiers()) {
            ids.add(i.getIdentifier());
        }
        String resume = "Structures:" + String.valueOf(ids) + " \nAlgorithm:" + this.parent.getAlgorithmName() + "_" + this.parent.getVersion() + " \nBlockSets: " + this.getBlockSets().size() + " \nBlocks: " + this.getBlocks().size() + " \nLength: " + this.length() + " \nCore Length: " + this.getCoreLength();
        for (String score : this.getScores()) {
            resume = resume + " \n" + score + ": ";
            resume = resume + String.format(Locale.US, "%.2f", this.getScore(score));
        }
        return resume;
    }

    @Override
    public List<BlockSet> getBlockSets() {
        if (this.blockSets == null) {
            this.blockSets = new ArrayList<BlockSet>();
        }
        return this.blockSets;
    }

    @Override
    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (BlockSet bs : this.getBlockSets()) {
            blocks.addAll(bs.getBlocks());
        }
        return blocks;
    }

    @Override
    public void setBlockSets(List<BlockSet> blockSets) {
        this.blockSets = blockSets;
    }

    @Override
    public BlockSet getBlockSet(int index) {
        return this.blockSets.get(index);
    }

    @Override
    public Block getBlock(int index) {
        List<Block> blocks = this.getBlocks();
        return blocks.get(index);
    }

    @Override
    public List<Atom[]> getAtomArrays() {
        return this.parent.getAtomArrays();
    }

    @Override
    public StructureIdentifier getStructureIdentifier(int index) {
        return this.parent.getStructureIdentifiers().get(index);
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public int length() {
        if (this.length < 0) {
            this.updateLength();
        }
        return this.length;
    }

    @Override
    public int getCoreLength() {
        if (this.coreLength < 0) {
            this.updateCoreLength();
        }
        return this.coreLength;
    }

    protected void updateLength() {
        if (this.getBlockSets().size() == 0) {
            throw new IndexOutOfBoundsException("Empty MultipleAlignment: blockSets size == 0.");
        }
        this.length = 0;
        for (BlockSet blockSet : this.blockSets) {
            this.length += blockSet.length();
        }
    }

    protected void updateCoreLength() {
        if (this.getBlockSets().size() == 0) {
            throw new IndexOutOfBoundsException("Empty MultipleAlignment: blockSets size == 0.");
        }
        this.coreLength = 0;
        for (BlockSet blockSet : this.blockSets) {
            this.coreLength += blockSet.getCoreLength();
        }
    }

    protected void updateCache() {
        this.updateCoreLength();
        this.updateLength();
    }

    @Override
    public MultipleAlignmentEnsemble getEnsemble() {
        return this.parent;
    }

    @Override
    public void setEnsemble(MultipleAlignmentEnsemble parent) {
        this.parent = parent;
    }

    @Override
    public List<Integer> getAlignResCounts() {
        if (this.alignResCounts != null) {
            return this.alignResCounts;
        }
        this.alignResCounts = new ArrayList<Integer>(this.size());
        for (int s = 0; s < this.size(); ++s) {
            this.alignResCounts.add(0);
        }
        for (BlockSet bs : this.blockSets) {
            List<Integer> bscounts = bs.getAlignResCounts();
            for (int s = 0; s < this.size(); ++s) {
                this.alignResCounts.set(s, this.alignResCounts.get(s) + bscounts.get(s));
            }
        }
        return this.alignResCounts;
    }

    @Override
    public List<Double> getCoverages() {
        if (this.coverages != null) {
            return this.coverages;
        }
        List<Integer> counts = this.getAlignResCounts();
        this.coverages = new ArrayList<Double>(this.size());
        for (int s = 0; s < this.size(); ++s) {
            this.coverages.add((double)counts.get(s).intValue() / (double)this.getAtomArrays().get(s).length);
        }
        return this.coverages;
    }
}

