/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cluster;

import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.StructureTools;

public class Subunit {
    private String name;
    private Structure structure;
    private StructureIdentifier identifier;
    private Atom[] reprAtoms;
    private ProteinSequence sequence = null;

    public Subunit(Atom[] reprAtoms, String name, StructureIdentifier identifier, Structure structure) {
        if (reprAtoms == null) {
            throw new IllegalArgumentException("Representative Atom Array of the Subunit is null");
        }
        if (reprAtoms.length == 0) {
            throw new IllegalArgumentException("Representative Atom Array of the Subunit has 0 length");
        }
        this.reprAtoms = reprAtoms;
        this.name = name;
        this.identifier = identifier;
        this.structure = structure;
    }

    public Atom[] getRepresentativeAtoms() {
        return this.reprAtoms;
    }

    public int size() {
        return this.reprAtoms.length;
    }

    public String getProteinSequenceString() {
        if (this.sequence != null) {
            return this.sequence.toString();
        }
        StringBuilder builder = new StringBuilder();
        for (Atom a : this.reprAtoms) {
            builder.append(StructureTools.get1LetterCode(a.getGroup().getPDBName()));
        }
        return builder.toString();
    }

    public ProteinSequence getProteinSequence() throws CompoundNotFoundException {
        if (this.sequence == null) {
            this.sequence = new ProteinSequence(this.getProteinSequenceString());
        }
        return this.sequence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public StructureIdentifier getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return "Subunit [Name: " + this.name + ", Identifier: " + String.valueOf(this.identifier) + ", Size:" + this.size() + ", Sequence:" + String.valueOf(this.sequence) + "]";
    }
}

