/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.contact.AtomContact;
import org.biojava.nbio.structure.contact.AtomContactSet;
import org.biojava.nbio.structure.contact.BoundingBox;
import org.biojava.nbio.structure.contact.Contact;
import org.biojava.nbio.structure.contact.GridCell;
import org.biojava.nbio.structure.contact.Pair;

public class Grid {
    private static final int SCALE = 100;
    private GridCell[][][] cells;
    private double cutoff;
    private int cellSize;
    private Point3d[] iAtoms;
    private Point3d[] jAtoms;
    private Atom[] iAtomObjects;
    private Atom[] jAtomObjects;
    private int[] bounds;
    private BoundingBox ibounds;
    private BoundingBox jbounds;
    private boolean noOverlap;

    public Grid(double cutoff) {
        this.cutoff = cutoff;
        this.cellSize = (int)Math.floor(cutoff * 100.0);
        this.noOverlap = false;
    }

    private int getFloor(double number) {
        return this.cellSize * (int)Math.floor(number * 100.0 / (double)this.cellSize);
    }

    private int xintgrid2xgridindex(int xgridDim) {
        return (xgridDim - this.bounds[0]) / this.cellSize;
    }

    private int yintgrid2ygridindex(int ygridDim) {
        return (ygridDim - this.bounds[1]) / this.cellSize;
    }

    private int zintgrid2zgridindex(int zgridDim) {
        return (zgridDim - this.bounds[2]) / this.cellSize;
    }

    public void addAtoms(Atom[] iAtoms, Atom[] jAtoms) {
        this.addAtoms(iAtoms, null, jAtoms, null);
    }

    public void addAtoms(Atom[] iAtoms, BoundingBox icoordbounds, Atom[] jAtoms, BoundingBox jcoordbounds) {
        this.iAtoms = Calc.atomsToPoints(iAtoms);
        this.iAtomObjects = iAtoms;
        this.ibounds = icoordbounds != null ? icoordbounds : new BoundingBox(this.iAtoms);
        this.jAtoms = Calc.atomsToPoints(jAtoms);
        this.jAtomObjects = jAtoms;
        this.jbounds = jAtoms == iAtoms ? this.ibounds : (jcoordbounds != null ? jcoordbounds : new BoundingBox(this.jAtoms));
        this.fillGrid();
    }

    public void addAtoms(Atom[] atoms) {
        this.addAtoms(atoms, (BoundingBox)null);
    }

    public void addAtoms(Atom[] atoms, BoundingBox bounds) {
        this.iAtoms = Calc.atomsToPoints(atoms);
        this.iAtomObjects = atoms;
        this.ibounds = bounds != null ? bounds : new BoundingBox(this.iAtoms);
        this.jAtoms = null;
        this.jAtomObjects = null;
        this.jbounds = null;
        this.fillGrid();
    }

    public void addCoords(Point3d[] iAtoms, Point3d[] jAtoms) {
        this.addCoords(iAtoms, null, jAtoms, null);
    }

    public void addCoords(Point3d[] iAtoms, BoundingBox icoordbounds, Point3d[] jAtoms, BoundingBox jcoordbounds) {
        this.iAtoms = iAtoms;
        this.iAtomObjects = null;
        this.ibounds = icoordbounds != null ? icoordbounds : new BoundingBox(this.iAtoms);
        this.jAtoms = jAtoms;
        this.jAtomObjects = null;
        this.jbounds = jAtoms == iAtoms ? this.ibounds : (jcoordbounds != null ? jcoordbounds : new BoundingBox(this.jAtoms));
        this.fillGrid();
    }

    public void addCoords(Point3d[] atoms) {
        this.addCoords(atoms, (BoundingBox)null);
    }

    public void addCoords(Point3d[] atoms, BoundingBox bounds) {
        this.iAtoms = atoms;
        this.iAtomObjects = null;
        this.ibounds = bounds != null ? bounds : new BoundingBox(this.iAtoms);
        this.jAtoms = null;
        this.jAtomObjects = null;
        this.jbounds = null;
        this.fillGrid();
    }

    private void fillGrid() {
        if (this.jbounds != null && !this.ibounds.overlaps(this.jbounds, this.cutoff)) {
            this.noOverlap = true;
            return;
        }
        this.findFullGridIntBounds();
        this.cells = new GridCell[1 + (this.bounds[3] - this.bounds[0]) / this.cellSize][1 + (this.bounds[4] - this.bounds[1]) / this.cellSize][1 + (this.bounds[5] - this.bounds[2]) / this.cellSize];
        int i = 0;
        for (Point3d atom : this.iAtoms) {
            int zind;
            int yind;
            int xind = this.xintgrid2xgridindex(this.getFloor(atom.x));
            if (this.cells[xind][yind = this.yintgrid2ygridindex(this.getFloor(atom.y))][zind = this.zintgrid2zgridindex(this.getFloor(atom.z))] == null) {
                this.cells[xind][yind][zind] = new GridCell(this);
            }
            this.cells[xind][yind][zind].addIindex(i);
            ++i;
        }
        if (this.jAtoms == null) {
            return;
        }
        int j = 0;
        for (Point3d atom : this.jAtoms) {
            int zind;
            int yind;
            int xind = this.xintgrid2xgridindex(this.getFloor(atom.x));
            if (this.cells[xind][yind = this.yintgrid2ygridindex(this.getFloor(atom.y))][zind = this.zintgrid2zgridindex(this.getFloor(atom.z))] == null) {
                this.cells[xind][yind][zind] = new GridCell(this);
            }
            this.cells[xind][yind][zind].addJindex(j);
            ++j;
        }
    }

    private void findFullGridIntBounds() {
        int[] iIntBounds = this.getIntBounds(this.ibounds);
        this.bounds = new int[6];
        if (this.jbounds == null) {
            this.bounds = iIntBounds;
        } else {
            int[] jIntBounds = this.getIntBounds(this.jbounds);
            this.bounds[0] = Math.min(iIntBounds[0], jIntBounds[0]);
            this.bounds[1] = Math.min(iIntBounds[1], jIntBounds[1]);
            this.bounds[2] = Math.min(iIntBounds[2], jIntBounds[2]);
            this.bounds[3] = Math.max(iIntBounds[3], jIntBounds[3]);
            this.bounds[4] = Math.max(iIntBounds[4], jIntBounds[4]);
            this.bounds[5] = Math.max(iIntBounds[5], jIntBounds[5]);
        }
    }

    private int[] getIntBounds(BoundingBox coordbounds) {
        int[] bs = new int[]{this.getFloor(coordbounds.xmin), this.getFloor(coordbounds.ymin), this.getFloor(coordbounds.zmin), this.getFloor(coordbounds.xmax), this.getFloor(coordbounds.ymax), this.getFloor(coordbounds.zmax)};
        return bs;
    }

    public AtomContactSet getAtomContacts() {
        AtomContactSet contacts = new AtomContactSet(this.cutoff);
        List<Contact> list = this.getIndicesContacts();
        if (this.jAtomObjects == null) {
            for (Contact cont : list) {
                contacts.add(new AtomContact(new Pair<Atom>(this.iAtomObjects[cont.getI()], this.iAtomObjects[cont.getJ()]), cont.getDistance()));
            }
        } else {
            for (Contact cont : list) {
                contacts.add(new AtomContact(new Pair<Atom>(this.iAtomObjects[cont.getI()], this.jAtomObjects[cont.getJ()]), cont.getDistance()));
            }
        }
        return contacts;
    }

    @Deprecated
    public AtomContactSet getContacts() {
        return this.getAtomContacts();
    }

    public List<Contact> getIndicesContacts() {
        ArrayList<Contact> list = new ArrayList<Contact>();
        if (this.noOverlap) {
            return list;
        }
        for (int xind = 0; xind < this.cells.length; ++xind) {
            for (int yind = 0; yind < this.cells[xind].length; ++yind) {
                for (int zind = 0; zind < this.cells[xind][yind].length; ++zind) {
                    GridCell thisCell = this.cells[xind][yind][zind];
                    if (thisCell == null) continue;
                    list.addAll(thisCell.getContactsWithinCell());
                    for (int x = xind - 1; x <= xind + 1; ++x) {
                        for (int y = yind - 1; y <= yind + 1; ++y) {
                            for (int z = zind - 1; z <= zind + 1; ++z) {
                                if (x == xind && y == yind && z == zind || x < 0 || x >= this.cells.length || y < 0 || y >= this.cells[x].length || z < 0 || z >= this.cells[x][y].length || this.cells[x][y][z] == null) continue;
                                list.addAll(thisCell.getContactsToOtherCell(this.cells[x][y][z]));
                            }
                        }
                    }
                }
            }
        }
        return list;
    }

    public boolean hasAnyContact(Point3d[] atoms) {
        return this.hasAnyContact(Arrays.asList(atoms));
    }

    public boolean hasAnyContact(Collection<Point3d> atoms) {
        for (Point3d atom : atoms) {
            int xind = this.xintgrid2xgridindex(this.getFloor(atom.x));
            int yind = this.yintgrid2ygridindex(this.getFloor(atom.y));
            int zind = this.zintgrid2zgridindex(this.getFloor(atom.z));
            for (int x = xind - 1; x <= xind + 1; ++x) {
                if (x < 0 || this.cells.length <= x) continue;
                for (int y = yind - 1; y <= yind + 1; ++y) {
                    if (y < 0 || this.cells[x].length <= y) continue;
                    for (int z = zind - 1; z <= zind + 1; ++z) {
                        GridCell cell;
                        if (z < 0 || this.cells[x][y].length <= z || (cell = this.cells[x][y][z]) == null || !cell.hasContactToAtom(this.iAtoms, this.jAtoms, atom, this.cutoff)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public boolean isNoOverlap() {
        return this.noOverlap;
    }

    protected Point3d[] getIAtoms() {
        return this.iAtoms;
    }

    protected Point3d[] getJAtoms() {
        return this.jAtoms;
    }
}

