/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.domain.pdp;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.domain.pdp.CutDomain;
import org.biojava.nbio.structure.domain.pdp.Domain;
import org.biojava.nbio.structure.domain.pdp.PDPDistanceMatrix;
import org.biojava.nbio.structure.domain.pdp.Segment;

public class ClusterDomains {
    private static boolean verbose = CutDomain.verbose;
    private static int ndom;

    public static List<Domain> cluster(List<Domain> domains, PDPDistanceMatrix pdpDistMatrix) {
        ndom = domains.size();
        int Si = -1;
        int Sj = -1;
        int Sis = -1;
        int Sjs = -1;
        int Sim = -1;
        int Sjm = -1;
        long total_max_contacts = 0L;
        double maximum_values = 0.19f;
        double maximum_valuem = 0.21f;
        double maximum_value = 0.29f;
        if (ndom < 2) {
            return domains;
        }
        if (verbose) {
            ClusterDomains.listdomains(domains);
        }
        do {
            for (int i = 0; i < ndom - 1; ++i) {
                for (int j = i + 1; j < ndom; ++j) {
                    Domain d1 = domains.get(i);
                    Domain d2 = domains.get(j);
                    long total_contacts = ClusterDomains.getTotalContacts(domains, pdpDistMatrix, d1, d2);
                    System.out.println(" pos: d1:" + i + " vs d2:" + j + " d1:" + d1.getSegmentAtPos(0).getFrom() + "-" + d1.getSegmentAtPos(0).getTo() + " " + d2.getSegmentAtPos(0).getFrom() + "-" + d2.getSegmentAtPos(0).getTo() + " " + total_contacts);
                    int size1dom1 = domains.get((int)i).size;
                    int size2dom2 = domains.get((int)j).size;
                    double minDomSize = Math.min(size1dom1, size2dom2);
                    double maxDomSize = Math.max(size1dom1, size2dom2);
                    if (minDomSize > 150.0 && maxDomSize > 1.5 * minDomSize) {
                        maxDomSize = 1.5 * minDomSize;
                    } else if (maxDomSize > 2.0 * minDomSize) {
                        maxDomSize = 2.0 * minDomSize;
                    }
                    long size1 = Double.valueOf(Math.min(350.0, minDomSize)).longValue();
                    long size2 = Double.valueOf(Math.min(350.0, maxDomSize)).longValue();
                    minDomSize = Math.min(Math.pow(minDomSize, 0.5333333333333333) + 1.0, Math.pow(minDomSize, 0.4666666666666666) + Math.pow(40.0, 0.5333333333333333) + 1.0);
                    maxDomSize = Math.min(Math.pow(maxDomSize, 0.5333333333333333) + 1.0, Math.pow(maxDomSize, 0.4666666666666666) + Math.pow(40.0, 0.5333333333333333) + 1.0);
                    total_max_contacts = Double.valueOf(minDomSize * maxDomSize * 10.0).longValue();
                    if (size1 > 130L) {
                        total_max_contacts = Double.valueOf(minDomSize * maxDomSize * 9.0).longValue();
                    }
                    double S_value = (double)total_contacts / (double)total_max_contacts;
                    if (verbose) {
                        System.out.printf(" size1=%d size2=%d minDomSize=%5.2f maxDomSize=%5.2f total_contacts = %d %n", size1, size2, minDomSize, maxDomSize, total_contacts);
                        System.out.printf(" total_contacts = %d total_max_contacts = %d%n", total_contacts, total_max_contacts);
                        System.out.printf(" maximum_value = %f S_value = %f%n%n", maximum_value, S_value);
                    }
                    if (S_value > maximum_value) {
                        maximum_value = S_value;
                        Si = i;
                        Sj = j;
                    }
                    if (S_value > maximum_valuem && size1 < 70L) {
                        maximum_valuem = S_value;
                        Sim = i;
                        Sjm = j;
                    }
                    if (S_value > maximum_values && size1 < 52L) {
                        maximum_values = S_value;
                        Sis = i;
                        Sjs = j;
                    }
                    total_contacts = 0L;
                    total_max_contacts = 0L;
                }
            }
            if (verbose) {
                System.out.println("Check for combining: " + maximum_value + " 1 :0.29");
                System.out.println("                     " + maximum_valuem + " 1M:0.21");
                System.out.println("                     " + maximum_values + " 1S:0.19");
            }
            if (maximum_value > (double)0.29f) {
                if (verbose) {
                    System.out.println(" Criteria 1 matched");
                }
                if (verbose) {
                    System.out.printf(" maximum_value = %f%n", maximum_value);
                }
                if (verbose) {
                    System.out.printf(" Si = %d Sj = %d %n", Si, Sj);
                }
                domains = ClusterDomains.combine(domains, Si, Sj, maximum_value);
                maximum_value = 0.18999999165534973;
                maximum_values = 0.0899999976158142;
                maximum_valuem = 0.10999999344348907;
                if (verbose) {
                    System.out.println(String.format(" Listing the domains after combining...", new Object[0]));
                }
                if (!verbose) continue;
                ClusterDomains.listdomains(domains);
                continue;
            }
            if (maximum_valuem > (double)0.21f) {
                if (verbose) {
                    System.out.println(" Criteria 2 matched");
                }
                if (verbose) {
                    System.out.printf(" maximum_values = %f%n", maximum_valuem);
                }
                if (verbose) {
                    System.out.printf(" Sim = %d Sjm = %d%n", Sim, Sjm);
                }
                domains = ClusterDomains.combine(domains, Sim, Sjm, maximum_valuem);
                maximum_value = 0.18999999165534973;
                maximum_values = 0.0899999976158142;
                maximum_valuem = 0.10999999344348907;
                if (verbose) {
                    System.out.println(String.format(" Listing the domains after combining...", new Object[0]));
                }
                if (!verbose) continue;
                ClusterDomains.listdomains(domains);
                continue;
            }
            if (maximum_values > (double)0.19f) {
                if (verbose) {
                    System.out.println(" Criteria 3 matched");
                }
                if (verbose) {
                    System.out.printf(" maximum_values = %f%n", maximum_values);
                }
                if (verbose) {
                    System.out.printf(" Sis = %d Sjs = %d%n", Sis, Sjs);
                }
                domains = ClusterDomains.combine(domains, Sis, Sjs, maximum_values);
                maximum_value = 0.18999999165534973;
                maximum_values = 0.0899999976158142;
                maximum_valuem = 0.10999999344348907;
                if (verbose) {
                    System.out.println(" Listing the domains after combining...");
                }
                if (!verbose) continue;
                ClusterDomains.listdomains(domains);
                continue;
            }
            if (verbose) {
                System.out.printf(" Maximum value is less than cut off value. (max:%f)%n", maximum_value);
            }
            maximum_value = -1.0;
            maximum_values = -1.0;
            maximum_valuem = -1.0;
        } while (maximum_value > 0.0 || maximum_values > 0.0 || maximum_valuem > 0.0);
        if (verbose) {
            System.out.println(String.format(" The domains are:", new Object[0]));
        }
        if (verbose) {
            ClusterDomains.listdomains(domains);
        }
        return domains;
    }

    private static long getTotalContacts(List<Domain> domains, PDPDistanceMatrix pdpDistMatrix, Domain i, Domain j) {
        long total_contacts = 0L;
        for (int k = 0; k < i.nseg; ++k) {
            for (int l = 0; l < j.nseg; ++l) {
                long contacts = ClusterDomains.calc_S(j.getSegmentAtPos(l).getFrom(), j.getSegmentAtPos(l).getTo(), i.getSegmentAtPos(k).getFrom(), i.getSegmentAtPos(k).getTo(), pdpDistMatrix);
                total_contacts += contacts;
            }
        }
        return total_contacts;
    }

    private static List<Domain> combine(List<Domain> domains, int Si, int Sj, double maximum_value) {
        int i;
        if (verbose) {
            System.out.println("  +++  combining domains " + Si + " " + Sj);
        }
        ArrayList<Domain> newdoms = new ArrayList<Domain>();
        for (i = 0; i < domains.get((int)Sj).nseg; ++i) {
            domains.get(Si).getSegmentAtPos(domains.get((int)Si).nseg).setFrom(domains.get(Sj).getSegmentAtPos(i).getFrom());
            domains.get(Si).getSegmentAtPos(domains.get((int)Si).nseg).setTo(domains.get(Sj).getSegmentAtPos(i).getTo());
            ++domains.get((int)Si).nseg;
        }
        domains.get((int)Si).size += domains.get((int)Sj).size;
        for (i = 0; i < domains.get((int)(ClusterDomains.ndom - 1)).nseg; ++i) {
            domains.get(Sj).getSegmentAtPos(i).setFrom(domains.get(ndom - 1).getSegmentAtPos(i).getFrom());
            domains.get(Sj).getSegmentAtPos(i).setTo(domains.get(ndom - 1).getSegmentAtPos(i).getTo());
        }
        for (i = 0; i < domains.size(); ++i) {
            if (i == Sj) continue;
            newdoms.add(domains.get(i));
        }
        domains.get((int)Sj).size = domains.get((int)(ClusterDomains.ndom - 1)).size;
        domains.get((int)Sj).nseg = domains.get((int)(ClusterDomains.ndom - 1)).nseg;
        --ndom;
        return newdoms;
    }

    private static long calc_S(int a1, int b1, int a2, int b2, PDPDistanceMatrix pdpDistMatrix) {
        long contacts = 0L;
        int[][] dist = pdpDistMatrix.getDist();
        for (int i = a1; i <= b1; ++i) {
            for (int j = a2; j <= b2; ++j) {
                contacts += (long)dist[i][j];
            }
        }
        return contacts;
    }

    private static final void listdomains(List<Domain> domains) {
        int i = -1;
        for (Domain dom : domains) {
            System.out.println("DOMAIN:" + ++i + " size:" + dom.size + " " + dom.score);
            List<Segment> segments = dom.getSegments();
            for (Segment s : segments) {
                System.out.println("   Segment: " + String.valueOf(s));
            }
        }
    }
}

