/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.geometry;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.SuperPositionAbstract;
import org.biojava.nbio.structure.geometry.UnitQuaternions;

public final class SuperPositionQuat
extends SuperPositionAbstract {
    public SuperPositionQuat(boolean centered) {
        super(centered);
    }

    @Override
    public Matrix4d superpose(Point3d[] fixed, Point3d[] moved) {
        this.checkInput(fixed, moved);
        if (this.centered) {
            Quat4d q = UnitQuaternions.relativeOrientation(fixed, moved);
            Matrix4d rotTrans = new Matrix4d();
            rotTrans.set(q);
            return rotTrans;
        }
        Point3d[] xref = CalcPoint.clonePoint3dArray(fixed);
        Point3d xtrans = CalcPoint.centroid(xref);
        xtrans.negate();
        CalcPoint.translate(new Vector3d((Tuple3d)xtrans), xref);
        Point3d[] yref = CalcPoint.clonePoint3dArray(moved);
        Point3d ytrans = CalcPoint.centroid(yref);
        ytrans.negate();
        CalcPoint.translate(new Vector3d((Tuple3d)ytrans), yref);
        Quat4d q = UnitQuaternions.relativeOrientation(xref, yref);
        Matrix4d rotTrans = new Matrix4d();
        rotTrans.set(q);
        Matrix4d trans = new Matrix4d();
        trans.setIdentity();
        trans.setTranslation(new Vector3d((Tuple3d)ytrans));
        rotTrans.mul(rotTrans, trans);
        xtrans.negate();
        Matrix4d transInverse = new Matrix4d();
        transInverse.setIdentity();
        transInverse.setTranslation(new Vector3d((Tuple3d)xtrans));
        rotTrans.mul(transInverse, rotTrans);
        return rotTrans;
    }

    @Override
    public double getRmsd(Point3d[] x, Point3d[] y) {
        Point3d[] yclone = CalcPoint.clonePoint3dArray(y);
        this.superposeAndTransform(x, yclone);
        return CalcPoint.rmsd(x, yclone);
    }
}

