/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.chem.ChemComp;
import org.biojava.nbio.structure.chem.ChemCompAtom;
import org.biojava.nbio.structure.chem.ChemCompGroupFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeAdder {
    private static final Logger logger = LoggerFactory.getLogger(ChargeAdder.class);

    public static void addCharges(Structure structure) {
        for (int i = 0; i < structure.nrModels(); ++i) {
            for (Chain c : structure.getChains(i)) {
                for (Group g : c.getAtomGroups()) {
                    ChemComp thisChemComp = ChemCompGroupFactory.getChemComp(g.getPDBName());
                    List<ChemCompAtom> chemAtoms = thisChemComp.getAtoms();
                    for (ChemCompAtom chemCompAtom : chemAtoms) {
                        Atom atom = g.getAtom(chemCompAtom.getAtomId());
                        short shortCharge = (short)chemCompAtom.getCharge();
                        if (atom != null) {
                            atom.setCharge(shortCharge);
                        }
                        for (Group altLoc : g.getAltLocs()) {
                            Atom altAtom = altLoc.getAtom(chemCompAtom.getAtomId());
                            if (altAtom == null) continue;
                            altAtom.setCharge(shortCharge);
                        }
                    }
                }
            }
        }
    }
}

