/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.biojava.nbio.structure.align.util.URLConnectionTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDBStatus {
    private static final Logger logger = LoggerFactory.getLogger(PDBStatus.class);
    public static final String DEFAULT_RCSB_DATA_API_SERVER = "data.rcsb.org";
    public static final String ALL_CURRENT_ENDPOINT = "https://%s/rest/v1/holdings/current/entry_ids";
    public static final String STATUS_ENDPOINT = "https://%s/rest/v1/holdings/status/%s";
    public static final String STATUS_LIST_ENDPOINT = "https://%s/rest/v1/holdings/status?ids=%s";

    public static Status getStatus(String pdbId) throws IOException {
        URL url = new URL(String.format(STATUS_ENDPOINT, DEFAULT_RCSB_DATA_API_SERVER, pdbId.toUpperCase()));
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode node = (JsonNode)objectMapper.readValue(url.openStream(), JsonNode.class);
        return PDBStatus.parseStatusRecord(node);
    }

    public static Status[] getStatus(String[] pdbIds) throws IOException {
        URL url = new URL(String.format(STATUS_LIST_ENDPOINT, DEFAULT_RCSB_DATA_API_SERVER, String.join((CharSequence)",", pdbIds)));
        ArrayList<Status> statuses = new ArrayList<Status>();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode node = (JsonNode)objectMapper.readValue(url.openStream(), JsonNode.class);
        if (node != null && node.isArray()) {
            for (JsonNode record : node) {
                Status status = PDBStatus.parseStatusRecord(record);
                statuses.add(status);
            }
        }
        if (statuses.size() != pdbIds.length) {
            logger.warn("RCSB status request was for {} ids, but {} were returned", (Object)pdbIds.length, (Object)statuses.size());
        }
        return statuses.toArray(new Status[0]);
    }

    private static Status parseStatusRecord(JsonNode jsonNode) {
        JsonNode rcsbRepoHoldingsNode = jsonNode.get("rcsb_repository_holdings_combined");
        return Status.fromString(rcsbRepoHoldingsNode.get("status").asText());
    }

    public static String getCurrent(String oldPdbId) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        URL url = new URL(String.format(STATUS_ENDPOINT, DEFAULT_RCSB_DATA_API_SERVER, oldPdbId.toUpperCase()));
        JsonNode node = (JsonNode)objectMapper.readValue(url.openStream(), JsonNode.class);
        JsonNode rcsbRepoHoldingsNode = node.get("rcsb_repository_holdings_combined");
        Status st = Status.fromString(rcsbRepoHoldingsNode.get("status").asText());
        if (st == Status.REMOVED) {
            JsonNode replacedByNode = rcsbRepoHoldingsNode.get("id_code_replaced_by_latest");
            if (replacedByNode != null) {
                return replacedByNode.asText();
            }
            return null;
        }
        if (st == Status.CURRENT) {
            return oldPdbId;
        }
        return null;
    }

    public static SortedSet<String> getCurrentPDBIds() throws IOException {
        String urlStr = String.format(ALL_CURRENT_ENDPOINT, DEFAULT_RCSB_DATA_API_SERVER);
        URL u = new URL(urlStr);
        InputStream stream = URLConnectionTools.getInputStream(u, 60000);
        ObjectMapper objectMapper = new ObjectMapper();
        TypeFactory typeFactory = objectMapper.getTypeFactory();
        List pdbIdList = (List)objectMapper.readValue(stream, (JavaType)typeFactory.constructCollectionType(List.class, String.class));
        return new TreeSet<String>(pdbIdList);
    }

    public static void main(String[] args) throws Exception {
        SortedSet<String> all = PDBStatus.getCurrentPDBIds();
        System.out.println("Number of current PDB ids is: " + all.size());
    }

    public static enum Status {
        REMOVED,
        CURRENT,
        UNRELEASED;


        public static Status fromString(String statusStr) {
            if (statusStr == null) {
                throw new IllegalArgumentException("Status string can't be null");
            }
            if ("REMOVED".equalsIgnoreCase(statusStr)) {
                return REMOVED;
            }
            if ("CURRENT".equalsIgnoreCase(statusStr)) {
                return CURRENT;
            }
            if ("UNRELEASED".equalsIgnoreCase(statusStr)) {
                return UNRELEASED;
            }
            throw new IllegalArgumentException("Unable to parse status '" + statusStr + "'.");
        }
    }
}

