/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.List;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.JournalArticle;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.Site;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;

public interface Structure
extends Cloneable,
Serializable {
    public Structure clone();

    public String toString();

    public void setName(String var1);

    public String getName();

    public StructureIdentifier getStructureIdentifier();

    public void setStructureIdentifier(StructureIdentifier var1);

    public int size();

    public int size(int var1);

    public int nrModels();

    public boolean isNmr();

    public boolean isCrystallographic();

    public void addModel(List<Chain> var1);

    public void setModel(int var1, List<Chain> var2);

    public List<Chain> getModel(int var1);

    public List<Chain> getChains();

    public void setChains(List<Chain> var1);

    public List<Chain> getChains(int var1);

    public void setChains(int var1, List<Chain> var2);

    public List<Chain> getPolyChains();

    public List<Chain> getPolyChains(int var1);

    public List<Chain> getNonPolyChains();

    public List<Chain> getNonPolyChains(int var1);

    public List<Chain> getWaterChains();

    public List<Chain> getWaterChains(int var1);

    public void addChain(Chain var1);

    public void addChain(Chain var1, int var2);

    public Chain getChainByIndex(int var1);

    public Chain getChainByIndex(int var1, int var2);

    public boolean hasChain(String var1);

    public boolean hasNonPolyChain(String var1);

    public boolean hasPdbChain(String var1);

    public Group findGroup(String var1, String var2) throws StructureException;

    public Group findGroup(String var1, String var2, int var3) throws StructureException;

    public Chain getChain(String var1);

    public Chain getChain(String var1, int var2);

    public Chain getPolyChain(String var1);

    public Chain getPolyChain(String var1, int var2);

    public Chain getPolyChainByPDB(String var1);

    public Chain getPolyChainByPDB(String var1, int var2);

    public Chain getNonPolyChain(String var1);

    public Chain getNonPolyChain(String var1, int var2);

    public List<Chain> getNonPolyChainsByPDB(String var1);

    public List<Chain> getNonPolyChainsByPDB(String var1, int var2);

    public Chain getWaterChain(String var1);

    public Chain getWaterChain(String var1, int var2);

    public Chain getWaterChainByPDB(String var1);

    public Chain getWaterChainByPDB(String var1, int var2);

    public String toPDB();

    public String toMMCIF();

    public void setEntityInfos(List<EntityInfo> var1);

    public List<EntityInfo> getEntityInfos();

    public void addEntityInfo(EntityInfo var1);

    public void setDBRefs(List<DBRef> var1);

    public List<DBRef> getDBRefs();

    public EntityInfo getEntityById(int var1);

    public PDBHeader getPDBHeader();

    public boolean hasJournalArticle();

    public JournalArticle getJournalArticle();

    public void setJournalArticle(JournalArticle var1);

    public List<Bond> getSSBonds();

    public void setSSBonds(List<Bond> var1);

    public void addSSBond(Bond var1);

    public void setPDBHeader(PDBHeader var1);

    public void setSites(List<Site> var1);

    public List<Site> getSites();

    public void setBiologicalAssembly(boolean var1);

    public boolean isBiologicalAssembly();

    public void setCrystallographicInfo(PDBCrystallographicInfo var1);

    public PDBCrystallographicInfo getCrystallographicInfo();

    public void resetModels();

    public String getIdentifier();

    @Deprecated
    public String getPDBCode();

    @Deprecated
    public void setPDBCode(String var1);

    public PdbId getPdbId();

    public void setPdbId(PdbId var1);
}

