/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.pairwise;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;

public class AlignmentResult
implements Serializable {
    private static final long serialVersionUID = -4132105905712445473L;
    AlternativeAlignment[] alignments;
    String pdb1;
    String pdb2;
    String chain1;
    String chain2;
    int length1;
    int length2;
    long calculationTime;
    long ioTime;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.pdb1);
        buf.append("_");
        buf.append(this.chain1);
        buf.append(" vs. ");
        buf.append(this.pdb2);
        buf.append("_");
        buf.append(this.chain2);
        buf.append(" : ");
        buf.append(" l1: ");
        buf.append(this.length1);
        buf.append(" l2: ");
        buf.append(this.length2);
        buf.append(" ");
        if (this.alignments != null && this.alignments.length > 0) {
            AlternativeAlignment a = this.alignments[0];
            buf.append(a.toString());
            int eqr = a.getEqr();
            buf.append(" %res1: ");
            buf.append(Math.round((float)eqr / (float)this.length2 * 100.0f));
            buf.append(" %res2: ");
            buf.append(Math.round((float)eqr / (float)this.length1 * 100.0f));
            buf.append(" ");
        }
        buf.append(" ioTime: ");
        buf.append(this.ioTime);
        buf.append(" compTime: ");
        buf.append(this.calculationTime);
        return buf.toString();
    }

    public AlternativeAlignment[] getAlignments() {
        return this.alignments;
    }

    public void setAlignments(AlternativeAlignment[] alignments) {
        if (alignments.length > 0) {
            this.alignments = new AlternativeAlignment[1];
            this.alignments[0] = alignments[0];
        }
    }

    public String getPdb1() {
        return this.pdb1;
    }

    public void setPdb1(String pdb1) {
        this.pdb1 = pdb1;
    }

    public String getPdb2() {
        return this.pdb2;
    }

    public void setPdb2(String pdb2) {
        this.pdb2 = pdb2;
    }

    public String getChain1() {
        return this.chain1;
    }

    public void setChain1(String chain1) {
        this.chain1 = chain1;
    }

    public String getChain2() {
        return this.chain2;
    }

    public void setChain2(String chain2) {
        this.chain2 = chain2;
    }

    public int getLength1() {
        return this.length1;
    }

    public void setLength1(int length1) {
        this.length1 = length1;
    }

    public int getLength2() {
        return this.length2;
    }

    public void setLength2(int length2) {
        this.length2 = length2;
    }

    public long getCalculationTime() {
        return this.calculationTime;
    }

    public void setCalculationTime(long calculationTime) {
        this.calculationTime = calculationTime;
    }

    public long getIoTime() {
        return this.ioTime;
    }

    public void setIoTime(long ioTime) {
        this.ioTime = ioTime;
    }

    public void serialize(File output) throws IOException {
        FileOutputStream outStream = new FileOutputStream(output);
        ObjectOutputStream objStream = new ObjectOutputStream(outStream);
        objStream.writeObject(this);
        objStream.close();
    }

    public static AlignmentResult deserialize(File output) throws IOException, ClassNotFoundException {
        FileInputStream fin = new FileInputStream(output);
        ObjectInputStream objIn = new ObjectInputStream(fin);
        AlignmentResult result = (AlignmentResult)objIn.readObject();
        objIn.close();
        return result;
    }
}

