/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.cif;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.biojava.nbio.structure.chem.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.cif.ChemCompConsumerImpl;
import org.rcsb.cif.CifIO;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.schema.StandardSchemata;
import org.rcsb.cif.schema.mm.MmCifBlock;
import org.rcsb.cif.schema.mm.MmCifFile;

public class ChemCompConverter {
    public static ChemicalComponentDictionary fromPath(Path path) throws IOException {
        return ChemCompConverter.fromInputStream(Files.newInputStream(path, new OpenOption[0]));
    }

    public static ChemicalComponentDictionary fromURL(URL url) throws IOException {
        return ChemCompConverter.fromInputStream(url.openStream());
    }

    public static ChemicalComponentDictionary fromInputStream(InputStream inputStream) throws IOException {
        return ChemCompConverter.fromCifFile(CifIO.readFromInputStream((InputStream)inputStream));
    }

    public static ChemicalComponentDictionary fromCifFile(CifFile cifFile) {
        ChemCompConsumerImpl consumer = new ChemCompConsumerImpl();
        consumer.prepare();
        MmCifFile mmCifFile = (MmCifFile)cifFile.as(StandardSchemata.MMCIF);
        for (MmCifBlock cifBlock : mmCifFile.getBlocks()) {
            consumer.consumeChemComp(cifBlock.getChemComp());
            consumer.consumeChemCompAtom(cifBlock.getChemCompAtom());
            consumer.consumeChemCompBond(cifBlock.getChemCompBond());
        }
        consumer.finish();
        return (ChemicalComponentDictionary)consumer.getContainer();
    }
}

