/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.cif;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collector;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.EntityType;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.cif.CifFileSupplier;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.rcsb.cif.CifBuilder;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.FloatColumnBuilder;
import org.rcsb.cif.model.IntColumnBuilder;
import org.rcsb.cif.model.StrColumnBuilder;
import org.rcsb.cif.schema.SchemaProvider;
import org.rcsb.cif.schema.StandardSchemata;
import org.rcsb.cif.schema.mm.MmCifBlockBuilder;
import org.rcsb.cif.schema.mm.MmCifCategoryBuilder;
import org.rcsb.cif.schema.mm.MmCifFileBuilder;

public abstract class AbstractCifFileSupplier<S>
implements CifFileSupplier<S> {
    protected CifFile getInternal(Structure structure, List<WrappedAtom> wrappedAtoms) {
        CrystalCell crystalCell = structure.getPDBHeader().getCrystallographicInfo().getCrystalCell();
        SpaceGroup spaceGroup = structure.getPDBHeader().getCrystallographicInfo().getSpaceGroup();
        Category atomSite = wrappedAtoms.stream().collect(AbstractCifFileSupplier.toAtomSite());
        List<EntityInfo> entityInfos = structure.getEntityInfos();
        MmCifBlockBuilder blockBuilder = ((MmCifFileBuilder)CifBuilder.enterFile((SchemaProvider)StandardSchemata.MMCIF)).enterBlock(structure.getPdbId() == null ? "" : structure.getPdbId().getId());
        ((MmCifCategoryBuilder.StructKeywordsBuilder)blockBuilder.enterStructKeywords().enterText().add(new String[]{String.join((CharSequence)", ", structure.getPDBHeader().getKeywords())}).leaveColumn()).leaveCategory();
        if (atomSite.isDefined() && atomSite.getRowCount() > 0) {
            blockBuilder.addCategory(atomSite);
        }
        if (crystalCell != null) {
            ((MmCifCategoryBuilder.CellBuilder)((MmCifCategoryBuilder.CellBuilder)((MmCifCategoryBuilder.CellBuilder)((MmCifCategoryBuilder.CellBuilder)((MmCifCategoryBuilder.CellBuilder)((MmCifCategoryBuilder.CellBuilder)blockBuilder.enterCell().enterLengthA().add(new double[]{crystalCell.getA()}).leaveColumn()).enterLengthB().add(new double[]{crystalCell.getB()}).leaveColumn()).enterLengthC().add(new double[]{crystalCell.getC()}).leaveColumn()).enterAngleAlpha().add(new double[]{crystalCell.getAlpha()}).leaveColumn()).enterAngleBeta().add(new double[]{crystalCell.getBeta()}).leaveColumn()).enterAngleGamma().add(new double[]{crystalCell.getGamma()}).leaveColumn()).leaveCategory();
        }
        if (spaceGroup != null) {
            ((MmCifCategoryBuilder.SymmetryBuilder)blockBuilder.enterSymmetry().enterSpaceGroupNameH_M().add(new String[]{spaceGroup.getShortSymbol()}).leaveColumn()).leaveCategory();
        }
        if (entityInfos != null) {
            String[] entityIds = new String[entityInfos.size()];
            String[] entityTypes = new String[entityInfos.size()];
            String[] entityDescriptions = new String[entityInfos.size()];
            for (int i = 0; i < entityInfos.size(); ++i) {
                EntityInfo e2 = entityInfos.get(i);
                entityIds[i] = Integer.toString(e2.getMolId());
                entityTypes[i] = e2.getType().getEntityType();
                entityDescriptions[i] = e2.getDescription() == null ? "?" : e2.getDescription();
            }
            String[] polyEntityIds = (String[])entityInfos.stream().filter(e -> e.getType() == EntityType.POLYMER).map(e -> Integer.toString(e.getMolId())).toArray(String[]::new);
            String[] polyEntitySeqs = (String[])entityInfos.stream().filter(e -> e.getType() == EntityType.POLYMER).map(e -> e.getChains().get(0).getSeqResSequence()).toArray(String[]::new);
            ((MmCifCategoryBuilder.EntityBuilder)((MmCifCategoryBuilder.EntityBuilder)((MmCifCategoryBuilder.EntityBuilder)blockBuilder.enterEntity().enterId().add(entityIds).leaveColumn()).enterType().add(entityTypes).leaveColumn()).enterPdbxDescription().add(entityDescriptions).leaveColumn()).leaveCategory();
            ((MmCifCategoryBuilder.EntityPolyBuilder)((MmCifCategoryBuilder.EntityPolyBuilder)blockBuilder.enterEntityPoly().enterEntityId().add(polyEntityIds).leaveColumn()).enterPdbxSeqOneLetterCodeCan().add(polyEntitySeqs).leaveColumn()).leaveCategory();
        }
        return blockBuilder.leaveBlock().leaveFile();
    }

    protected void handleChain(Chain chain, int model, List<WrappedAtom> wrappedAtoms) {
        String chainName = chain.getName();
        String chainId = chain.getId();
        for (Group group : chain.getAtomGroups()) {
            LinkedHashMap<Integer, WrappedAtom> uniqueAtoms = new LinkedHashMap<Integer, WrappedAtom>();
            for (int atomIndex = 0; atomIndex < group.size(); ++atomIndex) {
                Atom atom = group.getAtom(atomIndex);
                if (atom == null) continue;
                uniqueAtoms.put(atom.getPDBserial(), new WrappedAtom(model, chainName, chainId, atom, atom.getPDBserial()));
            }
            if (group.hasAltLoc()) {
                for (Group alt : group.getAltLocs()) {
                    for (int atomIndex = 0; atomIndex < alt.size(); ++atomIndex) {
                        Atom atom = alt.getAtom(atomIndex);
                        if (atom == null) continue;
                        uniqueAtoms.put(atom.getPDBserial(), new WrappedAtom(model, chainName, chainId, atom, atom.getPDBserial()));
                    }
                }
            }
            wrappedAtoms.addAll(uniqueAtoms.values());
        }
    }

    public static Collector<WrappedAtom, ?, Category> toAtomSite() {
        return Collector.of(AtomSiteCollector::new, AtomSiteCollector::accept, AtomSiteCollector::combine, AtomSiteCollector::get, new Collector.Characteristics[0]);
    }

    public static class WrappedAtom {
        private final int model;
        private final String chainName;
        private final String chainId;
        private final Atom atom;
        private final int atomId;

        public WrappedAtom(int model, String chainName, String chainId, Atom atom, int atomId) {
            this.model = model;
            this.chainName = chainName;
            this.chainId = chainId;
            this.atom = atom;
            this.atomId = atomId;
        }

        public int getModel() {
            return this.model;
        }

        public String getChainName() {
            return this.chainName;
        }

        public String getChainId() {
            return this.chainId;
        }

        public Atom getAtom() {
            return this.atom;
        }

        public int getAtomId() {
            return this.atomId;
        }
    }

    static class AtomSiteCollector
    implements Consumer<WrappedAtom> {
        private final MmCifCategoryBuilder.AtomSiteBuilder atomSiteBuilder = new MmCifCategoryBuilder.AtomSiteBuilder(null);
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> groupPDB = this.atomSiteBuilder.enterGroupPDB();
        private final IntColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> id = this.atomSiteBuilder.enterId();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> typeSymbol = this.atomSiteBuilder.enterTypeSymbol();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> labelAtomId = this.atomSiteBuilder.enterLabelAtomId();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> labelAltId = this.atomSiteBuilder.enterLabelAltId();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> labelCompId = this.atomSiteBuilder.enterLabelCompId();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> labelAsymId = this.atomSiteBuilder.enterLabelAsymId();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> labelEntityId = this.atomSiteBuilder.enterLabelEntityId();
        private final IntColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> labelSeqId = this.atomSiteBuilder.enterLabelSeqId();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> pdbxPDBInsCode = this.atomSiteBuilder.enterPdbxPDBInsCode();
        private final FloatColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> cartnX = this.atomSiteBuilder.enterCartnX();
        private final FloatColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> cartnY = this.atomSiteBuilder.enterCartnY();
        private final FloatColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> cartnZ = this.atomSiteBuilder.enterCartnZ();
        private final FloatColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> occupancy = this.atomSiteBuilder.enterOccupancy();
        private final FloatColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> bIsoOrEquiv = this.atomSiteBuilder.enterBIsoOrEquiv();
        private final IntColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> authSeqId = this.atomSiteBuilder.enterAuthSeqId();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> authCompId = this.atomSiteBuilder.enterAuthCompId();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> authAsymId = this.atomSiteBuilder.enterAuthAsymId();
        private final StrColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> authAtomId = this.atomSiteBuilder.enterAuthAtomId();
        private final IntColumnBuilder<MmCifCategoryBuilder.AtomSiteBuilder, MmCifBlockBuilder, MmCifFileBuilder> pdbxPDBModelNum = this.atomSiteBuilder.enterPdbxPDBModelNum();

        AtomSiteCollector() {
        }

        @Override
        public void accept(WrappedAtom wrappedAtom) {
            Atom atom = wrappedAtom.getAtom();
            Group group = atom.getGroup();
            Chain chain = group.getChain();
            this.groupPDB.add(new String[]{group.getType().equals((Object)GroupType.HETATM) ? "HETATM" : "ATOM"});
            this.id.add(new int[]{wrappedAtom.getAtomId()});
            Element element = atom.getElement();
            this.typeSymbol.add(new String[]{element.equals((Object)Element.R) ? "X" : element.toString().toUpperCase()});
            this.labelAtomId.add(new String[]{atom.getName()});
            Character altLoc = atom.getAltLoc();
            if (altLoc == null || altLoc.charValue() == ' ') {
                this.labelAltId.markNextNotPresent();
            } else {
                this.labelAltId.add(new String[]{String.valueOf(altLoc)});
            }
            this.labelCompId.add(new String[]{group.getPDBName()});
            this.labelAsymId.add(new String[]{wrappedAtom.getChainId()});
            String entityId = "0";
            int seqId = group.getResidueNumber().getSeqNum();
            if (chain.getEntityInfo() != null) {
                entityId = Integer.toString(chain.getEntityInfo().getMolId());
                if (chain.getEntityInfo().getType() == EntityType.POLYMER) {
                    seqId = chain.getEntityInfo().getAlignedResIndex(group, chain);
                }
            }
            this.labelEntityId.add(new String[]{entityId});
            if (chain.getEntityInfo().getType() == EntityType.POLYMER) {
                this.labelSeqId.add(new int[]{seqId});
            } else {
                this.labelSeqId.markNextNotPresent();
            }
            String insCode = "";
            if (group.getResidueNumber().getInsCode() != null) {
                insCode = Character.toString(group.getResidueNumber().getInsCode().charValue());
            }
            if (insCode.isEmpty()) {
                this.pdbxPDBInsCode.markNextUnknown();
            } else {
                this.pdbxPDBInsCode.add(new String[]{insCode});
            }
            this.cartnX.add(new double[]{atom.getX()});
            this.cartnY.add(new double[]{atom.getY()});
            this.cartnZ.add(new double[]{atom.getZ()});
            this.occupancy.add(new double[]{atom.getOccupancy()});
            this.bIsoOrEquiv.add(new double[]{atom.getTempFactor()});
            this.authSeqId.add(new int[]{group.getResidueNumber().getSeqNum()});
            this.authCompId.add(new String[]{group.getPDBName()});
            this.authAsymId.add(new String[]{wrappedAtom.getChainName()});
            this.authAtomId.add(new String[]{atom.getName()});
            this.pdbxPDBModelNum.add(new int[]{wrappedAtom.getModel()});
        }

        AtomSiteCollector combine(AtomSiteCollector other) {
            throw new UnsupportedOperationException("impl by calling addAll for all collections");
        }

        Category get() {
            this.groupPDB.leaveColumn();
            this.id.leaveColumn();
            this.typeSymbol.leaveColumn();
            this.labelAtomId.leaveColumn();
            this.labelAltId.leaveColumn();
            this.labelCompId.leaveColumn();
            this.labelAsymId.leaveColumn();
            this.labelEntityId.leaveColumn();
            this.labelSeqId.leaveColumn();
            this.pdbxPDBInsCode.leaveColumn();
            this.cartnX.leaveColumn();
            this.cartnY.leaveColumn();
            this.cartnZ.leaveColumn();
            this.occupancy.leaveColumn();
            this.bIsoOrEquiv.leaveColumn();
            this.authSeqId.leaveColumn();
            this.authCompId.leaveColumn();
            this.authAsymId.leaveColumn();
            this.authAtomId.leaveColumn();
            this.pdbxPDBModelNum.leaveColumn();
            return this.atomSiteBuilder.build();
        }
    }
}

