/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.MomentsOfInertia;
import org.biojava.nbio.structure.geometry.UnitQuaternions;
import org.biojava.nbio.structure.symmetry.core.PermutationGroup;
import org.biojava.nbio.structure.symmetry.core.QuatSuperpositionScorer;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySolver;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySubunits;
import org.biojava.nbio.structure.symmetry.core.Rotation;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.geometry.DistanceBox;
import org.biojava.nbio.structure.symmetry.geometry.SphereSampler;

public class RotationSolver
implements QuatSymmetrySolver {
    private QuatSymmetrySubunits subunits = null;
    private QuatSymmetryParameters parameters = null;
    private double distanceThreshold = 0.0;
    private DistanceBox<Integer> box = null;
    private Vector3d centroid = new Vector3d();
    private Matrix4d centroidInverse = new Matrix4d();
    private Point3d[] originalCoords = null;
    private Point3d[] transformedCoords = null;
    private Map<List<Integer>, Rotation> evaluatedPermutations = new HashMap<List<Integer>, Rotation>();
    private RotationGroup rotations = new RotationGroup();

    public RotationSolver(QuatSymmetrySubunits subunits, QuatSymmetryParameters parameters) {
        if (subunits.getSubunitCount() == 2) {
            throw new IllegalArgumentException("RotationSolver cannot be applied to subunits with 2 centers");
        }
        this.subunits = subunits;
        this.parameters = parameters;
    }

    @Override
    public RotationGroup getSymmetryOperations() {
        if (this.rotations.getOrder() == 0) {
            this.solve();
            this.completeRotationGroup(new Rotation[0]);
            this.rotations.complete();
        }
        return this.rotations;
    }

    private void solve() {
        this.initialize();
        int maxSymOps = this.subunits.getSubunitCount();
        boolean isSpherical = this.isSpherical();
        if (maxSymOps % 60 == 0 && isSpherical) {
            maxSymOps = 60;
        }
        AxisAngle4d sphereAngle = new AxisAngle4d();
        Matrix4d transformation = new Matrix4d();
        int n = this.subunits.getSubunitCount();
        int sphereCount = SphereSampler.getSphereCount();
        List<Double> angles = this.getAngles();
        for (int i = 0; i < sphereCount; ++i) {
            SphereSampler.getAxisAngle(i, sphereAngle);
            Iterator<Double> iterator = angles.iterator();
            while (iterator.hasNext()) {
                double angle;
                sphereAngle.angle = angle = iterator.next().doubleValue();
                transformation.set(sphereAngle);
                transformation.setElement(3, 3, 1.0);
                for (int j = 0; j < n; ++j) {
                    this.transformedCoords[j].set((Tuple3d)this.originalCoords[j]);
                    transformation.transform(this.transformedCoords[j]);
                }
                List<Integer> permutation = this.getPermutation();
                if (this.evaluatedPermutations.containsKey(permutation)) continue;
                Rotation newPermutation = this.isValidPermutation(permutation);
                if (newPermutation != null) {
                    this.completeRotationGroup(newPermutation);
                }
                if (this.rotations.getOrder() < maxSymOps) continue;
                return;
            }
        }
    }

    private boolean completeRotationGroup(Rotation ... additionalRots) {
        Rotation rot;
        PermutationGroup g = new PermutationGroup();
        for (Rotation s : this.rotations) {
            g.addPermutation(s.getPermutation());
        }
        for (Rotation s : additionalRots) {
            g.addPermutation(s.getPermutation());
            assert (this.evaluatedPermutations.get(s.getPermutation()) == null);
        }
        g.completeGroup();
        if (g.getOrder() == this.rotations.getOrder() + additionalRots.length) {
            for (Rotation s : additionalRots) {
                this.addRotation(s);
            }
            return true;
        }
        ArrayList<Rotation> newRots = new ArrayList<Rotation>(g.getOrder());
        for (List<Integer> permutation : g) {
            if (!(this.evaluatedPermutations.containsKey(permutation) ? (rot = this.evaluatedPermutations.get(permutation)) == null : !this.isAllowedPermutation(permutation))) continue;
            return false;
        }
        for (List<Integer> permutation : g) {
            rot = this.evaluatedPermutations.containsKey(permutation) ? this.evaluatedPermutations.get(permutation) : this.isValidPermutation(permutation);
            if (rot == null) {
                return false;
            }
            if (this.evaluatedPermutations.containsKey(permutation)) continue;
            newRots.add(rot);
        }
        for (Rotation rot2 : newRots) {
            this.addRotation(rot2);
        }
        return true;
    }

    private void addRotation(Rotation rot) {
        this.evaluatedPermutations.put(rot.getPermutation(), rot);
        this.rotations.addRotation(rot);
    }

    private Rotation superimposePermutation(List<Integer> permutation) {
        int n = this.subunits.getSubunitCount();
        for (int j = 0; j < n; ++j) {
            this.transformedCoords[j].set((Tuple3d)this.originalCoords[permutation.get(j)]);
        }
        int fold = PermutationGroup.getOrder(permutation);
        Quat4d quat = UnitQuaternions.relativeOrientation(this.originalCoords, this.transformedCoords);
        AxisAngle4d axisAngle = new AxisAngle4d();
        Matrix4d transformation = new Matrix4d();
        transformation.set(quat);
        axisAngle.set(quat);
        Vector3d axis = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
        if (axis.lengthSquared() < 1.0E-6) {
            axisAngle.x = 0.0;
            axisAngle.y = 0.0;
            axisAngle.z = 1.0;
            axisAngle.angle = 0.0;
        } else {
            axis.normalize();
            axisAngle.x = axis.x;
            axisAngle.y = axis.y;
            axisAngle.z = axis.z;
        }
        CalcPoint.transform(transformation, this.transformedCoords);
        double subunitRmsd = CalcPoint.rmsd(this.transformedCoords, this.originalCoords);
        if (subunitRmsd < this.parameters.getRmsdThreshold()) {
            this.combineWithTranslation(transformation);
            QuatSymmetryScores scores = QuatSuperpositionScorer.calcScores(this.subunits, transformation, permutation);
            if (scores.getRmsd() < 0.0 || scores.getRmsd() > this.parameters.getRmsdThreshold()) {
                return null;
            }
            scores.setRmsdCenters(subunitRmsd);
            Rotation symmetryOperation = RotationSolver.createSymmetryOperation(permutation, transformation, axisAngle, fold, scores);
            return symmetryOperation;
        }
        return null;
    }

    private List<Double> getAngles() {
        int n = this.subunits.getSubunitCount();
        if (n % 60 == 0 && this.isSpherical()) {
            n = 60;
        }
        List<Integer> folds = this.subunits.getFolds();
        ArrayList<Double> angles = new ArrayList<Double>(folds.size() - 1);
        for (int fold : folds) {
            if (fold <= 0 || fold > n) continue;
            angles.add(Math.PI * 2 / (double)fold);
        }
        return angles;
    }

    private boolean isSpherical() {
        MomentsOfInertia m = this.subunits.getMomentsOfInertia();
        return m.getSymmetryClass(0.05) == MomentsOfInertia.SymmetryClass.SYMMETRIC;
    }

    private Rotation isValidPermutation(List<Integer> permutation) {
        if (permutation.isEmpty()) {
            return null;
        }
        if (this.evaluatedPermutations.containsKey(permutation)) {
            return this.evaluatedPermutations.get(permutation);
        }
        if (!this.isAllowedPermutation(permutation)) {
            this.evaluatedPermutations.put(permutation, null);
            return null;
        }
        Rotation rot = this.superimposePermutation(permutation);
        return rot;
    }

    private boolean isAllowedPermutation(List<Integer> permutation) {
        List<Integer> seqClusterId = this.subunits.getClusterIds();
        int selfaligned = 0;
        for (int i = 0; i < permutation.size(); ++i) {
            int j = permutation.get(i);
            if (!Objects.equals(seqClusterId.get(i), seqClusterId.get(j))) {
                return false;
            }
            if (i != j) continue;
            ++selfaligned;
        }
        return selfaligned == 0 || selfaligned == permutation.size();
    }

    private void combineWithTranslation(Matrix4d rotation) {
        rotation.setTranslation(this.centroid);
        rotation.mul(rotation, this.centroidInverse);
    }

    private static Rotation createSymmetryOperation(List<Integer> permutation, Matrix4d transformation, AxisAngle4d axisAngle, int fold, QuatSymmetryScores scores) {
        Rotation s = new Rotation();
        s.setPermutation(new ArrayList<Integer>(permutation));
        s.setTransformation(new Matrix4d(transformation));
        s.setAxisAngle(new AxisAngle4d(axisAngle));
        s.setFold(fold);
        s.setScores(scores);
        return s;
    }

    private void setupDistanceBox() {
        this.distanceThreshold = this.calcDistanceThreshold();
        this.box = new DistanceBox(this.distanceThreshold);
        for (int i = 0; i < this.originalCoords.length; ++i) {
            this.box.addPoint(this.originalCoords[i], i);
        }
    }

    private double calcDistanceThreshold() {
        double threshold = Double.MAX_VALUE;
        int n = this.subunits.getSubunitCount();
        List<Point3d> centers = this.subunits.getCenters();
        for (int i = 0; i < n - 1; ++i) {
            Point3d pi = centers.get(i);
            for (int j = i + 1; j < n; ++j) {
                Point3d pj = centers.get(j);
                threshold = Math.min(threshold, pi.distanceSquared(pj));
            }
        }
        double distanceThreshold = Math.sqrt(threshold);
        distanceThreshold = Math.max(distanceThreshold, this.parameters.getRmsdThreshold());
        return distanceThreshold;
    }

    private List<Integer> getPermutation() {
        double rmsd;
        ArrayList<Integer> permutation = new ArrayList<Integer>(this.transformedCoords.length);
        double sum = 0.0;
        for (Point3d t : this.transformedCoords) {
            List<Integer> neighbors = this.box.getNeighborsWithCache(t);
            int closest = -1;
            double minDist = Double.MAX_VALUE;
            for (int j : neighbors) {
                double dist = t.distanceSquared(this.originalCoords[j]);
                if (!(dist < minDist)) continue;
                closest = j;
                minDist = dist;
            }
            sum += minDist;
            if (closest == -1) break;
            permutation.add(closest);
        }
        if ((rmsd = Math.sqrt(sum / (double)this.transformedCoords.length)) > this.distanceThreshold || permutation.size() != this.transformedCoords.length) {
            permutation.clear();
            return permutation;
        }
        HashSet<Integer> set = new HashSet<Integer>(permutation);
        if (set.size() != this.originalCoords.length) {
            permutation.clear();
        }
        return permutation;
    }

    private void initialize() {
        this.centroid = new Vector3d((Tuple3d)this.subunits.getCentroid());
        Vector3d reverse = new Vector3d(this.centroid);
        reverse.negate();
        this.centroidInverse.set(reverse);
        this.centroidInverse.setElement(3, 3, 1.0);
        List<Point3d> centers = this.subunits.getCenters();
        int n = this.subunits.getSubunitCount();
        this.originalCoords = new Point3d[n];
        this.transformedCoords = new Point3d[n];
        for (int i = 0; i < n; ++i) {
            this.originalCoords[i] = centers.get(i);
            this.transformedCoords[i] = new Point3d();
        }
        this.setupDistanceBox();
    }
}

