/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.xtal;

import jakarta.xml.bind.JAXBException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.xtal.BravaisLattice;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.biojava.nbio.structure.xtal.io.SpaceGroupMapRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymoplibParser {
    private static final Logger logger = LoggerFactory.getLogger(SymoplibParser.class);
    private static final String newline = System.getProperty("line.separator");
    private static final String SPACE_GROUPS_FILE = "org/biojava/nbio/structure/xtal/spacegroups.xml";
    private static final Pattern namePat = Pattern.compile(".*\\s([A-Z]+)(\\s'.+')?\\s+'(.+)'.*");
    private static TreeMap<Integer, SpaceGroup> sgs = SymoplibParser.parseSpaceGroupsXML();
    private static HashMap<String, SpaceGroup> name2sgs;

    public static SpaceGroup getSpaceGroup(int id) {
        return sgs.get(id);
    }

    private static TreeMap<Integer, SpaceGroup> parseSpaceGroupsXML() {
        InputStream spaceGroupIS = SymoplibParser.class.getClassLoader().getResourceAsStream(SPACE_GROUPS_FILE);
        if (spaceGroupIS == null) {
            logger.error("Fatal error! Could not find resource: org/biojava/nbio/structure/xtal/spacegroups.xml. This probably means that your biojava jar file is corrupt or incorrectly built.");
            System.exit(1);
        }
        TreeMap<Object, Object> map = new TreeMap();
        try {
            map = SymoplibParser.parseSpaceGroupsXML(spaceGroupIS);
        }
        catch (IOException e) {
            logger.error("Fatal error! Could not parse resource: org/biojava/nbio/structure/xtal/spacegroups.xml. Error: " + e.getMessage());
            System.exit(1);
        }
        catch (JAXBException e) {
            logger.error("Fatal error! Could not parse resource: org/biojava/nbio/structure/xtal/spacegroups.xml. Problem in xml formatting: " + e.getMessage());
            System.exit(1);
        }
        name2sgs = new HashMap();
        for (SpaceGroup spaceGroup : map.values()) {
            spaceGroup.initializeCellTranslations();
            name2sgs.put(spaceGroup.getShortSymbol(), spaceGroup);
            if (spaceGroup.getAltShortSymbol() == null) continue;
            name2sgs.put(spaceGroup.getAltShortSymbol(), spaceGroup);
        }
        return map;
    }

    public static TreeMap<Integer, SpaceGroup> parseSpaceGroupsXML(InputStream spaceGroupIS) throws IOException, JAXBException {
        String xml = SymoplibParser.convertStreamToString(spaceGroupIS);
        SpaceGroupMapRoot spaceGroups = SpaceGroupMapRoot.fromXML(xml);
        return spaceGroups.getMapProperty();
    }

    private static String convertStreamToString(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line).append(newline);
        }
        return sb.toString();
    }

    public static SpaceGroup getSpaceGroup(String shortName) {
        if (shortName == null || ((String)shortName).length() <= 2) {
            return null;
        }
        if ("P 1-".equals(shortName)) {
            shortName = "P -1";
        }
        shortName = ((String)shortName).substring(0, 1) + ((String)shortName).substring(1).toLowerCase();
        return name2sgs.get(shortName);
    }

    public static TreeMap<Integer, SpaceGroup> getAllSpaceGroups() {
        return sgs;
    }

    public static TreeMap<Integer, SpaceGroup> parseSymopLib(InputStream symoplibIS) {
        TreeMap<Integer, SpaceGroup> map = new TreeMap<Integer, SpaceGroup>();
        name2sgs = new HashMap();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(symoplibIS));
            SpaceGroup currentSG = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(" ")) {
                    if (currentSG != null) {
                        map.put(currentSG.getId(), currentSG);
                        name2sgs.put(currentSG.getShortSymbol(), currentSG);
                        if (currentSG.getAltShortSymbol() != null) {
                            name2sgs.put(currentSG.getAltShortSymbol(), currentSG);
                        }
                    }
                    int idxFirstSpace = line.indexOf(32);
                    int idxSecondSpace = line.indexOf(32, idxFirstSpace + 1);
                    int idxThirdSpace = line.indexOf(32, idxSecondSpace + 1);
                    int id = Integer.parseInt(line.substring(0, idxFirstSpace));
                    int multiplicity = Integer.parseInt(line.substring(idxFirstSpace + 1, idxSecondSpace));
                    int primitiveMultiplicity = Integer.parseInt(line.substring(idxSecondSpace + 1, idxThirdSpace));
                    Matcher m = namePat.matcher(line);
                    String shortSymbol = null;
                    String altShortSymbol = null;
                    String brav = null;
                    if (m.matches()) {
                        brav = m.group(1);
                        altShortSymbol = m.group(2);
                        if (altShortSymbol != null) {
                            altShortSymbol = altShortSymbol.trim().replaceAll("'", "");
                        }
                        shortSymbol = m.group(3);
                    }
                    currentSG = new SpaceGroup(id, multiplicity, primitiveMultiplicity, shortSymbol, altShortSymbol, BravaisLattice.getByName(brav));
                    continue;
                }
                currentSG.addTransformation(line.trim());
            }
            br.close();
            map.put(currentSG.getId(), currentSG);
            name2sgs.put(currentSG.getShortSymbol(), currentSG);
            if (currentSG.getAltShortSymbol() != null) {
                name2sgs.put(currentSG.getAltShortSymbol(), currentSG);
            }
        }
        catch (IOException e) {
            logger.error("Fatal error! Can't read symop.lib file. Error: " + e.getMessage() + ". ");
            System.exit(1);
        }
        for (SpaceGroup sg : map.values()) {
            sg.initializeCellTranslations();
        }
        return map;
    }
}

