/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ws.alignment.qblast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.ws.alignment.RemotePairwiseAlignmentProperties;
import org.biojava.nbio.ws.alignment.qblast.BlastAlignmentParameterEnum;
import org.biojava.nbio.ws.alignment.qblast.BlastMatrixEnum;
import org.biojava.nbio.ws.alignment.qblast.BlastProgramEnum;

public class NCBIQBlastAlignmentProperties
implements RemotePairwiseAlignmentProperties {
    private static final long serialVersionUID = 7158270364392309841L;
    private Map<BlastAlignmentParameterEnum, String> param = new HashMap<BlastAlignmentParameterEnum, String>();

    @Override
    public String getAlignmentOption(String key) {
        return this.getAlignmentOption(BlastAlignmentParameterEnum.valueOf(key));
    }

    @Override
    public void setAlignementOption(String key, String val) {
        this.setAlignmentOption(BlastAlignmentParameterEnum.valueOf(key), val);
    }

    @Override
    public Set<String> getAlignmentOptions() {
        HashSet<String> result = new HashSet<String>();
        for (BlastAlignmentParameterEnum parameter : this.param.keySet()) {
            result.add(parameter.name());
        }
        return result;
    }

    public String getAlignmentOption(BlastAlignmentParameterEnum key) {
        return this.param.get((Object)key);
    }

    public void setAlignmentOption(BlastAlignmentParameterEnum key, String val) {
        this.param.put(key, val);
    }

    public void removeAlignmentOption(BlastAlignmentParameterEnum key) {
        this.param.remove((Object)key);
    }

    public BlastProgramEnum getBlastProgram() {
        BlastProgramEnum program = BlastProgramEnum.valueOf(this.getAlignmentOption(BlastAlignmentParameterEnum.PROGRAM));
        boolean isMegablast = BlastProgramEnum.blastn == program && this.getAlignmentOption(BlastAlignmentParameterEnum.MEGABLAST).equals("on");
        return !isMegablast ? program : BlastProgramEnum.megablast;
    }

    public void setBlastProgram(BlastProgramEnum program) {
        if (BlastProgramEnum.megablast != program) {
            this.setAlignmentOption(BlastAlignmentParameterEnum.PROGRAM, program.name());
            this.removeAlignmentOption(BlastAlignmentParameterEnum.MEGABLAST);
        } else {
            this.setAlignmentOption(BlastAlignmentParameterEnum.PROGRAM, BlastProgramEnum.blastn.name());
            this.setAlignmentOption(BlastAlignmentParameterEnum.MEGABLAST, "on");
        }
    }

    public String getBlastDatabase() {
        return this.getAlignmentOption(BlastAlignmentParameterEnum.DATABASE);
    }

    public void setBlastDatabase(String database) {
        this.setAlignmentOption(BlastAlignmentParameterEnum.DATABASE, database);
    }

    public double getBlastExpect() {
        if (this.param.containsKey((Object)BlastAlignmentParameterEnum.EXPECT)) {
            return Double.parseDouble(this.getAlignmentOption(BlastAlignmentParameterEnum.EXPECT));
        }
        return 10.0;
    }

    public void setBlastExpect(double expect) {
        this.setAlignmentOption(BlastAlignmentParameterEnum.EXPECT, Double.toString(expect));
    }

    public int getBlastWordSize() {
        if (this.param.containsKey((Object)BlastAlignmentParameterEnum.WORD_SIZE)) {
            return Integer.parseInt(this.getAlignmentOption(BlastAlignmentParameterEnum.WORD_SIZE));
        }
        try {
            BlastProgramEnum programType = this.getBlastProgram();
            switch (programType) {
                case blastn: {
                    return 11;
                }
                case megablast: {
                    return 28;
                }
                case blastp: 
                case blastx: 
                case tblastn: 
                case tblastx: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException("Blast program " + programType.name() + " is not supported.");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Blast program " + (Object)((Object)this.getBlastProgram()) + " is not supported.", e);
        }
    }

    public void setBlastWordSize(int word) {
        this.setAlignmentOption(BlastAlignmentParameterEnum.WORD_SIZE, Integer.toString(word));
    }

    public int getBlastGapCreation() {
        String gapCosts = this.getAlignmentOption(BlastAlignmentParameterEnum.GAPCOSTS);
        try {
            String gapCreation = gapCosts.split("\\+")[0];
            return Integer.parseInt(gapCreation);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getBlastGapExtension() {
        String gapCosts = this.getAlignmentOption(BlastAlignmentParameterEnum.GAPCOSTS);
        try {
            String gapExtension = gapCosts.split("\\+")[1];
            return Integer.parseInt(gapExtension);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getBlastGapCosts() {
        return this.getAlignmentOption(BlastAlignmentParameterEnum.GAPCOSTS);
    }

    public void setBlastGapCosts(int gapCreation, int gapExtension) {
        String gc = Integer.toString(gapCreation);
        String ge = Integer.toString(gapExtension);
        this.setAlignmentOption(BlastAlignmentParameterEnum.GAPCOSTS, gc + "+" + ge);
    }

    public String getBlastMatrix() {
        return this.getAlignmentOption(BlastAlignmentParameterEnum.MATRIX_NAME);
    }

    public void setBlastMatrix(BlastMatrixEnum matrix) {
        boolean gapCostsSet;
        this.setAlignmentOption(BlastAlignmentParameterEnum.MATRIX_NAME, matrix.name());
        boolean bl = gapCostsSet = this.getBlastGapCreation() != -1 || this.getBlastGapExtension() != -1;
        if (!gapCostsSet) {
            switch (matrix) {
                case PAM30: {
                    this.setBlastGapCosts(9, 1);
                    break;
                }
                case PAM70: {
                    this.setBlastGapCosts(10, 1);
                    break;
                }
                case PAM250: {
                    this.setBlastGapCosts(14, 2);
                    break;
                }
                case BLOSUM45: {
                    this.setBlastGapCosts(15, 2);
                    break;
                }
                case BLOSUM50: {
                    this.setBlastGapCosts(13, 2);
                    break;
                }
                case BLOSUM80: 
                case BLOSUM90: {
                    this.setBlastGapCosts(10, 1);
                    break;
                }
                case BLOSUM62: {
                    break;
                }
            }
        }
    }

    public void setBlastFromToPosition(int start, int end) {
        if (start >= end) {
            throw new IllegalArgumentException("Start index must be less than end index");
        }
        this.setAlignmentOption(BlastAlignmentParameterEnum.QUERY_FROM, String.valueOf(start));
        this.setAlignmentOption(BlastAlignmentParameterEnum.QUERY_TO, String.valueOf(end));
    }

    public int getBlastFromPosition() {
        return Integer.parseInt(this.getAlignmentOption(BlastAlignmentParameterEnum.QUERY_FROM));
    }

    public int getBlastToPosition() {
        return Integer.parseInt(this.getAlignmentOption(BlastAlignmentParameterEnum.QUERY_TO));
    }

    public void setBlastAdvancedOptions(String advancedOptions) {
        this.setAlignmentOption(BlastAlignmentParameterEnum.OTHER_ADVANCED, advancedOptions.replaceAll(" ", "+"));
    }

    public String getBlastAdvancedOptions() {
        return this.getAlignmentOption(BlastAlignmentParameterEnum.OTHER_ADVANCED);
    }
}

