/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.asadmin.commands;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.n0pe.asadmin.AbstractAsAdminCmd;

public class Deployment
extends AbstractAsAdminCmd {
    public static final String DEPLOY = "deploy";
    public static final String REDEPLOY = "redeploy";
    public static final String UNDEPLOY = "undeploy";
    public static final String FORCE_OPT = "--force";
    public static final String UPLOAD_OPT = "--upload";
    public static final String CONTEXTROOT_OPT = "--contextroot";
    public static final String NAME_OPT = "--name";
    public static final String TARGET_OPT = "--target";
    public static final String AVAILABILITY_OPT = "--availabilityenabled";
    public static final String PRECOMPILE_JSP_OPT = "--precompilejsp";
    public static final String VIRTUAL_SERVERS_OPT = "--virtualservers";
    private static final int DEPLOY_MODE = 1;
    private static final int UNDEPLOY_MODE = 2;
    private static final int REDEPLOY_MODE = 3;
    private int ACTION = -1;
    private String archive;
    private String component;
    private String contextRoot;
    private String appName;
    private String target;
    private String virtualServers;
    private boolean force;
    private boolean upload;
    private Boolean precompilejsp = null;
    private Boolean availability = null;

    public Deployment deploy() {
        this.ACTION = 1;
        return this;
    }

    public Deployment undeploy() {
        this.ACTION = 2;
        return this;
    }

    public Deployment redeploy() {
        this.ACTION = 3;
        return this;
    }

    public Deployment archive(String archive) {
        this.archive = archive;
        return this;
    }

    public Deployment component(String component) {
        this.component = component;
        return this;
    }

    public Deployment withContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
        return this;
    }

    public Deployment force(boolean force) {
        this.force = force;
        return this;
    }

    public Deployment upload(boolean upload) {
        this.upload = upload;
        return this;
    }

    public Deployment precompilejsp(boolean precompilejsp) {
        this.precompilejsp = precompilejsp;
        return this;
    }

    public Deployment appName(String appName) {
        this.appName = appName;
        return this;
    }

    public Deployment target(String target) {
        this.target = target;
        return this;
    }

    public Deployment availability(boolean haEnable) {
        this.availability = haEnable;
        return this;
    }

    public Deployment virtualServers(String virtualServers) {
        this.virtualServers = virtualServers;
        return this;
    }

    public boolean needCredentials() {
        return true;
    }

    public String getActionCommand() {
        if (this.ACTION == 1) {
            return DEPLOY;
        }
        if (this.ACTION == 2) {
            return UNDEPLOY;
        }
        if (this.ACTION == 3) {
            return REDEPLOY;
        }
        throw new IllegalStateException();
    }

    public String[] getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.target) && this.ACTION != 3) {
            parameters.add(TARGET_OPT);
            parameters.add(this.target);
        }
        if (this.ACTION == 1) {
            if (this.archive == null) {
                throw new IllegalStateException("Cannot deploy without an archive");
            }
            if (this.force) {
                parameters.add(FORCE_OPT);
            }
            if (this.upload) {
                parameters.add(UPLOAD_OPT);
            }
            if (this.availability != null) {
                parameters.add(AVAILABILITY_OPT);
                parameters.add(this.availability.toString());
            }
            if (this.precompilejsp != null) {
                parameters.add(PRECOMPILE_JSP_OPT);
                parameters.add(this.precompilejsp.toString());
            }
            if (!StringUtils.isEmpty((String)this.contextRoot)) {
                parameters.add(CONTEXTROOT_OPT);
                parameters.add(this.contextRoot);
            }
            if (!StringUtils.isEmpty((String)this.virtualServers)) {
                parameters.add(VIRTUAL_SERVERS_OPT);
                parameters.add(this.virtualServers);
            }
            if (!StringUtils.isEmpty((String)this.appName)) {
                parameters.add(NAME_OPT);
                parameters.add(this.appName);
            }
            parameters.add(this.archive);
        } else if (this.ACTION == 2) {
            if (this.component == null) {
                throw new IllegalStateException("Cannot undeploy without a component");
            }
            parameters.add(this.component);
        } else if (this.ACTION == 3) {
            if (StringUtils.isEmpty((String)this.appName)) {
                throw new IllegalStateException("Cannot redeploy without sepcifying a name");
            }
            parameters.add(NAME_OPT);
            parameters.add(this.appName);
            if (this.upload) {
                parameters.add(UPLOAD_OPT);
            }
            if (this.precompilejsp != null) {
                parameters.add(PRECOMPILE_JSP_OPT);
                parameters.add(this.precompilejsp.toString());
            }
            if (!StringUtils.isEmpty((String)this.contextRoot)) {
                parameters.add(CONTEXTROOT_OPT);
                parameters.add(this.contextRoot);
            }
            if (!StringUtils.isEmpty((String)this.virtualServers)) {
                parameters.add(VIRTUAL_SERVERS_OPT);
                parameters.add(this.virtualServers);
            }
            if (!StringUtils.isEmpty((String)this.archive)) {
                parameters.add(this.archive);
            }
        } else {
            throw new IllegalStateException("No action given");
        }
        return parameters.toArray(new String[parameters.size()]);
    }
}

