/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.ruby;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractRubyMojo
extends AbstractMojo {
    protected File workingDirectory;
    private Map pluginArtifactMap;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;

    protected void forkJavaVM(String[] args) throws MojoExecutionException {
        try {
            Commandline commandLine = new Commandline();
            commandLine.setExecutable(this.getJavaExecutable().getAbsolutePath());
            commandLine.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
            commandLine.addArguments(args);
            StreamConsumer stdout = new StreamConsumer(){

                public void consumeLine(String line) {
                    AbstractRubyMojo.this.getLog().info((CharSequence)line);
                }
            };
            StreamConsumer stderr = new StreamConsumer(){

                public void consumeLine(String line) {
                    AbstractRubyMojo.this.getLog().error((CharSequence)line);
                }
            };
            int ret = CommandLineUtils.executeCommandLine((Commandline)commandLine, (StreamConsumer)stdout, (StreamConsumer)stderr);
            if (ret != 0) {
                throw new MojoExecutionException("RubyRunMain exited with status code: " + ret);
            }
        }
        catch (CommandLineException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    protected String getClasspath() throws MojoExecutionException {
        try {
            ArrayList<String> classpath = new ArrayList<String>();
            ArrayList<String> scopesToUse = new ArrayList<String>();
            scopesToUse.add("compile");
            scopesToUse.add("runtime");
            Iterator<Object> it = this.pluginArtifactMap.keySet().iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)this.pluginArtifactMap.get((String)it.next());
                if (!scopesToUse.contains(artifact.getScope())) continue;
                this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                classpath.add(artifact.getFile().getAbsolutePath());
            }
            Artifact self = this.artifactFactory.createArtifact("org.n0pe.mojo", "ruby-maven-plugin", "0.1-SNAPSHOT", "runtime", "maven-plugin");
            this.artifactResolver.resolve(self, this.remoteRepositories, this.localRepository);
            classpath.add(self.getFile().getAbsolutePath());
            it = classpath.iterator();
            StringWriter sw = new StringWriter();
            while (it.hasNext()) {
                sw.append((String)it.next());
                if (!it.hasNext()) continue;
                sw.append(File.pathSeparator);
            }
            return sw.toString();
        }
        catch (ArtifactResolutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (ArtifactNotFoundException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    protected File getJavaExecutable() throws MojoExecutionException {
        String javaHome = System.getenv("JAVA_HOME");
        if (StringUtils.isEmpty((String)javaHome)) {
            throw new MojoExecutionException("JAVA_HOME is not set, cannot continue");
        }
        File java = new File(javaHome + File.separator + "bin" + File.separator + "java");
        if (!java.exists()) {
            throw new MojoExecutionException("Cannot find the java executable at: " + java.getAbsolutePath());
        }
        if (!java.canExecute()) {
            throw new MojoExecutionException("Found java executable is not executable, cannot continue");
        }
        return java;
    }
}

