/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.ruby;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jruby.javasupport.bsf.JRubyEngine;

public class RubyExecMain {
    public static void main(String[] args) {
        try {
            File rubyScript;
            if (args.length != 1 || StringUtils.isEmpty((String)args[0])) {
                System.err.println("RubyExecMain take only one parameter : a ruby script to run");
                System.exit(1);
            }
            if (!(rubyScript = new File(args[0])).exists() || !rubyScript.canRead()) {
                System.err.println("RubyExecMain could not read the ruby script: " + rubyScript.getAbsolutePath());
            }
            BSFManager.registerScriptingEngine((String)"ruby", (String)JRubyEngine.class.getName(), (String[])new String[]{"rb"});
            BSFManager rubyManager = new BSFManager();
            rubyManager.exec("ruby", rubyScript.getAbsolutePath(), -1, -1, (Object)IOUtils.toString((Reader)new FileReader(rubyScript)));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (BSFException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

