/*
 * Decompiled with CFR 0.152.
 */
package org.codemonkey.simplejavamail;

import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransportStrategy {
    SMTP_PLAIN{

        public Properties generateProperties() {
            Properties props = super.generateProperties();
            props.put("mail.transport.protocol", "smtp");
            return props;
        }

        String propertyNameHost() {
            return "mail.smtp.host";
        }

        String propertyNamePort() {
            return "mail.smtp.port";
        }

        String propertyNameUsername() {
            return "mail.smtp.username";
        }

        String propertyNameAuthenticate() {
            return "mail.smtp.auth";
        }
    }
    ,
    SMTP_SSL{

        public Properties generateProperties() {
            Properties props = super.generateProperties();
            props.put("mail.transport.protocol", "smtps");
            props.put("mail.smtps.quitwait", "false");
            return props;
        }

        String propertyNameHost() {
            return "mail.smtps.host";
        }

        String propertyNamePort() {
            return "mail.smtps.port";
        }

        String propertyNameUsername() {
            return "mail.smtps.username";
        }

        String propertyNameAuthenticate() {
            return "mail.smtps.auth";
        }
    }
    ,
    SMTP_TLS{

        public Properties generateProperties() {
            Properties props = super.generateProperties();
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.starttls.enable", "true");
            return props;
        }

        String propertyNameHost() {
            return "mail.smtp.host";
        }

        String propertyNamePort() {
            return "mail.smtp.port";
        }

        String propertyNameUsername() {
            return "mail.smtp.username";
        }

        String propertyNameAuthenticate() {
            return "mail.smtp.auth";
        }
    };


    public Properties generateProperties() {
        return new Properties();
    }

    abstract String propertyNameHost();

    abstract String propertyNamePort();

    abstract String propertyNameUsername();

    abstract String propertyNameAuthenticate();
}

