/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.Class;
import fj.F;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Natural;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.Validation;
import fj.data.hlist.HList;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;
import fj.data.vector.V5;
import fj.data.vector.V6;
import fj.data.vector.V7;
import fj.data.vector.V8;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Show<A> {
    private final F<A, Stream<Character>> f;
    public static final Show<Boolean> booleanShow = Show.anyShow();
    public static final Show<Byte> byteShow = Show.anyShow();
    public static final Show<Character> charShow = Show.anyShow();
    public static final Show<Double> doubleShow = Show.anyShow();
    public static final Show<Float> floatShow = Show.anyShow();
    public static final Show<Integer> intShow = Show.anyShow();
    public static final Show<BigInteger> bigintShow = Show.anyShow();
    public static final Show<BigDecimal> bigdecimalShow = Show.anyShow();
    public static final Show<Long> longShow = Show.anyShow();
    public static final Show<Short> shortShow = Show.anyShow();
    public static final Show<String> stringShow = Show.anyShow();
    public static final Show<StringBuffer> stringBufferShow = Show.anyShow();
    public static final Show<StringBuilder> stringBuilderShow = Show.anyShow();
    public static final Show<Natural> naturalShow = bigintShow.comap(new F<Natural, BigInteger>(){

        @Override
        public BigInteger f(Natural natural) {
            return natural.bigIntegerValue();
        }
    });
    public static final Show<LazyString> lazyStringShow = Show.show(new F<LazyString, Stream<Character>>(){

        @Override
        public Stream<Character> f(LazyString string) {
            return string.toStream();
        }
    });
    public static final Show<HList.HNil> HListShow = Show.showS(Function.constant("Nil"));

    private Show(F<A, Stream<Character>> f) {
        this.f = f;
    }

    public <B> Show<B> comap(F<B, A> f) {
        return Show.show(Function.compose(this.f, f));
    }

    public Stream<Character> show(A a) {
        return this.f.f(a);
    }

    public List<Character> showl(A a) {
        return this.show(a).toList();
    }

    public String showS(A a) {
        return Stream.asString(this.show(a));
    }

    public F<A, String> showS_() {
        return new F<A, String>(){

            @Override
            public String f(A a) {
                return Show.this.showS(a);
            }
        };
    }

    public F<A, Stream<Character>> show_() {
        return this.f;
    }

    public Unit println(A a) {
        this.print(a);
        System.out.println();
        return Unit.unit();
    }

    public Unit print(A a) {
        char[] buffer = new char[8192];
        int c = 0;
        Stream<Character> cs = this.show(a);
        while (cs.isNotEmpty()) {
            buffer[c] = cs.head().charValue();
            if (++c == 8192) {
                System.out.print(buffer);
                c = 0;
            }
            cs = cs.tail()._1();
        }
        System.out.print(Array.copyOfRange(buffer, 0, c));
        return Unit.unit();
    }

    public void printlnE(A a) {
        System.err.println(this.showS(a));
    }

    public static <A> Show<A> show(F<A, Stream<Character>> f) {
        return new Show<A>(f);
    }

    public static <A> Show<A> showS(final F<A, String> f) {
        return new Show<A>(new F<A, Stream<Character>>(){

            @Override
            public Stream<Character> f(A a) {
                return Stream.fromString((String)f.f(a));
            }
        });
    }

    public static <A> Show<A> anyShow() {
        return new Show<A>(new F<A, Stream<Character>>(){

            @Override
            public Stream<Character> f(A a) {
                return Stream.fromString(a.toString());
            }
        });
    }

    public static <A> Show<Option<A>> optionShow(final Show<A> sa) {
        return new Show<Option<A>>(new F<Option<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Option<A> o) {
                return o.isNone() ? Stream.fromString("None") : Stream.fromString("Some(").append((Stream)sa.f.f(o.some())).append(Stream.single(Character.valueOf(')')));
            }
        });
    }

    public static <A, B> Show<Either<A, B>> eitherShow(final Show<A> sa, final Show<B> sb) {
        return new Show<Either<A, B>>(new F<Either<A, B>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Either<A, B> e) {
                return e.isLeft() ? Stream.fromString("Left(").append((Stream)sa.f.f(e.left().value())).append(Stream.single(Character.valueOf(')'))) : Stream.fromString("Right(").append((Stream)sb.f.f(e.right().value())).append(Stream.single(Character.valueOf(')')));
            }
        });
    }

    public static <A, B> Show<Validation<A, B>> validationShow(final Show<A> sa, final Show<B> sb) {
        return new Show<Validation<A, B>>(new F<Validation<A, B>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Validation<A, B> v) {
                return v.isFail() ? Stream.fromString("Fail(").append((Stream)sa.f.f(v.fail())).append(Stream.single(Character.valueOf(')'))) : Stream.fromString("Success(").append((Stream)sb.f.f(v.success())).append(Stream.single(Character.valueOf(')')));
            }
        });
    }

    public static <A> Show<List<A>> listShow(final Show<A> sa) {
        return new Show<List<A>>(new F<List<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(List<A> as) {
                return Show.streamShow(sa).show(as.toStream());
            }
        });
    }

    public static <A> Show<NonEmptyList<A>> nonEmptyListShow(Show<A> sa) {
        return Show.listShow(sa).comap(NonEmptyList.toList_());
    }

    public static <A> Show<Tree<A>> treeShow(final Show<A> sa) {
        return new Show<Tree<A>>(new F<Tree<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Tree<A> a) {
                Stream<Character> b = ((Stream)sa.f.f(a.root())).append((Stream)Show.p1Show(Show.streamShow(Show.treeShow(sa))).f.f(a.subForest())).snoc(Character.valueOf(')'));
                return Stream.cons(Character.valueOf('('), P.p(b));
            }
        });
    }

    public static <A> Show<Stream<A>> streamShow(final Show<A> sa) {
        return new Show<Stream<A>>(new F<Stream<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Stream<A> as) {
                return Stream.join(as.map(sa.show_()).intersperse(Stream.fromString(",")).cons(Stream.fromString("<")).snoc(P.p(Stream.fromString(">"))));
            }
        });
    }

    public static <A> Show<Array<A>> arrayShow(final Show<A> sa) {
        return new Show<Array<A>>(new F<Array<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Array<A> as) {
                Stream<Object> b = Stream.nil();
                for (int i = 0; i < as.length(); ++i) {
                    b = b.append((Stream)sa.f.f(as.get(i)));
                    if (i == as.length() - 1) continue;
                    b = b.snoc(Character.valueOf(','));
                }
                b = b.snoc(Character.valueOf('}'));
                return Stream.cons(Character.valueOf('{'), P.p(b));
            }
        });
    }

    public static <A> Show<Class<A>> classShow() {
        return new Show<Class<A>>(new F<Class<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Class<A> c) {
                return Show.anyShow().show(c.clas());
            }
        });
    }

    public static <A> Show<P1<A>> p1Show(final Show<A> sa) {
        return new Show<P1<A>>(new F<P1<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P1<A> p) {
                return Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B> Show<P2<A, B>> p2Show(final Show<A> sa, final Show<B> sb) {
        return new Show<P2<A, B>>(new F<P2<A, B>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P2<A, B> p) {
                return Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C> Show<P3<A, B, C>> p3Show(final Show<A> sa, final Show<B> sb, final Show<C> sc) {
        return new Show<P3<A, B, C>>(new F<P3<A, B, C>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P3<A, B, C> p) {
                return Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D> Show<P4<A, B, C, D>> p4Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd) {
        return new Show<P4<A, B, C, D>>(new F<P4<A, B, C, D>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P4<A, B, C, D> p) {
                return Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E> Show<P5<A, B, C, D, E>> p5Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd, final Show<E> se) {
        return new Show<P5<A, B, C, D, E>>(new F<P5<A, B, C, D, E>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P5<A, B, C, D, E> p) {
                return Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E, F$> Show<P6<A, B, C, D, E, F$>> p6Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd, final Show<E> se, final Show<F$> sf) {
        return new Show<P6<A, B, C, D, E, F$>>(new F<P6<A, B, C, D, E, F$>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P6<A, B, C, D, E, F$> p) {
                return Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(',')).append(sf.show(p._6())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E, F$, G> Show<P7<A, B, C, D, E, F$, G>> p7Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd, final Show<E> se, final Show<F$> sf, final Show<G> sg) {
        return new Show<P7<A, B, C, D, E, F$, G>>(new F<P7<A, B, C, D, E, F$, G>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P7<A, B, C, D, E, F$, G> p) {
                return Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(',')).append(sf.show(p._6())).snoc(Character.valueOf(',')).append(sg.show(p._7())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A, B, C, D, E, F$, G, H> Show<P8<A, B, C, D, E, F$, G, H>> p8Show(final Show<A> sa, final Show<B> sb, final Show<C> sc, final Show<D> sd, final Show<E> se, final Show<F$> sf, final Show<G> sg, final Show<H> sh) {
        return new Show<P8<A, B, C, D, E, F$, G, H>>(new F<P8<A, B, C, D, E, F$, G, H>, Stream<Character>>(){

            @Override
            public Stream<Character> f(P8<A, B, C, D, E, F$, G, H> p) {
                return Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(',')).append(sf.show(p._6())).snoc(Character.valueOf(',')).append(sg.show(p._7())).snoc(Character.valueOf(',')).append(sh.show(p._8())).snoc(Character.valueOf(')'));
            }
        });
    }

    public static <A> Show<V2<A>> v2Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V2.toStream_());
    }

    public static <A> Show<V3<A>> v3Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V3.toStream_());
    }

    public static <A> Show<V4<A>> v4Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V4.toStream_());
    }

    public static <A> Show<V5<A>> v5Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V5.toStream_());
    }

    public static <A> Show<V6<A>> v6Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V6.toStream_());
    }

    public static <A> Show<V7<A>> v7Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V7.toStream_());
    }

    public static <A> Show<V8<A>> v8Show(Show<A> ea) {
        return Show.streamShow(ea).comap(V8.toStream_());
    }

    public static <A> Show<Stream<A>> unlineShow(final Show<A> sa) {
        return new Show<Stream<A>>(new F<Stream<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Stream<A> as) {
                return Stream.join(as.map(sa.show_()).intersperse(Stream.fromString("\n")));
            }
        });
    }

    public static <E, L extends HList<L>> Show<HList.HCons<E, L>> HListShow(final Show<E> e, final Show<L> l) {
        return Show.show(new F<HList.HCons<E, L>, Stream<Character>>(){

            @Override
            public Stream<Character> f(HList.HCons<E, L> c) {
                return e.show(c.head()).cons(Character.valueOf('[')).append(l.show(c.tail())).snoc(Character.valueOf(']'));
            }
        });
    }
}

