/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.F;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.data.Iteratee;
import fj.data.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class IO<A> {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final F<Reader, IO<Unit>> closeReader = new F<Reader, IO<Unit>>(){

        @Override
        public IO<Unit> f(Reader r) {
            return IO.closeReader(r);
        }
    };

    public static IO<Unit> closeReader(final Reader r) {
        return new IO<Unit>(){

            @Override
            public Unit run() throws IOException {
                r.close();
                return Unit.unit();
            }
        };
    }

    public static <A> IO<Iteratee.IterV<String, A>> enumFileLines(File f, Option<Charset> encoding, Iteratee.IterV<String, A> i) {
        return IO.bracket(IO.bufferedReader(f, encoding), Function.vary(closeReader), Function.partialApply2(IO.<BufferedReader>lineReader(), i));
    }

    public static <A> IO<Iteratee.IterV<char[], A>> enumFileCharChunks(File f, Option<Charset> encoding, Iteratee.IterV<char[], A> i) {
        return IO.bracket(IO.fileReader(f, encoding), Function.vary(closeReader), Function.partialApply2(IO.<Reader>charChunkReader(), i));
    }

    public static <A> IO<Iteratee.IterV<Character, A>> enumFileChars(File f, Option<Charset> encoding, Iteratee.IterV<Character, A> i) {
        return IO.bracket(IO.fileReader(f, encoding), Function.vary(closeReader), Function.partialApply2(IO.<Reader>charChunkReader2(), i));
    }

    public static IO<BufferedReader> bufferedReader(File f, Option<Charset> encoding) {
        return IO.fileReader(f, encoding).map(new F<Reader, BufferedReader>(){

            @Override
            public BufferedReader f(Reader a) {
                return new BufferedReader(a);
            }
        });
    }

    public static IO<Reader> fileReader(final File f, final Option<Charset> encoding) {
        return new IO<Reader>(){

            @Override
            public Reader run() throws IOException {
                FileInputStream fis = new FileInputStream(f);
                return encoding.isNone() ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, (Charset)encoding.some());
            }
        };
    }

    public static final <A, B, C> IO<C> bracket(final IO<A> init, final F<A, IO<B>> fin, final F<A, IO<C>> body) {
        return new IO<C>(){

            @Override
            public C run() throws IOException {
                Object a = init.run();
                try {
                    Object a2 = ((IO)body.f(a)).run();
                    return a2;
                }
                catch (IOException e) {
                    throw e;
                }
                finally {
                    fin.f(a);
                }
            }
        };
    }

    public static final <A> IO<A> unit(final A a) {
        return new IO<A>(){

            @Override
            public A run() throws IOException {
                return a;
            }
        };
    }

    public static <A> F<BufferedReader, F<Iteratee.IterV<String, A>, IO<Iteratee.IterV<String, A>>>> lineReader() {
        final F isDone = new F<Iteratee.IterV<String, A>, Boolean>(){
            final F<P2<A, Iteratee.Input<String>>, P1<Boolean>> done = Function.constant(P.p(true));
            final F<F<Iteratee.Input<String>, Iteratee.IterV<String, A>>, P1<Boolean>> cont = Function.constant(P.p(false));

            @Override
            public Boolean f(Iteratee.IterV<String, A> i) {
                return i.fold(this.done, this.cont)._1();
            }
        };
        return new F<BufferedReader, F<Iteratee.IterV<String, A>, IO<Iteratee.IterV<String, A>>>>(){

            @Override
            public F<Iteratee.IterV<String, A>, IO<Iteratee.IterV<String, A>>> f(final BufferedReader r) {
                return new F<Iteratee.IterV<String, A>, IO<Iteratee.IterV<String, A>>>(){
                    final F<P2<A, Iteratee.Input<String>>, P1<Iteratee.IterV<String, A>>> done = Bottom.errorF("iteratee is done");

                    @Override
                    public IO<Iteratee.IterV<String, A>> f(final Iteratee.IterV<String, A> it) {
                        return new IO<Iteratee.IterV<String, A>>(){

                            @Override
                            public Iteratee.IterV<String, A> run() throws IOException {
                                Iteratee.IterV i = it;
                                while (!((Boolean)isDone.f(i)).booleanValue()) {
                                    String s = r.readLine();
                                    if (s == null) {
                                        return i;
                                    }
                                    Iteratee.Input<String> input = Iteratee.Input.el(s);
                                    F cont = Function.apply(input).lazy();
                                    i = (Iteratee.IterV)i.fold(done, cont)._1();
                                }
                                return i;
                            }
                        };
                    }
                };
            }
        };
    }

    public static <A> F<Reader, F<Iteratee.IterV<char[], A>, IO<Iteratee.IterV<char[], A>>>> charChunkReader() {
        final F isDone = new F<Iteratee.IterV<char[], A>, Boolean>(){
            final F<P2<A, Iteratee.Input<char[]>>, P1<Boolean>> done = Function.constant(P.p(true));
            final F<F<Iteratee.Input<char[]>, Iteratee.IterV<char[], A>>, P1<Boolean>> cont = Function.constant(P.p(false));

            @Override
            public Boolean f(Iteratee.IterV<char[], A> i) {
                return i.fold(this.done, this.cont)._1();
            }
        };
        return new F<Reader, F<Iteratee.IterV<char[], A>, IO<Iteratee.IterV<char[], A>>>>(){

            @Override
            public F<Iteratee.IterV<char[], A>, IO<Iteratee.IterV<char[], A>>> f(final Reader r) {
                return new F<Iteratee.IterV<char[], A>, IO<Iteratee.IterV<char[], A>>>(){
                    final F<P2<A, Iteratee.Input<char[]>>, P1<Iteratee.IterV<char[], A>>> done = Bottom.errorF("iteratee is done");

                    @Override
                    public IO<Iteratee.IterV<char[], A>> f(final Iteratee.IterV<char[], A> it) {
                        return new IO<Iteratee.IterV<char[], A>>(){

                            @Override
                            public Iteratee.IterV<char[], A> run() throws IOException {
                                Iteratee.IterV i = it;
                                while (!((Boolean)isDone.f(i)).booleanValue()) {
                                    char[] buffer = new char[4096];
                                    int numRead = r.read(buffer);
                                    if (numRead == -1) {
                                        return i;
                                    }
                                    if (numRead < buffer.length) {
                                        buffer = Arrays.copyOfRange(buffer, 0, numRead);
                                    }
                                    Iteratee.Input<char[]> input = Iteratee.Input.el(buffer);
                                    F cont = Function.apply(input).lazy();
                                    i = (Iteratee.IterV)i.fold(done, cont)._1();
                                }
                                return i;
                            }
                        };
                    }
                };
            }
        };
    }

    public static <A> F<Reader, F<Iteratee.IterV<Character, A>, IO<Iteratee.IterV<Character, A>>>> charChunkReader2() {
        final F isDone = new F<Iteratee.IterV<Character, A>, Boolean>(){
            final F<P2<A, Iteratee.Input<Character>>, P1<Boolean>> done = Function.constant(P.p(true));
            final F<F<Iteratee.Input<Character>, Iteratee.IterV<Character, A>>, P1<Boolean>> cont = Function.constant(P.p(false));

            @Override
            public Boolean f(Iteratee.IterV<Character, A> i) {
                return i.fold(this.done, this.cont)._1();
            }
        };
        return new F<Reader, F<Iteratee.IterV<Character, A>, IO<Iteratee.IterV<Character, A>>>>(){

            @Override
            public F<Iteratee.IterV<Character, A>, IO<Iteratee.IterV<Character, A>>> f(final Reader r) {
                return new F<Iteratee.IterV<Character, A>, IO<Iteratee.IterV<Character, A>>>(){
                    final F<P2<A, Iteratee.Input<Character>>, Iteratee.IterV<Character, A>> done = Bottom.errorF("iteratee is done");

                    @Override
                    public IO<Iteratee.IterV<Character, A>> f(final Iteratee.IterV<Character, A> it) {
                        return new IO<Iteratee.IterV<Character, A>>(){

                            @Override
                            public Iteratee.IterV<Character, A> run() throws IOException {
                                Iteratee.IterV i = it;
                                while (!((Boolean)isDone.f(i)).booleanValue()) {
                                    char[] buffer = new char[4096];
                                    int numRead = r.read(buffer);
                                    if (numRead == -1) {
                                        return i;
                                    }
                                    if (numRead < buffer.length) {
                                        buffer = Arrays.copyOfRange(buffer, 0, numRead);
                                    }
                                    for (int c = 0; c < buffer.length; ++c) {
                                        Iteratee.Input<Character> input = Iteratee.Input.el(Character.valueOf(buffer[c]));
                                        F cont = Function.apply(input);
                                        i = i.fold(done, cont);
                                    }
                                }
                                return i;
                            }
                        };
                    }
                };
            }
        };
    }

    public abstract A run() throws IOException;

    public final <B> IO<B> map(final F<A, B> f) {
        return new IO<B>(){

            @Override
            public B run() throws IOException {
                return f.f(IO.this.run());
            }
        };
    }

    public final <B> IO<B> bind(final F<A, IO<B>> f) {
        return new IO<B>(){

            @Override
            public B run() throws IOException {
                return ((IO)f.f(IO.this.run())).run();
            }
        };
    }
}

