/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Effect;
import fj.F;
import fj.data.Conversions;
import fj.data.List;
import fj.data.Option;
import java.util.Collection;
import java.util.Iterator;

public final class NonEmptyList<A>
implements Iterable<A> {
    public final A head;
    public final List<A> tail;

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    private NonEmptyList(A head, List<A> tail) {
        this.head = head;
        this.tail = tail;
    }

    public NonEmptyList<A> cons(A a) {
        return NonEmptyList.nel(a, this.tail.cons(this.head));
    }

    public NonEmptyList<A> append(NonEmptyList<A> as) {
        List.Buffer<A> b = new List.Buffer<A>();
        b.append(this.tail);
        b.snoc(as.head);
        b.append(as.tail);
        List bb = b.toList();
        return NonEmptyList.nel(this.head, bb);
    }

    public <B> NonEmptyList<B> map(F<A, B> f) {
        return NonEmptyList.nel(f.f(this.head), this.tail.map(f));
    }

    public <B> NonEmptyList<B> bind(final F<A, NonEmptyList<B>> f) {
        final List.Buffer<A> b = new List.Buffer<A>();
        NonEmptyList<B> p = f.f(this.head);
        b.snoc(p.head);
        b.append(p.tail);
        this.tail.foreach(new Effect<A>(){

            @Override
            public void e(A a) {
                NonEmptyList p = (NonEmptyList)f.f(a);
                b.snoc(p.head);
                b.append(p.tail);
            }
        });
        List bb = b.toList();
        return NonEmptyList.nel(bb.head(), bb.tail());
    }

    public NonEmptyList<NonEmptyList<A>> sublists() {
        return NonEmptyList.fromList(Option.somes(this.toList().toStream().substreams().map(new F<List<A>, Option<NonEmptyList<A>>>(){

            @Override
            public Option<NonEmptyList<A>> f(List<A> list) {
                return NonEmptyList.fromList(list);
            }
        }.o(Conversions.Stream_List())).toList())).some();
    }

    public NonEmptyList<NonEmptyList<A>> tails() {
        return NonEmptyList.fromList(Option.somes(this.toList().tails().map(new F<List<A>, Option<NonEmptyList<A>>>(){

            @Override
            public Option<NonEmptyList<A>> f(List<A> list) {
                return NonEmptyList.fromList(list);
            }
        }))).some();
    }

    public <B> NonEmptyList<B> mapTails(F<NonEmptyList<A>, B> f) {
        return this.tails().map(f);
    }

    public List<A> toList() {
        return this.tail.cons(this.head);
    }

    public Collection<A> toCollection() {
        return this.toList().toCollection();
    }

    public static <A> F<NonEmptyList<A>, List<A>> toList_() {
        return new F<NonEmptyList<A>, List<A>>(){

            @Override
            public List<A> f(NonEmptyList<A> as) {
                return as.toList();
            }
        };
    }

    public static <A> NonEmptyList<A> nel(A head, List<A> tail) {
        return new NonEmptyList<A>(head, tail);
    }

    public static <A> NonEmptyList<A> nel(A head) {
        return NonEmptyList.nel(head, List.nil());
    }

    public static <A> F<A, NonEmptyList<A>> nel() {
        return new F<A, NonEmptyList<A>>(){

            @Override
            public NonEmptyList<A> f(A a) {
                return NonEmptyList.nel(a);
            }
        };
    }

    public static <A> Option<NonEmptyList<A>> fromList(List<A> as) {
        return as.isEmpty() ? Option.none() : Option.some(NonEmptyList.nel(as.head(), as.tail()));
    }
}

