/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.Ord;
import fj.Ordering;
import fj.P;
import fj.P2;
import fj.P3;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Booleans;
import java.util.Iterator;

public abstract class Set<A>
implements Iterable<A> {
    private final Ord<A> ord;

    private Set(Ord<A> ord) {
        this.ord = ord;
    }

    public final boolean isEmpty() {
        return this instanceof Empty;
    }

    abstract Color color();

    abstract Set<A> l();

    abstract A head();

    abstract Set<A> r();

    public final Ord<A> ord() {
        return this.ord;
    }

    public final P2<Boolean, Set<A>> update(final A a, F<A, A> f) {
        return this.isEmpty() ? P.p(false, this) : (P2)this.tryUpdate(a, f).either(new F<A, P2<Boolean, Set<A>>>(){

            @Override
            public P2<Boolean, Set<A>> f(A a2) {
                return P.p(true, Set.this.delete(a).insert(a2));
            }
        }, Function.identity());
    }

    private Either<A, P2<Boolean, Set<A>>> tryUpdate(A a, F<A, A> f) {
        if (this.isEmpty()) {
            return Either.right(P.p(false, this));
        }
        if (this.ord.isLessThan(a, this.head())) {
            return super.tryUpdate(a, f).right().map(new F<P2<Boolean, Set<A>>, P2<Boolean, Set<A>>>(){

                @Override
                public P2<Boolean, Set<A>> f(P2<Boolean, Set<A>> set) {
                    return set._1() != false ? P.p(true, new Tree(Set.this.ord, Set.this.color(), set._2(), Set.this.head(), Set.this.r())) : set;
                }
            });
        }
        if (this.ord.eq(a, this.head())) {
            A h = f.f(this.head());
            return this.ord.eq(this.head(), h) ? Either.right(P.p(true, new Tree(this.ord, this.color(), this.l(), h, this.r()))) : Either.left(h);
        }
        return super.tryUpdate(a, f).right().map(new F<P2<Boolean, Set<A>>, P2<Boolean, Set<A>>>(){

            @Override
            public P2<Boolean, Set<A>> f(P2<Boolean, Set<A>> set) {
                return set._1() != false ? P.p(true, new Tree(Set.this.ord, Set.this.color(), Set.this.l(), Set.this.head(), set._2())) : set;
            }
        });
    }

    public static <A> Set<A> empty(Ord<A> ord) {
        return new Empty(ord);
    }

    public final boolean member(A x) {
        return !this.isEmpty() && (this.ord.isLessThan(x, this.head()) && this.l().member(x) || this.ord.eq(this.head(), x) || this.r().member(x));
    }

    public static <A> F<Set<A>, F<A, Boolean>> member() {
        return Function.curry(new F2<Set<A>, A, Boolean>(){

            @Override
            public Boolean f(Set<A> s, A a) {
                return s.member(a);
            }
        });
    }

    public final Set<A> insert(A x) {
        return super.makeBlack();
    }

    public static <A> F<A, F<Set<A>, Set<A>>> insert() {
        return Function.curry(new F2<A, Set<A>, Set<A>>(){

            @Override
            public Set<A> f(A a, Set<A> set) {
                return set.insert(a);
            }
        });
    }

    private Set<A> ins(A x) {
        return this.isEmpty() ? new Tree(this.ord, Color.R, Set.empty(this.ord), x, Set.empty(this.ord)) : (this.ord.isLessThan(x, this.head()) ? Set.balance(this.ord, this.color(), super.ins(x), this.head(), this.r()) : (this.ord.eq(x, this.head()) ? new Tree(this.ord, this.color(), this.l(), x, this.r()) : Set.balance(this.ord, this.color(), this.l(), this.head(), super.ins(x))));
    }

    private Set<A> makeBlack() {
        return new Tree(this.ord, Color.B, this.l(), this.head(), this.r());
    }

    private static <A> Tree<A> tr(Ord<A> o, Set<A> a, A x, Set<A> b, A y, Set<A> c, A z, Set<A> d) {
        return new Tree(o, Color.R, new Tree(o, Color.B, a, x, b), y, new Tree(o, Color.B, c, z, d));
    }

    private static <A> Set<A> balance(Ord<A> ord, Color c, Set<A> l, A h, Set<A> r) {
        return c == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, l.l().l(), l.l().head(), l.l().r(), l.head(), l.r(), h, r) : (c == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, l.l(), l.head(), l.r().l(), l.r().head(), l.r().r(), h, r) : (c == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, l, h, r.l().l(), r.l().head(), r.l().r(), r.head(), r.r()) : (c == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, l, h, r.l(), r.head(), r.r().l(), r.r().head(), r.r().r()) : new Tree(ord, c, l, h, r))));
    }

    private boolean isTR() {
        return !this.isEmpty() && this.color() == Color.R;
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toStream().iterator();
    }

    public static <A> Set<A> single(Ord<A> o, A a) {
        return Set.empty(o).insert(a);
    }

    public final <B> Set<B> map(Ord<B> o, F<A, B> f) {
        return Set.iterableSet(o, this.toStream().map(f));
    }

    public final <B> B foldMap(F<A, B> f, Monoid<B> m) {
        return this.isEmpty() ? m.zero() : m.sum(m.sum(this.r().foldMap(f, m), f.f(this.head())), this.l().foldMap(f, m));
    }

    public final List<A> toList() {
        return this.foldMap(List.cons(List.nil()), Monoid.listMonoid());
    }

    public final Stream<A> toStream() {
        return this.foldMap(Stream.single(), Monoid.streamMonoid());
    }

    public final <B> Set<B> bind(Ord<B> o, F<A, Set<B>> f) {
        return Set.join(o, this.map(Ord.setOrd(o), f));
    }

    public final Set<A> union(Set<A> s) {
        return Set.iterableSet(this.ord, s.toStream().append(this.toStream()));
    }

    public static <A> F<Set<A>, F<Set<A>, Set<A>>> union() {
        return Function.curry(new F2<Set<A>, Set<A>, Set<A>>(){

            @Override
            public Set<A> f(Set<A> s1, Set<A> s2) {
                return s1.union(s2);
            }
        });
    }

    public final Set<A> filter(F<A, Boolean> f) {
        return Set.iterableSet(this.ord, this.toStream().filter(f));
    }

    public final Set<A> delete(A a) {
        return this.minus(Set.single(this.ord, a));
    }

    public final F<A, F<Set<A>, Set<A>>> delete() {
        return Function.curry(new F2<A, Set<A>, Set<A>>(){

            @Override
            public Set<A> f(A a, Set<A> set) {
                return set.delete(a);
            }
        });
    }

    public final Set<A> intersect(Set<A> s) {
        return this.filter(Set.member().f(s));
    }

    public static <A> F<Set<A>, F<Set<A>, Set<A>>> intersect() {
        return Function.curry(new F2<Set<A>, Set<A>, Set<A>>(){

            @Override
            public Set<A> f(Set<A> s1, Set<A> s2) {
                return s1.intersect(s2);
            }
        });
    }

    public final Set<A> minus(Set<A> s) {
        return this.filter(Function.compose(Booleans.not, Set.member().f(s)));
    }

    public static <A> F<Set<A>, F<Set<A>, Set<A>>> minus() {
        return Function.curry(new F2<Set<A>, Set<A>, Set<A>>(){

            @Override
            public Set<A> f(Set<A> s1, Set<A> s2) {
                return s1.minus(s2);
            }
        });
    }

    public final int size() {
        F one = Function.constant(1);
        return this.foldMap(one, Monoid.intAdditionMonoid);
    }

    public final P3<Set<A>, Option<A>, Set<A>> split(A a) {
        if (this.isEmpty()) {
            return P.p(Set.empty(this.ord), Option.none(), Set.empty(this.ord));
        }
        A h = this.head();
        Ordering i = this.ord.compare(a, h);
        if (i == Ordering.LT) {
            P3<Set<A>, Option<A>, Set<A>> lg = this.l().split(a);
            return P.p(lg._1(), lg._2(), lg._3().insert(h).union(this.r()));
        }
        if (i == Ordering.GT) {
            P3<Set<A>, Option<A>, Set<A>> lg = this.r().split(a);
            return P.p(lg._1().insert(h).union(this.l()), lg._2(), lg._3());
        }
        return P.p(this.l(), Option.some(h), this.r());
    }

    public final boolean subsetOf(Set<A> s) {
        if (this.isEmpty() || s.isEmpty()) {
            return this.isEmpty();
        }
        P3<Set<A>, Option<A>, Set<A>> find = s.split(this.head());
        return find._2().isSome() && this.l().subsetOf(find._1()) && this.r().subsetOf(find._3());
    }

    public static <A> Set<A> join(Ord<A> o, Set<Set<A>> s) {
        F id = Function.identity();
        return s.foldMap(id, Monoid.setMonoid(o));
    }

    public static <A> Set<A> iterableSet(Ord<A> o, Iterable<A> as) {
        Set<A> s = Set.empty(o);
        for (A a : as) {
            s = s.insert(a);
        }
        return s;
    }

    public static <A> Set<A> set(Ord<A> o, A ... as) {
        Set<A> s = Set.empty(o);
        for (A a : as) {
            s = s.insert(a);
        }
        return s;
    }

    private static final class Tree<A>
    extends Set<A> {
        private final Color c;
        private final Set<A> a;
        private final A x;
        private final Set<A> b;

        private Tree(Ord<A> ord, Color c, Set<A> a, A x, Set<A> b) {
            super(ord);
            this.c = c;
            this.a = a;
            this.x = x;
            this.b = b;
        }

        @Override
        public Color color() {
            return this.c;
        }

        @Override
        public Set<A> l() {
            return this.a;
        }

        @Override
        public A head() {
            return this.x;
        }

        @Override
        public Set<A> r() {
            return this.b;
        }
    }

    private static final class Empty<A>
    extends Set<A> {
        private Empty(Ord<A> ord) {
            super(ord);
        }

        @Override
        public Color color() {
            return Color.B;
        }

        @Override
        public Set<A> l() {
            throw new Error("Left on empty set.");
        }

        @Override
        public Set<A> r() {
            throw new Error("Right on empty set.");
        }

        @Override
        public A head() {
            throw new Error("Head on empty set.");
        }
    }

    private static enum Color {
        R,
        B;

    }
}

