/*
 * Decompiled with CFR 0.152.
 */
package fj.data.fingertrees;

import fj.F;
import fj.Monoid;
import fj.P2;
import fj.data.fingertrees.Deep;
import fj.data.fingertrees.Empty;
import fj.data.fingertrees.MakeTree;
import fj.data.fingertrees.Measured;
import fj.data.fingertrees.Single;

public abstract class FingerTree<V, A> {
    private final Measured<V, A> m;

    public abstract <B> B foldRight(F<A, F<B, B>> var1, B var2);

    public abstract A reduceRight(F<A, F<A, A>> var1);

    public abstract <B> B foldLeft(F<B, F<A, B>> var1, B var2);

    public abstract A reduceLeft(F<A, F<A, A>> var1);

    public abstract <B> FingerTree<V, B> map(F<A, B> var1, Measured<V, B> var2);

    public abstract V measure();

    public final boolean isEmpty() {
        return this instanceof Empty;
    }

    Measured<V, A> measured() {
        return this.m;
    }

    public abstract <B> B match(F<Empty<V, A>, B> var1, F<Single<V, A>, B> var2, F<Deep<V, A>, B> var3);

    FingerTree(Measured<V, A> m) {
        this.m = m;
    }

    public static <V, A> Measured<V, A> measured(Monoid<V> monoid, F<A, V> measure) {
        return Measured.measured(monoid, measure);
    }

    public static <V, A> MakeTree<V, A> mkTree(Measured<V, A> m) {
        return new MakeTree<V, A>(m);
    }

    public abstract FingerTree<V, A> cons(A var1);

    public abstract FingerTree<V, A> snoc(A var1);

    public abstract FingerTree<V, A> append(FingerTree<V, A> var1);

    public abstract P2<Integer, A> lookup(F<V, Integer> var1, int var2);
}

