/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.example;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.util.Collections;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.java_websocket.server.WebSocketServer;

public class AutobahnSSLServerTest
extends WebSocketServer {
    private static int counter = 0;

    public AutobahnSSLServerTest(int port, Draft d) throws UnknownHostException {
        super(new InetSocketAddress(port), Collections.singletonList(d));
    }

    public AutobahnSSLServerTest(InetSocketAddress address, Draft d) {
        super(address, Collections.singletonList(d));
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        System.out.println("///////////Opened connection number" + ++counter);
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        System.out.println("closed");
    }

    public void onError(WebSocket conn, Exception ex) {
        System.out.println("Error:");
        ex.printStackTrace();
    }

    public void onStart() {
        System.out.println("Server started!");
    }

    public void onMessage(WebSocket conn, String message) {
        conn.send(message);
    }

    public void onMessage(WebSocket conn, ByteBuffer blob) {
        conn.send(blob);
    }

    public static void main(String[] args) throws UnknownHostException {
        int port;
        try {
            port = new Integer(args[0]);
        }
        catch (Exception e) {
            System.out.println("No port specified. Defaulting to 9003");
            port = 9003;
        }
        AutobahnSSLServerTest test = new AutobahnSSLServerTest(port, (Draft)new Draft_6455());
        try {
            String STORETYPE = "JKS";
            String KEYSTORE = "keystore.jks";
            String STOREPASSWORD = "storepassword";
            String KEYPASSWORD = "keypassword";
            KeyStore ks = KeyStore.getInstance(STORETYPE);
            File kf = new File(KEYSTORE);
            ks.load(new FileInputStream(kf), STOREPASSWORD.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, KEYPASSWORD.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            SSLContext sslContext = null;
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            test.setWebSocketFactory((WebSocketServerFactory)new DefaultSSLWebSocketServerFactory(sslContext));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        test.setConnectionLostTimeout(0);
        test.start();
    }
}

