/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.extensions;

import java.nio.ByteBuffer;
import org.java_websocket.extensions.DefaultExtension;
import org.java_websocket.extensions.IExtension;
import org.java_websocket.framing.BinaryFrame;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.TextFrame;
import org.junit.Assert;
import org.junit.Test;

public class DefaultExtensionTest {
    @Test
    public void testDecodeFrame() throws Exception {
        DefaultExtension defaultExtension = new DefaultExtension();
        BinaryFrame binaryFrame = new BinaryFrame();
        binaryFrame.setPayload(ByteBuffer.wrap("test".getBytes()));
        defaultExtension.decodeFrame((Framedata)binaryFrame);
        Assert.assertEquals((Object)ByteBuffer.wrap("test".getBytes()), (Object)binaryFrame.getPayloadData());
    }

    @Test
    public void testEncodeFrame() throws Exception {
        DefaultExtension defaultExtension = new DefaultExtension();
        BinaryFrame binaryFrame = new BinaryFrame();
        binaryFrame.setPayload(ByteBuffer.wrap("test".getBytes()));
        defaultExtension.encodeFrame((Framedata)binaryFrame);
        Assert.assertEquals((Object)ByteBuffer.wrap("test".getBytes()), (Object)binaryFrame.getPayloadData());
    }

    @Test
    public void testAcceptProvidedExtensionAsServer() throws Exception {
        DefaultExtension defaultExtension = new DefaultExtension();
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsServer("Test"));
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsServer(""));
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsServer("Test, ASDC, as, ad"));
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsServer("ASDC, as,ad"));
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsServer("permessage-deflate"));
    }

    @Test
    public void testAcceptProvidedExtensionAsClient() throws Exception {
        DefaultExtension defaultExtension = new DefaultExtension();
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsClient("Test"));
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsClient(""));
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsClient("Test, ASDC, as, ad"));
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsClient("ASDC, as,ad"));
        Assert.assertTrue((boolean)defaultExtension.acceptProvidedExtensionAsClient("permessage-deflate"));
    }

    @Test
    public void testIsFrameValid() throws Exception {
        DefaultExtension defaultExtension = new DefaultExtension();
        TextFrame textFrame = new TextFrame();
        try {
            defaultExtension.isFrameValid((Framedata)textFrame);
        }
        catch (Exception e) {
            Assert.fail((String)"This frame is valid");
        }
        textFrame.setRSV1(true);
        try {
            defaultExtension.isFrameValid((Framedata)textFrame);
            Assert.fail((String)"This frame is not valid");
        }
        catch (Exception exception) {
            // empty catch block
        }
        textFrame.setRSV1(false);
        textFrame.setRSV2(true);
        try {
            defaultExtension.isFrameValid((Framedata)textFrame);
            Assert.fail((String)"This frame is not valid");
        }
        catch (Exception exception) {
            // empty catch block
        }
        textFrame.setRSV2(false);
        textFrame.setRSV3(true);
        try {
            defaultExtension.isFrameValid((Framedata)textFrame);
            Assert.fail((String)"This frame is not valid");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetProvidedExtensionAsClient() throws Exception {
        DefaultExtension defaultExtension = new DefaultExtension();
        Assert.assertEquals((Object)"", (Object)defaultExtension.getProvidedExtensionAsClient());
    }

    @Test
    public void testGetProvidedExtensionAsServer() throws Exception {
        DefaultExtension defaultExtension = new DefaultExtension();
        Assert.assertEquals((Object)"", (Object)defaultExtension.getProvidedExtensionAsServer());
    }

    @Test
    public void testCopyInstance() throws Exception {
        DefaultExtension defaultExtension = new DefaultExtension();
        IExtension extensionCopy = defaultExtension.copyInstance();
        Assert.assertEquals((Object)defaultExtension, (Object)extensionCopy);
    }

    @Test
    public void testToString() throws Exception {
        DefaultExtension defaultExtension = new DefaultExtension();
        Assert.assertEquals((Object)"DefaultExtension", (Object)defaultExtension.toString());
    }

    @Test
    public void testHashCode() throws Exception {
        DefaultExtension defaultExtension0 = new DefaultExtension();
        DefaultExtension defaultExtension1 = new DefaultExtension();
        Assert.assertEquals((long)defaultExtension0.hashCode(), (long)defaultExtension1.hashCode());
    }

    @Test
    public void testEquals() throws Exception {
        DefaultExtension defaultExtension0 = new DefaultExtension();
        DefaultExtension defaultExtension1 = new DefaultExtension();
        Assert.assertEquals((Object)defaultExtension0, (Object)defaultExtension1);
        Assert.assertFalse((boolean)defaultExtension0.equals(null));
        Assert.assertFalse((boolean)defaultExtension0.equals(new Object()));
    }
}

