/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.framing;

import java.nio.ByteBuffer;
import org.java_websocket.enums.Opcode;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.DataFrame;
import org.java_websocket.framing.TextFrame;
import org.junit.Assert;
import org.junit.Test;

public class TextFrameTest {
    @Test
    public void testConstructor() {
        TextFrame frame = new TextFrame();
        Assert.assertEquals((String)"Opcode must be equal", (Object)Opcode.TEXT, (Object)frame.getOpcode());
        Assert.assertEquals((String)"Fin must be set", (Object)true, (Object)frame.isFin());
        Assert.assertEquals((String)"TransferedMask must not be set", (Object)false, (Object)frame.getTransfereMasked());
        Assert.assertEquals((String)"Payload must be empty", (long)0L, (long)frame.getPayloadData().capacity());
        Assert.assertEquals((String)"RSV1 must be false", (Object)false, (Object)frame.isRSV1());
        Assert.assertEquals((String)"RSV2 must be false", (Object)false, (Object)frame.isRSV2());
        Assert.assertEquals((String)"RSV3 must be false", (Object)false, (Object)frame.isRSV3());
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
    }

    @Test
    public void testExtends() {
        TextFrame frame = new TextFrame();
        Assert.assertEquals((String)"Frame must extend dataframe", (Object)true, (Object)(frame instanceof DataFrame));
    }

    @Test
    public void testIsValid() {
        TextFrame frame = new TextFrame();
        try {
            frame.isValid();
        }
        catch (InvalidDataException e) {
            Assert.fail((String)"InvalidDataException should not be thrown");
        }
        frame = new TextFrame();
        frame.setPayload(ByteBuffer.wrap(new byte[]{-48, -97, -47, -128, -48, -48, -78, -48, -75, -47, -126}));
        try {
            frame.isValid();
            Assert.fail((String)"InvalidDataException should be thrown");
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
    }
}

