/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.util;

import java.io.IOException;
import org.java_websocket.util.Base64;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class Base64Test {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testEncodeBytes() throws IOException {
        Assert.assertEquals((Object)"", (Object)Base64.encodeBytes((byte[])new byte[0]));
        Assert.assertEquals((Object)"QHE=", (Object)Base64.encodeBytes((byte[])new byte[]{49, 121, 64, 113, -63, 43, -24, 62, 4, 48}, (int)2, (int)2, (int)0));
    }

    @Test
    public void testEncodeBytes2() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        Base64.encodeBytes((byte[])new byte[0], (int)-2, (int)-2, (int)-56);
    }

    @Test
    public void testEncodeBytes3() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        Base64.encodeBytes((byte[])new byte[]{64, -128, 32, 18, 16, 16, 0, 18, 16}, (int)2064072977, (int)-2064007440, (int)10);
    }

    @Test
    public void testEncodeBytes4() {
        this.thrown.expect(NullPointerException.class);
        Base64.encodeBytes(null);
    }

    @Test
    public void testEncodeBytes5() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        Base64.encodeBytes(null, (int)32766, (int)0, (int)8);
    }

    @Test
    public void testEncodeBytesToBytes1() throws IOException {
        Assert.assertArrayEquals((byte[])new byte[]{95, 68, 111, 78, 55, 45, 61, 61}, (byte[])Base64.encodeBytesToBytes((byte[])new byte[]{-108, -19, 24, 32}, (int)0, (int)4, (int)32));
        Assert.assertArrayEquals((byte[])new byte[]{95, 68, 111, 78, 55, 67, 111, 61}, (byte[])Base64.encodeBytesToBytes((byte[])new byte[]{-108, -19, 24, 32, -35}, (int)0, (int)5, (int)40));
        Assert.assertArrayEquals((byte[])new byte[]{95, 68, 111, 78, 55, 67, 111, 61}, (byte[])Base64.encodeBytesToBytes((byte[])new byte[]{-108, -19, 24, 32, -35}, (int)0, (int)5, (int)32));
        Assert.assertArrayEquals((byte[])new byte[]{87, 50, 77, 61}, (byte[])Base64.encodeBytesToBytes((byte[])new byte[]{115, 42, 123, 99, 10, -33, 75, 30, 91, 99}, (int)8, (int)2, (int)48));
        Assert.assertArrayEquals((byte[])new byte[]{87, 50, 77, 61}, (byte[])Base64.encodeBytesToBytes((byte[])new byte[]{115, 42, 123, 99, 10, -33, 75, 30, 91, 99}, (int)8, (int)2, (int)56));
        Assert.assertArrayEquals((byte[])new byte[]{76, 53, 66, 61}, (byte[])Base64.encodeBytesToBytes((byte[])new byte[]{113, 42, 123, 99, 10, -33, 75, 30, 88, 99}, (int)8, (int)2, (int)36));
        Assert.assertArrayEquals((byte[])new byte[]{87, 71, 77, 61}, (byte[])Base64.encodeBytesToBytes((byte[])new byte[]{113, 42, 123, 99, 10, -33, 75, 30, 88, 99}, (int)8, (int)2, (int)4));
    }

    @Test
    public void testEncodeBytesToBytes2() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        Base64.encodeBytesToBytes((byte[])new byte[]{83, 10, 91, 67, 42, -1, 107, 62, 91, 67}, (int)8, (int)6, (int)26);
    }
}

