/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketServerTest {
    @Test
    public void testConstructor() {
        MyWebSocketServer server2;
        List<Draft_6455> draftCollection = Collections.singletonList(new Draft_6455());
        HashSet<WebSocket> webSocketCollection = new HashSet<WebSocket>();
        InetSocketAddress inetAddress = new InetSocketAddress(1337);
        try {
            server2 = new MyWebSocketServer(null, 1, draftCollection, webSocketCollection);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException server2) {
            // empty catch block
        }
        try {
            server2 = new MyWebSocketServer(inetAddress, 0, draftCollection, webSocketCollection);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException server3) {
            // empty catch block
        }
        try {
            server2 = new MyWebSocketServer(inetAddress, -1, draftCollection, webSocketCollection);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException server4) {
            // empty catch block
        }
        try {
            server2 = new MyWebSocketServer(inetAddress, Integer.MIN_VALUE, draftCollection, webSocketCollection);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException server5) {
            // empty catch block
        }
        try {
            server2 = new MyWebSocketServer(inetAddress, Integer.MIN_VALUE, draftCollection, webSocketCollection);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException server6) {
            // empty catch block
        }
        try {
            server2 = new MyWebSocketServer(inetAddress, 1, draftCollection, null);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException server7) {
            // empty catch block
        }
        try {
            server2 = new MyWebSocketServer(inetAddress, 1, draftCollection, webSocketCollection);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should not fail");
        }
        try {
            MyWebSocketServer e = new MyWebSocketServer(inetAddress, 1, null, webSocketCollection);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should not fail");
        }
    }

    @Test
    public void testGetAddress() throws IOException {
        int port = SocketUtil.getAvailablePort();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(port);
        MyWebSocketServer server = new MyWebSocketServer(port);
        Assert.assertEquals((Object)inetSocketAddress, (Object)server.getAddress());
    }

    @Test
    public void testGetDrafts() {
        List<Draft_6455> draftCollection = Collections.singletonList(new Draft_6455());
        HashSet<WebSocket> webSocketCollection = new HashSet<WebSocket>();
        InetSocketAddress inetAddress = new InetSocketAddress(1337);
        MyWebSocketServer server = new MyWebSocketServer(inetAddress, 1, draftCollection, webSocketCollection);
        Assert.assertEquals((long)1L, (long)server.getDraft().size());
        Assert.assertEquals((Object)draftCollection.get(0), server.getDraft().get(0));
    }

    @Test
    public void testGetPort() throws IOException, InterruptedException {
        int port = SocketUtil.getAvailablePort();
        CountDownLatch countServerDownLatch = new CountDownLatch(1);
        MyWebSocketServer server = new MyWebSocketServer(port);
        Assert.assertEquals((long)port, (long)server.getPort());
        server = new MyWebSocketServer(0, countServerDownLatch);
        Assert.assertEquals((long)0L, (long)server.getPort());
        server.start();
        countServerDownLatch.await();
        Assert.assertNotEquals((long)0L, (long)server.getPort());
    }

    @Test
    public void testBroadcast() {
        MyWebSocketServer server = new MyWebSocketServer(1337);
        try {
            server.broadcast(null, Collections.emptyList());
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            server.broadcast(null, Collections.emptyList());
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            server.broadcast(null, Collections.emptyList());
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            server.broadcast(new byte[]{-48}, null);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            server.broadcast(ByteBuffer.wrap(new byte[]{-48}), null);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            server.broadcast("", null);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            server.broadcast("", Collections.emptyList());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should not fail");
        }
    }

    private static class MyWebSocketServer
    extends WebSocketServer {
        private CountDownLatch serverLatch = null;

        public MyWebSocketServer(InetSocketAddress address, int decodercount, List<Draft> drafts, Collection<WebSocket> connectionscontainer) {
            super(address, decodercount, drafts, connectionscontainer);
        }

        public MyWebSocketServer(int port, CountDownLatch serverLatch) {
            super(new InetSocketAddress(port));
            this.serverLatch = serverLatch;
        }

        public MyWebSocketServer(int port) {
            this(port, null);
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        }

        public void onMessage(WebSocket conn, String message) {
        }

        public void onError(WebSocket conn, Exception ex) {
            ex.printStackTrace();
        }

        public void onStart() {
            if (this.serverLatch != null) {
                this.serverLatch.countDown();
            }
        }
    }
}

