/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.eclipsesource.v8.NodeJS;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.utils.MemoryManager;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jooby.Route;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nodejs {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClassLoader loader;
    private File basedir;
    private NodeJS node;
    private MemoryManager scope;
    private Set<StandardCopyOption> coptions = Collections.emptySet();

    public Nodejs(File basedir, ClassLoader loader) {
        this.basedir = Objects.requireNonNull(basedir, "Basedir required.");
        this.loader = Objects.requireNonNull(loader, "ClassLoader required.");
        this.node = NodeJS.createNodeJS();
        V8 v8 = this.node.getRuntime();
        this.scope = new MemoryManager(v8);
    }

    public Nodejs(File basedir) {
        this(basedir, Nodejs.class.getClassLoader());
    }

    public Nodejs() {
        this(new File(System.getProperty("java.io.tmpdir")));
    }

    public Nodejs overwrite(boolean overwrite) {
        this.coptions = overwrite ? EnumSet.of(StandardCopyOption.REPLACE_EXISTING) : Collections.emptySet();
        return this;
    }

    public void exec(String library) throws Throwable {
        this.exec(library, (Throwing.Consumer<V8>)((Throwing.Consumer)v8 -> {}));
    }

    public void exec(String library, Throwing.Consumer<V8> callback) throws Throwable {
        Path basedir = this.deploy(library);
        List<String> candidates = Arrays.asList(basedir.getFileName().toString() + ".js", "main.js", "index.js");
        Path main = candidates.stream().map(it -> basedir.resolve((String)it)).filter(it -> it.toFile().exists()).findFirst().orElseThrow(() -> new FileNotFoundException(candidates.toString()));
        callback.accept((Object)this.node.getRuntime());
        this.node.exec(main.toFile());
        while (this.node.isRunning()) {
            this.node.handleMessage();
        }
    }

    public void release() {
        Try.run(() -> ((MemoryManager)this.scope).release());
        this.node.release();
    }

    public Path deploy(String library) throws Exception {
        URL url = this.loader.getResource(library);
        if (url == null) {
            throw new FileNotFoundException(library);
        }
        URI uri = url.toURI();
        this.log.debug("{}", (Object)uri);
        Path outdir = this.basedir.toPath().resolve("node_modules").resolve(library.replace("/", "."));
        Optional basedir = Try.apply(() -> Paths.get(uri)).toOptional();
        String libroot = Route.normalize((String)("/" + library));
        try (Library lib = this.loadLibrary(uri);
             Stream<Path> stream = lib.stream();){
            stream.filter(it -> !Files.isDirectory(it, new LinkOption[0])).forEach(it -> {
                boolean copy;
                String relative = basedir.map(d -> d.relativize((Path)it).toString()).orElseGet(() -> {
                    String fname = it.toString();
                    if (fname.startsWith(libroot)) {
                        fname = fname.substring(libroot.length());
                    }
                    return fname.substring(1);
                });
                Path output = outdir.resolve(relative);
                File fout = output.toFile();
                boolean bl = copy = !fout.exists() || this.coptions.contains(StandardCopyOption.REPLACE_EXISTING);
                if (copy) {
                    this.log.debug("copying {} to {}", it, (Object)fout);
                    fout.getParentFile().mkdirs();
                    StandardCopyOption[] coptions = this.coptions.toArray(new StandardCopyOption[this.coptions.size()]);
                    Try.run(() -> Files.copy(it, output, (CopyOption[])coptions)).onFailure(x -> this.log.error("can't copy {}", it, x));
                }
            });
        }
        return outdir;
    }

    private Library loadLibrary(URI lib) {
        return (Library)Try.apply(() -> FileSystems.newFileSystem(lib, Maps.newHashMap())).map(it -> (Library)Try.apply(() -> new Library((FileSystem)it)).get()).recover(x -> (Library)Try.apply(() -> new Library(Paths.get(lib))).get()).get();
    }

    public static void run(Throwing.Consumer<Nodejs> callback) {
        Nodejs.run(new File(System.getProperty("java.io.tmpdir")), callback);
    }

    public static void run(File basedir, Throwing.Consumer<Nodejs> callback) {
        Nodejs node = new Nodejs(basedir);
        try {
            callback.accept((Object)node);
        }
        catch (Throwable x) {
            throw Throwables.propagate((Throwable)x);
        }
        finally {
            node.release();
        }
    }

    private static class Library
    implements Closeable {
        private Closeable closer;
        private Path root;

        private Library(Path path) {
            this.closer = null;
            this.root = path;
        }

        private Library(FileSystem fs) throws IOException {
            this.closer = fs;
            this.root = fs.getPath("/", new String[0]);
        }

        @Override
        public void close() throws IOException {
            if (this.closer != null) {
                this.closer.close();
            }
        }

        public Stream<Path> stream() throws IOException {
            return Files.walk(this.root, new FileVisitOption[0]);
        }
    }
}

